/* MCGLC1.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmcglc1_(ndimax, ndimen, ncoeff, courbe, tdebut, tfinal, 
	epsiln, xlongc, erreur, iercod)
integer *ndimax, *ndimen, *ncoeff;
doublereal *courbe, *tdebut, *tfinal, *epsiln, *xlongc, *erreur;
integer *iercod;
{
    /* System generated locals */
    integer courbe_dim1, courbe_offset, i__1;
    doublereal d__1;

    /* Local variables */
    static integer ndec;
    static doublereal tdeb, tfin;
    static integer iter;
    static doublereal oldso;
    static integer itmax;
    static doublereal sottc;
    static integer kk, ibb;
    static doublereal dif, pas;
    extern integer mnfndeb_();
    static doublereal som;
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mmloncv_(), mgsomsg_()
	    ;




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*      Permet de calculer la longueur d'un arc de courbe POLYNOMIAL */
/*      sur un intervalle [A,B] quelconque. */

/*     MOTS CLES : */
/*     ----------- */
/*        LONGUEUR,COURBE,GAUSS,PRIVE. */

/*     ARGUMENTS DD'ENTREE : */
/*     ------------------ */
/*      NDIMAX : Nombre de lignes maximum des tableaux */
/*               (i.e. nbre maxi des polynomes). */
/*      NDIMEN : Dimension de l'espace (nbre de polynomes). */
/*      NCOEFF : Nombre de coefficients du polynome. C'est le degre + 1. 
*/
/*      COURBE(NDIMAX,NCOEFF) : Coefficients de la courbe. */
/*      TDEBUT : Borne inferieure de l'intervalle d'integration pour */
/*               le calcul de la longueur. */
/*      TFINAL : Borne superieure de l'intervalle d'integration pour */
/*               le calcul de la longueur. */
/*      EPSILN : Precision DEMANDEE sur le calcul de la longueur. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*      XLONGC : Longueur de l'arc de courbe */
/*      ERREUR : Precision OBTENUE sur le calcul de la longueur. */
/*      IERCOD : Code d' erreur, 0 OK, >0 Erreur grave. */
/*               = 1 Trop d'iterations, on sort le meilleur resultat */
/*                   calcule (a ERREUR pres) */
/*               = 2 Pb MMLONCV (pas de resultat) */
/*               = 3 NDIM ou NCOEFF invalides (pas de resultat) */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*      Le polynome est en fait un ensemble de polynomes dont les */
/*      coefficients sont ranges dans un tableau a 2 indices, chaque */
/*      ligne etant relative a 1 polynome. */
/*      Le polynome est defini par ses coefficients ordonne par les */
/*      puissances croissantes de la variable. */
/*      Tous les polynomes ont le meme nombre de coefficients (donc le */
/*      meme degre). */

/*      Ce programme annule et remplace LENGCV, MLONGC et MLENCV. */

/*      ATTENTION : si TDEBUT > TFINAL, la longueur est alors NEGATIVE. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     22-04-1991: ALR; ITMAX en dur a 13 */
/*     14-05-1990: RBD; Appel MITERR au lieu de MEPSNR pour ITMAX */
/*     26-04-1990: RBD; Creation. */
/* > */
/* ***********************************************************************
 */

/*   Le nom de la routine */


/* ------------------------ Initialisation generale --------------------- 
*/

    /* Parameter adjustments */
    courbe_dim1 = *ndimax;
    courbe_offset = courbe_dim1 + 1;
    courbe -= courbe_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 2) {
	mgenmsg_("MMCGLC1", 7L);
    }

    *iercod = 0;
    *xlongc = 0.;
    *erreur = 0.;

/* ------ Test d'egalite des bornes */

    if (*tdebut == *tfinal) {
	*iercod = 0;
	goto L9999;
    }

/* ------ Test de la dimension et du nombre de coefficients */

    if (*ndimen <= 0 || *ncoeff <= 0) {
	goto L9003;
    }

/* ------ Nbre de decoupe en cours, nbre d'iteration, */
/*       nbre max d'iterations */

    ndec = 1;
    iter = 1;

/* ALR     NE PAS APPELER DE NOMBRE D ITERATION VENANT */
/*        D'ON NE SAIT OU !! 8 EST MIS EN DUR EXPRES !! */

    itmax = 13;

/* ------ Variation du nombre d'intervalles */
/*       On multiplie par 2 a chaque iteration */

L5000:
    pas = (*tfinal - *tdebut) / ndec;
    sottc = 0.;

/* ------ Boucle sur tous les NDEC intervalles en cours */

    i__1 = ndec;
    for (kk = 1; kk <= i__1; ++kk) {

/* ------ Bornes de l'intervalle d'integration en cours */

	tdeb = *tdebut + (kk - 1) * pas;
	tfin = tdeb + pas;
	mmloncv_(ndimax, ndimen, ncoeff, &courbe[courbe_offset], &tdeb, &tfin,
		 &som, iercod);
	if (*iercod > 0) {
	    goto L9002;
	}

	sottc += som;

/* L100: */
    }


/* ----------------- Test sur le nombre maximum d'iterations ------------ 
*/

/*  Test si passe au moins 1 fois ** */

    if (iter == 1) {
	oldso = sottc;
	ndec <<= 1;
	++iter;
	goto L5000;
    } else {

/* ------ Prise en compte du DIF - Test de convergence */

	++iter;
	dif = (d__1 = sottc - oldso, abs(d__1));

/* ------ Si DIF est OK, on va sortir..., sinon: */

	if (dif > *epsiln) {

/* ------ Si nbre iteration depasse, on sort */

	    if (iter > itmax) {
		*iercod = 1;
		goto L9000;
	    } else {

/* ------ Sinon on continue en decoupant l'intervalle initial.
 */

		oldso = sottc;
		ndec <<= 1;
		goto L5000;
	    }
	}
    }

/* ------------------------------ THE END ------------------------------- 
*/

L9000:
    *xlongc = sottc;
    *erreur = dif;
    goto L9999;

/* ---> PB dans MMLONCV */

L9002:
    *iercod = 2;
    goto L9999;

/* ---> NCOEFF ou NDIM invalides. */

L9003:
    *iercod = 3;
    goto L9999;

L9999:
    if (*iercod > 0) {
	maermsg_("MMCGLC1", iercod, 7L);
    }
    if (ibb >= 2) {
	mgsomsg_("MMCGLC1", 7L);
    }
    return 0;
} /* mmcglc1_ */

