/* MFMCB1.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mmfmcb1_(ncofmx, ndimen, courb1, ncoeff, blodf1, courb2, 
	blodf2, iercod)
integer *ncofmx, *ndimen;
doublereal *courb1;
integer *ncoeff;
doublereal *blodf1, *courb2, *blodf2;
integer *iercod;
{
    /* System generated locals */
    integer courb1_dim1, courb1_offset, courb2_dim1, courb2_offset, i__1, 
	    i__2, i__3;
    doublereal d__1;

    /* Local variables */
    static integer nboct;
    static doublereal tbaux[61], x0, x1;
    static integer nd;
    extern /* Subroutine */ int mmfmcb3_(), mmfmcb4_();
    static integer ibb;
    static doublereal bid;
    static integer ncf;
    extern /* Subroutine */ int mmveps3_();
    static integer ncj;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mcrfill_(), maermsg_(), mgenmsg_(), mgsomsg_()
	    ;
    static doublereal eps3;



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Creation de la courbe COURB2(v) definie sur [BLODF2(1),BLODF2(2)] 
*/
/*     identique a la courbe COURB1(u) definie sur [BLODF1(1),BLODF1(2)] 
*/
/*     (changement du parametre d' une courbe (NCOFMX,NDIMEN) ) */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS,MATH_ACCES::COURBE&,LIMITATION,&COURBE */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*   NCOFMX : Nbre de coefficient maxi de la courbe. */
/*   NDIMEN   : Dimension de la courbe. */
/*   COURB1 : La courbe a limiter. */
/*   NCOEFF : Nbre de coefficients de la courbe. */
/*   BLODF1(1) : Borne min de l' intervalle de definition de la courbe. */
/*   BLODF1(2) : Borne max de l' intervalle de definition de la courbe. */
/*   BLODF2(1) : Borne min de l' intervalle de restriction de la courbe. 
*/
/*   BLODF2(2) : Borne max de l' intervalle de restriction de la courbe. 
*/

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*   COURB2 : La courbe relimitee, definie dans [BLODF2(1),BLODF2(2)] */
/*            et egale a COURB1 definie dans [BLODF1(1),BLODF1(2)]. */
/*   IERCOD : = 0, OK */
/*            =10, Nbre de coeff. <1 ou > 61. */
/*            =13, L' intervalle de variation demande est quasi-nul */
/*                 (Voir BLODF2). */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/* ---> L' ecrasement de l' argument d' entree COURB1 par COURB2 est */
/*     possible, c' est a dire que l' appel : */
/*      CALL MMFMCB1(NCOFMX,NDIMEN,CURVE,NCOEFF,BLODF1,CURVE,BLODF2 */
/*                 ,IERCOD) */
/*     est tout a fait LEGAL. */

/* ---> On traite les courbes de degres mathematique 0 a 60, pour NDIMEN 
*/
/*     quelconque. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*        02-10-1989 : RBD ; Creation d' apres MMARC41. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */

/*   Tableau auxiliaire des coefficients de X1*T+X0 a */
/*   la puissance N=1 a NCOEFF-1. */


    /* Parameter adjustments */
    courb2_dim1 = *ncofmx;
    courb2_offset = courb2_dim1 + 1;
    courb2 -= courb2_offset;
    courb1_dim1 = *ncofmx;
    courb1_offset = courb1_dim1 + 1;
    courb1 -= courb1_offset;
    --blodf1;
    --blodf2;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMFMCB1", 7L);
    }
    *iercod = 0;

/* ********************************************************************** 
*/
/*                CAS PARTICULIERS OU LE TRAITEMENT EST ACCELERE */
/* ********************************************************************** 
*/
/* ------------------------- [u0,u1] vers [u0,u1] ----------------------- 
*/

    if (blodf1[1] == blodf2[1] && blodf1[2] == blodf2[2]) {
	nboct = (*ncofmx << 3) * *ndimen;
	mcrfill_(&nboct, &courb1[courb1_offset], &courb2[courb2_offset]);
	goto L9999;

/* --------------------------- [0,1] vers [-1,1] --------------------
---- */

    } else if (blodf1[1] == 0. && blodf1[2] == 1. && blodf2[1] == -1. && 
	    blodf2[2] == 1.) {
	mmfmcb3_(ncofmx, ndimen, &courb1[courb1_offset], ncoeff, &courb2[
		courb2_offset], iercod);
	goto L9999;

/* --------------------------- [-1,1] vers [0,1] --------------------
---- */

    } else if (blodf2[1] == 0. && blodf2[2] == 1. && blodf1[1] == -1. && 
	    blodf1[2] == 1.) {
	mmfmcb4_(ncofmx, ndimen, &courb1[courb1_offset], ncoeff, &courb2[
		courb2_offset], iercod);
	goto L9999;
    }

/* ********************************************************************** 
*/
/*                CAS OU LE TRAITEMENT NE PEUT ETRE FAIT */
/* ********************************************************************** 
*/
/* On teste au zero machine que l' intervalle d' arrivee n' est pas nul */

    mmveps3_(&eps3);
    if ((d__1 = blodf2[2] - blodf2[1], abs(d__1)) < eps3) {
	*iercod = 13;
	goto L9999;
    }

/* ------------ Nbre de coefficients trop petit ou trop grand ----------- 
*/

    if (*ncoeff > 61 || *ncoeff < 1) {
	*iercod = 10;
	goto L9999;
    }

/* ********************************************************************** 
*/
/*            CALCUL DES INTERVALLES DE TRANSFORMATION */
/* ********************************************************************** 
*/
/* ------------ Cas ou le nouvel intervalle de definition est [0,1] ----- 
*/

    if (blodf2[1] == 0. && blodf2[2] == 1.) {
	x0 = blodf1[1];
	x1 = blodf1[2] - x0;

/* ------------ Cas general : on se ramene a une transformation -----
---- */
/* ------------------------ de [X0,X0+X1] dans [0,1] ----------------
---- */

    } else {
	x0 = (blodf2[2] * blodf1[1] - blodf2[1] * blodf1[2]) / (blodf2[2] - 
		blodf2[1]);
	x1 = (blodf1[2] - blodf1[1]) / (blodf2[2] - blodf2[1]);
    }

/* ********************************************************************** 
*/
/*                          TRAITEMENT */
/* ********************************************************************** 
*/

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	courb2[nd * courb2_dim1 + 1] = courb1[nd * courb1_dim1 + 1];
/* L100: */
    }
    if (*ncoeff == 1) {
	goto L9999;
    }
    tbaux[0] = x0;
    tbaux[1] = x1;

/* ----------------------- Calcul des coeff. de COURB2 ------------------ 
*/

    i__1 = *ncoeff - 1;
    for (ncf = 2; ncf <= i__1; ++ncf) {

/* ------------ Prise en compte du NCF-ieme coeff. de COURB1 --------
---- */

	i__2 = *ndimen;
	for (nd = 1; nd <= i__2; ++nd) {
	    bid = courb1[ncf + nd * courb1_dim1];
	    i__3 = ncf - 1;
	    for (ncj = 1; ncj <= i__3; ++ncj) {
		courb2[ncj + nd * courb2_dim1] += bid * tbaux[ncj - 1];
/* L400: */
	    }
	    courb2[ncf + nd * courb2_dim1] = bid * tbaux[ncf - 1];
/* L300: */
	}


/* --------- Calcul des (NCF+1) coeff. de [X1*t + X0]**(NCF) --------
---- */

	tbaux[ncf] = tbaux[ncf - 1] * x1;
	for (ncj = ncf; ncj >= 2; --ncj) {
	    tbaux[ncj - 1] = tbaux[ncj - 1] * x0 + tbaux[ncj - 2] * x1;
/* L500: */
	}
	tbaux[0] *= x0;

/* L200: */
    }

/* -------------- Prise en compte du dernier coeff. de COURB1 ----------- 
*/

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	bid = courb1[*ncoeff + nd * courb1_dim1];
	i__2 = *ncoeff - 1;
	for (ncj = 1; ncj <= i__2; ++ncj) {
	    courb2[ncj + nd * courb2_dim1] += tbaux[ncj - 1] * bid;
/* L700: */
	}
	courb2[*ncoeff + nd * courb2_dim1] = bid * tbaux[*ncoeff - 1];
/* L600: */
    }

/* ---------------------------- The end --------------------------------- 
*/

L9999:
    if (*iercod > 0) {
	maermsg_("MMFMCB1", iercod, 7L);
    }
    if (ibb >= 3) {
	mgsomsg_("MMFMCB1", 7L);
    }
    return 0;
} /* mmfmcb1_ */

