/* MRSLWD.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmmrslwd_(normax, nordre, ndim, amat, bmat, epspiv, aaux,
	 xmat, iercod)
integer *normax, *nordre, *ndim;
doublereal *amat, *bmat, *epspiv, *aaux, *xmat;
integer *iercod;
{
    /* System generated locals */
    integer amat_dim1, amat_offset, bmat_dim1, bmat_offset, xmat_dim1, 
	    xmat_offset, aaux_dim1, aaux_offset, i__1, i__2;

    /* Local variables */
    static integer i__, j;
    extern /* Subroutine */ int mmrslw_();
    static integer ibb;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();


/*      IMPLICIT DOUBLE PRECISION (A-H,O-Z) */
/*      IMPLICIT INTEGER (I-N) */


/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*        Resolution d' un systeme lineaire par la methode de Gauss ou */
/*        le second membre est un tableau de vecteurs. Methode du pivot */
/*        partiel. */

/*     MOTS CLES : */
/*     ----------- */
/*        TOUS , MATH_ACCES :: */
/*        SYSTEME&,EQUATION&, RESOLUTION,GAUSS ,&VECTEUR */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NORMAX : Dimensionnement maxi de AMAT. */
/*        NORDRE :  Ordre de la matrice. */
/*        NDIM : Nombre de colonnes de BMAT et XMAT. */
/*        AMAT(NORMAX,NORDRE) : La matrice traitee. */
/*        BMAT(NORMAX,NDIM) : La matrice des second membre. */
/*        XMAT(NORMAX,NDIM) : La matrice des solutions. */
/*        EPSPIV : Valeur minimale d'un pivot. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        AAUX(NORDRE+NDIM,NORDRE) : Matrice auxiliaire. */
/*        XMAT(NORMAX,NDIM) : La matrice des solutions. */
/*        IERCOD=0 indique que les solutions dans XMAT sont valables. */
/*        IERCOD=1 indique que la matrice AMAT est de rang inferieur */
/*                 a NORDRE. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*      .Neant. */

/*     REFERENCES APPELEES   : */
/*     ---------------------- */
/*     Type  Name */
/*           MAERMSG              MGENMSG              MGSOMSG */
/*           MMRSLW          I*4  MNFNDEB */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*    ATTENTION :les lignes et les colonnes sont dans l' ordre */
/*               habituel : */
/*               1er indice  = indice ligne */
/*               2eme indice = indice colonne */
/*    Exemple, Le systeme : */
/*                 a1*x + b1*y = c1 */
/*                 a2*x + b2*y = c2 */
/*    est represente par la matrice AMAT : */

/*                 AMAT(1,1) = a1  AMAT(2,1) = a2 */
/*                 AMAT(1,2) = b1  AMAT(2,2) = b2 */

/*     Le premier indice est l' indice de ligne, le second indice */
/*     est l' indice des colonnes (Comparer avec MMRSLWI qui est */
/*     plus rapide). */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     11-09-1995 : JMF ; Implicit none */
/*     22-02-1988 : JJM ; Appel MFNDEB -> MNFNDEB */
/*     22-02-1988 : JJM ; Appel GERMSG -> MAERMSG */
/*     17-09-1987: Cree par RBD */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */

    /* Parameter adjustments */
    amat_dim1 = *normax;
    amat_offset = amat_dim1 + 1;
    amat -= amat_offset;
    xmat_dim1 = *normax;
    xmat_offset = xmat_dim1 + 1;
    xmat -= xmat_offset;
    aaux_dim1 = *nordre + *ndim;
    aaux_offset = aaux_dim1 + 1;
    aaux -= aaux_offset;
    bmat_dim1 = *normax;
    bmat_offset = bmat_dim1 + 1;
    bmat -= bmat_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMMRSLW", 7L);
    }

/*   Initialisation de la matrice auxiliaire. */

    i__1 = *nordre;
    for (i__ = 1; i__ <= i__1; ++i__) {
	i__2 = *nordre;
	for (j = 1; j <= i__2; ++j) {
	    aaux[j + i__ * aaux_dim1] = amat[i__ + j * amat_dim1];
/* L200: */
	}
/* L100: */
    }

/*    Second membre. */

    i__1 = *nordre;
    for (i__ = 1; i__ <= i__1; ++i__) {
	i__2 = *ndim;
	for (j = 1; j <= i__2; ++j) {
	    aaux[j + *nordre + i__ * aaux_dim1] = bmat[i__ + j * bmat_dim1];
/* L400: */
	}
/* L300: */
    }

/*    Resolution du systeme d' equations. */

    mmrslw_(normax, nordre, ndim, epspiv, &aaux[aaux_offset], &xmat[
	    xmat_offset], iercod);


    if (*iercod != 0) {
	maermsg_("MMMRSLW", iercod, 7L);
    }
    if (ibb >= 3) {
	mgsomsg_("MMMRSLW", 7L);
    }
 return 0 ;
} /* mmmrslwd_ */

