// File:	Message_Printer.cxx
// Created:	Fri Jul 30 10:07:17 1999
// Author:	Roman LYGIN
//		<rln@zamox.nnov.matra-dtv.fr>


#include <Message_Printer.ixx>
#include <Dico_DictionaryOfTransient.hxx>

//=======================================================================
//function : Message_Printer
//purpose  : 
//=======================================================================

Message_Printer::Message_Printer()
{
  myTraceLevel = 0;
  myEchoMode = Standard_False;
  myEchoFile = new Message_OutFile;
}

//=======================================================================
//function : Send
//purpose  : 
//=======================================================================

 void Message_Printer::Send(const Standard_CString string,
				const Standard_Integer level,
				const Message_EndOfMsg theEnd) const
{
  if (level > myTraceLevel) return;
  if (myEchoMode) {
    myEchoFile->Out() << string;
    if (theEnd == Message_Flush) myEchoFile->Out() << flush;
    else                             myEchoFile->Out() << endl;
  }
  OwnSend (string, theEnd);
}

//=======================================================================
//function : Send
//purpose  : 
//=======================================================================

 void Message_Printer::Send(const Standard_Integer inumber,
				const Standard_Integer level,
				const Message_EndOfMsg theEnd) const
{
  TCollection_AsciiString string (inumber);
  Send (string.ToCString(), level, theEnd);
}

//=======================================================================
//function : Send
//purpose  : 
//=======================================================================

 void Message_Printer::Send(const Standard_Real rnumber,
				const Standard_Integer level,
				const Message_EndOfMsg theEnd) const
{
  TCollection_AsciiString string (rnumber);
  Send (string.ToCString(), level, theEnd);
}

//=======================================================================
//function : Send
//purpose  : 
//=======================================================================

 void Message_Printer::Send(const Message_Msg& message,
				const Standard_Integer level,
				const Message_EndOfMsg theEnd) const
{
  Send (message.Value(), level, theEnd);
}

//=======================================================================
//function : Append
//purpose  : 
//=======================================================================

 void Message_Printer::Append(const Standard_CString message) 
{
  myLine += message;
}

//=======================================================================
//function : operator<<
//purpose  : 
//=======================================================================

 Message_Printer& Message_Printer::operator<< (const Standard_CString message)
{
  Append (message);
  return *this;
}

//=======================================================================
//function : Append
//purpose  : 
//=======================================================================

 void Message_Printer::Append(const Standard_Integer message) 
{
  myLine += TCollection_AsciiString ( message );
}

//=======================================================================
//function : operator<<
//purpose  : 
//=======================================================================

 Message_Printer& Message_Printer::operator<< (const Standard_Integer message)
{
  Append (message);
  return *this;
}

//=======================================================================
//function : Append
//purpose  : 
//=======================================================================

 void Message_Printer::Append(const Standard_Real message) 
{
  myLine += TCollection_AsciiString ( message );
}

//=======================================================================
//function : operator<<
//purpose  : 
//=======================================================================

 Message_Printer& Message_Printer::operator<< (const Standard_Real message)
{
  Append (message);
  return *this;
}

//=======================================================================
//function : Append
//purpose  : 
//=======================================================================

 void Message_Printer::Append(const Message_Msg& message) 
{
  myLine += message.Value();
}

//=======================================================================
//function : operator<<
//purpose  : 
//=======================================================================

 Message_Printer& Message_Printer::operator<< (const Message_Msg& message)
{
  Append (message);
  return *this;
}

//=======================================================================
//function : Append
//purpose  : 
//=======================================================================

 void Message_Printer::Append(const Message_EndOfMsg theEnd) 
{
  Standard_CString string = myLine.ToCString();
  myLine.Clear();
  SendEver (string, theEnd);
}

//=======================================================================
//function : operator<<
//purpose  : 
//=======================================================================

 Message_Printer& Message_Printer::operator<< (const Message_EndOfMsg theEnd)
{
  Append (theEnd);
  return *this;
}
