#ifndef _Select3D_Box2d_HeaderFile
#define _Select3D_Box2d_HeaderFile

#include<Bnd_Box2d.hxx>
#include<Standard_ShortReal.hxx>
#include<Select3D_Macro.hxx>

struct Select3D_Box2d
{
 Standard_ShortReal xmin, ymin, xmax, ymax;

 Select3D_Box2d()
 { 
   xmin = ymin = xmax = ymax = 0.;
 }

 Select3D_Box2d(const Bnd_Box2d& theBox)
 { 
   SetField(theBox);
 }

 inline operator Bnd_Box2d() const
 {
   Bnd_Box2d aBox;
   aBox.SetVoid();
   if( xmin ==0. && ymin ==0. && xmax == 0. && ymax == 0.)
     return aBox;

   aBox.Update(xmin, ymin, xmax, ymax);
   return aBox;
 }

 inline Select3D_Box2d operator = ( const Bnd_Box2d& theBox)
 { 
   SetField(theBox); 
   return *this;
 }
 inline void Update(const gp_Pnt2d& thePnt)
 {
  Bnd_Box2d aBox;
  aBox.Set(thePnt);
  aBox.Update(xmin, ymin, xmax, ymax);
  SetField(aBox);
 }

 inline void SetVoid()
 {
   xmin = ymin = xmax = ymax = 0.;
 }
private: 
 inline void SetField(const Bnd_Box2d& theBox)
 {
  Standard_Real x, y, x1, y1;
  theBox.Get(x, y, x1, y1);   

  xmin = DToF(x);
  ymin = DToF(y);
  xmax = DToF(x1);
  ymax = DToF(y1);
 }

};

#endif
