// File:	StepToGeom_MakeCartesianPoint2d.cxx
// Created:	Fri Jul  2 16:21:08 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>


#include <StepToGeom_MakeCartesianPoint2d.ixx>
#include <StepGeom_CartesianPoint.hxx>
#include <Geom2d_CartesianPoint.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un CartesianPoint de Geom2d a partir d' un CartesianPoint de
// Step
//=============================================================================

StepToGeom_MakeCartesianPoint2d::StepToGeom_MakeCartesianPoint2d
  ( const Handle(StepGeom_CartesianPoint)& P)
{
  if (P->NbCoordinates() != 2 ) done = Standard_False;
  else
    {
      Standard_Real X = P->CoordinatesValue(1);
      Standard_Real Y = P->CoordinatesValue(2);
      theCartesianPoint = new Geom2d_CartesianPoint(X, Y);
      done = Standard_True;
    }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_CartesianPoint) &
      StepToGeom_MakeCartesianPoint2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theCartesianPoint;
}
