/* CRRQST.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <SysBase.h>
/* Common Block Declarations */

struct {
    long int icore[12000];	/* was [12][1000] */ 
    integer ncore, lprot;
} mcrgene_;

#define mcrgene_1 mcrgene_

struct {
    integer nrqst[2], ndelt[2], nbyte[2], mbyte[2];
} mcrstac_;

#define mcrstac_1 mcrstac_

/* Table of constant values */

static integer c__9 = 9;
static integer c__1 = 1;
static integer c__3 = 3;

/* Subroutine */ __SysBase_API int mcrrqst_(iunit, isize, t, iofset, iercod)
integer *iunit, *isize;
doublereal *t;
integer *iercod;
long int *iofset;
{
    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    integer s__wsle(), do__lio(), e__wsle();
    /* Subroutine */ int __s__copy();

    /* Local variables */
    static doublereal dfmt;
    static integer ifmt, iver;
    static char subr[7];
    static integer ksys , ibyte, irest, isyst, ier;
    static long int iadfd, iadff, iaddr,lofset, loc;
    extern /* Subroutine */ int madbtbk_(), macrchk_(), macrgfl_();
    static integer izu;
    extern /* Subroutine */ int macrmsg_(), mcrlocv_(), maostrb_(), mcrgetv_()
	    , maostrd_(), mcrlist_(), macrstw_();

    /* Fortran I/O blocks */
    static cilist io___3 = { 0, 6, 0, 0, 0 };
    static cilist io___4 = { 0, 6, 0, 0, 0 };


/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*       REALISATION D'UNE ALLOCATION DYNAMIQUE DE MEMOIRE */

/*     MOTS CLES : */
/*     ----------- */
/*       SYSTEME, ALLOCATION, MEMOIRE, REALISATION */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        IUNIT  : NOMBRE D'OCTEST DE L'UNITE D'ALLOCATION */
/*        ISIZE  : NOMBRE D'UNITES DEMANDEES */
/*        T      : ADRESSE DE REFERENCE */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        IOFSET : DECALAGE */
/*        IERCOD : CODE D'ERREUR, */
/*               = 0 : OK */
/*               = 1 : NBRE MAXI D'ALLOCS ATTEINT */
/*               = 2 : ARGUMENTS INCORRECTS */
/*               = 3 : REFUS D'ALLOCATION DYNAMIQUE */

/*     COMMONS UTILISES   : */
/*     ---------------- */
/*       MCRGENE, MCRSTAC */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */
/*       MACRCHK, MACRGFL, MACRMSG, MCRLOCV,MCRCOMM, MCRGETV */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/*     1) UTILISATEUR */
/*     -------------- */

/* T EST L'ADRESSE D'UN TABLEAU BANAL,IOFSET REPRESENTE LE DEPLACEMENT EN 
*/
/* UNITES DE IUNIT OCTETS ENTRE LA ZONE ALLOUEE ET LE TABLEAU T */
/* IERCOD=0 SIGNALE QUE L'ALLOCATION S'EST BIEN DEROULEE ,TOUTE AUTRE */
/* VALEUR INDIQUE UNE ANOMALIE. */

/*     EXEMPLE : */
/*          SOIT LA DECLARATION REAL*4 T(1), DONC IUNIT=4 . */
/*          L'APPEL A MCRRQST FAIT UNE ALLOCATION DYNAMIQUE */
/*          ET DONNE UNE VALEUR A LA VARIABLE IOFSET, */
/*          SI L'ON VEUT ECRIRE 1. DANS LA CINQUIEME ZONE REAL*4 */
/*          AINSI ALLOUEE ,FAIRE: */
/*          T(5+IOFSET)=1. */

/*     CAS D'ERREURS : */
/*     --------------- */

/*     IERCOD=1 : NOMBRE MAXI D'ALLOCATION ATTEINT (ACTUELLEMENT 200) */
/*     ET LE MESSAGE SUIVANT APPARAIT SUR LA CONSOLE ALPHA : */
/*     "Le nombre maxi d'allocation de memoire est atteint : ,N" */

/*     IERCOD=2 : ARGUMENT IUNIT INCORRECT CAR DIFFERENT DE 1,2,4 OU 8 */
/*     ET LE MESSAGE SUIVANT APPARAIT SUR LA CONSOLE ALPHA : */
/*     "Unite d'allocation invalide : ,IUNIT" */

/*     IERCOD=3 : REFUS D'ALLOCATION DYNAMIQUE (PLUS DE PLACE MEMOIRE) */
/*     ET LE MESSAGE SUIVANT APPARAIT SUR LA CONSOLE ALPHA : */
/*    "Le systeme refuse une allocation dynamique de memoire de N octets" 
*/
/*     AVEC UN AFFICHAGE COMPLET DE TOUTES LES ALLOCATIONS EFFECTUEES */
/*     JUSQU'A PRESENT. */


/*     2) CONCEPTEUR */
/*     -------------- */

/* MCRRQST FAIT UNE ALLOCATION DYNAMIQUE DE MEMOIRE VIRTUELLE SUR LA BASE 
*/
/* D'ENTITES DE 8 OCTETS (QUADWORDS) ,BIEN QUE L'ALLOCATION SOIT DEMANDEE 
*/
/* PAR UNITES DE IUNIT OCTETS (1,2,4,8). */

/* LA QUANTITE DEMANDEE EST IUNIT*ISIZE OCTETS,CETTE VALEUR EST ARRONDIE 
*/
/* POUR QUE L'ALLOCATION SOIT UN NOMBRE ENTIER DE QUADWORDS. */


/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     14-04-94 : JMB; Suppression message ALLOC < 16 octets */
/*     08-10-92 : FCR; DMSFRO131 : Modif pour DEBUG-ALLOC */
/*     23-09-91 : DGZ; REND LA ROUTINE PORTABLE */
/*     22-08-90 : DGZ; CORRECTION DE L'EN-TETE */
/*     21-08-90 : DGZ; AFFICHAGE DU TRACE_BACK EN PHASE DE PRODUCTION */
/*     22-12-89 : DGZ; CORRECTION DE L'EN-TETE */
/*     19-05-89 : DGZ; AJOUT DOUBLE MOT SI DECALAGE ET SUPP APPEL ACRVRF 
*/
/*     17-05-89 : DGZ; CALCUL DE IOFSET DANS LE CAS OU IL EST NEGATIF */
/*     11-05-89 : DGZ; CONTROLE DES ECRASEMENTS DE ZONE MEMOIRE */
/*     04-05-88 : PP ; CHANGE MOVFLW EN MAOVERF */
/*     23-03-88 : PP ; CORR DE PASSAGES D'ARGUMENTS DANS MACRMSG ET MOVFLW
 */
/*     26.2.88 PP VIRE VFORMA, ET MIS MACRMSG */
/*     22.2.88 : PP : CHANGE I*4 EN I ET R*8 EN D P, AJOUT DE ISYST */
/*                   ,ET VIRE LE TEST SUR IBB, A REMETTRE AVANT LIVRAISON 
*/
/*     09-10-1987 : Initialisation a OVERFLOW si IBB <> 0 JJM */
/*     10-04-87 : BF ; ALLOCATIONS CADREES SUR DOUBLES MOTS */
/*     07-11-85 : BF ; VERSION D'ORIGINE */

/* > */
/* ***********************************************************************
 */

/* COMMON DES PARAMETRES */
/* COMMON DES INFORMATIONS SUR LES STATISTIQUES */
/*     INCLUDE MCRGENE */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        TABLE DE GESTION DES ALLOCATIONS DYNAMIQUES DE MEMOIRE */

/*     MOTS CLES : */
/*     ----------- */
/*        SYSTEME, MEMOIRE, ALLOCATION */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*       23-11-93 : FCR; AF93125U3A007 : MAXCR 200 --> 1000 */
/*       08-10-92 : FCR; DMSFRO131 : Modif pour DEBUG-ALLOC */
/*       25-09-91 : DGZ; AJOUT INFOs SUPPLEMENTAIREs POUR GESTION FLAGS */
/*       18-01-91 : DGZ; MAXCR PASSE DE 100 A 200 SUR DEMANDE GDD */
/*       18-05-90 : DGZ; DECLARATION TYPE INTEGER POUR MAXCR */
/*       20-06-88 : PP ; MAXCR PASSE DE 50 A 100, SUR DEMANDE OG */
/*                       + AJOUT DE COMMENTAIRES */
/*       26-02-88 : PP ; MAXCR PASSE DE 40 A 50, SUR DEMANDE AB . */
/*       15-04-85 : BF ; VERSION D'ORIGINE */
/* > */
/* ***********************************************************************
 */

/*   ICORE : TABLE DES ALLOCS EXISTANTES, AVEC POUR CHACUNE : */
/*         1 : NIVEAU DE PROTECTION (0=PAS PROTEGE, AUTRE=PROTEGE) */
/*             (PROTEGE SIGNIFIE PAS DETRUIT PAR CRRSET .) */
/*         2 : UNITE D'ALLOCATION */
/*         3 : NB D'UNITES ALLOUEES */
/*         4 : ADRESSE DE REFERENCE DU TABLEAU */
/*         5 : IOFSET */
/*         6 : NUMERO ALLOCATION STATIQUE */
/*         7 : Taille demandee en allocation */
/*         8 : adresse du debut de l'allocation */
/*         9 : Taille de la ZONE UTILISATEUR */
/*        10 : ADRESSE DU FLAG DE DEBUT */
/*        11 : ADRESSE DU FLAG DE FIN */
/*        12 : Rang de creation de l'allocation */

/*   NDIMCR : NBRE DE DONNEES DE CHAQUE ALLOC DANS ICORE */
/*   NCORE : NBRE D'ALLOCS EN COURS */
/*   LPROT : COMMUNICATION ENTRE CRPROT ET MCRRQST, REMIS A 0 PAR MCRRQST 
*/
/*   FLAG  : VALEUR DU FLAG UTILISE POUR LES DEBORDEMENTS */



/* ----------------------------------------------------------------------*
 */


/*     20-10-86 : BF ; VERSION D'ORIGINE */


/*     NRQST : NOMBRE D'ALLOCATIONS EFFECTUEES */
/*     NDELT : NOMBRE DE LIBERATIONS EFFECTUEES */
/*     NBYTE : NOMBRE TOTAL D'OCTETS DES ALLOCATIONS */
/*     MBYTE : NOMBRE MAXI D'OCTETS */

/* ----------------------------------------------------------------------*
 */

    /* Parameter adjustments */
    --t;

    /* Function Body */
    *iercod = 0;

    if (mcrgene_1.ncore >= 1000) {
	goto L9001;
    }
    if (*iunit != 1 && *iunit != 2 && *iunit != 4 && *iunit != 8) {
	goto L9002;
    }

/* Calcul de la taille demandee par l'utilsateur */
    ibyte = *iunit * *isize;

/* Recheche le type de version (Phase de Production ou Version Client) */
    madbtbk_(&iver);

/* Controle sur la taille allouee en phase de Production */

    if (iver == 1) {

	if (ibyte == 0) {
	    s__wsle(&io___3);
	    do__lio(&c__9, &c__1, "Demande d'allocation nulle", 26L);
	    e__wsle();
	    maostrb_();
	} else if (ibyte >= 4096000) {
	    s__wsle(&io___4);
	    do__lio(&c__9, &c__1, "Demande d'allocation superieure a 4 Mega-O\
ctets : ", 50L);
	    do__lio(&c__3, &c__1, (char *)&ibyte, (ftnlen)sizeof(integer));
	    e__wsle();
	    maostrb_();
	}

    }

/* ON CALCUL LA TAILLE DE LA ZONE UTILSATEUR (IZU) */
/*     . ajout taille demandee par l'utilisateur (IBYTE) */
/*     . ajout d'un delta pour alignement avec la base */
/*     . on arrondit au multiple de 8 superieur */

    mcrlocv_(&t[1], &loc);
    izu = ibyte + loc % *iunit;
    irest = izu % 8;
    if (irest != 0) {
	izu = izu + 8 - irest;
    }

/* ON CALCUL LA TAILLE QUI VA ETRE DEMANDEE A LA PRIMITIVE D'ALLOC */
/*     . ajout de la taille de la zone utilisateur */
/*     . ajout de 8 pour un alignement de l'adresse de debut */
/*       d'allocation sur un multiple de 8 de facon a pouvoir */
/*       poser des flags en Double Precision sans pb d'alignement */
/*     . ajout de 16 octets pour les deux flags */

    ibyte = izu + 24;

/* DEMANDE D'ALLOCATION */

    isyst = 0;
/* L1001: */
/*      IF ( ISYST.EQ.0.AND.IBYTE .LE. 100 * 1024 ) THEN */
/*        ALLOCATION SUR TABLE */
/*         KSYS = 1 */
/*         KOP = 1 */
/*         CALL MCRCOMM ( KOP , IBYTE , IADDR , IER ) */
/*         IF ( IER .NE. 0 ) THEN */
/*            ISYST=1 */
/*            GOTO 1001 */
/*         ENDIF */
/*      ELSE */
/*        ALLOCATION SYSTEME */
    ksys = 2;
    mcrgetv_(&ibyte, &iaddr, &ier);
    if (ier != 0) {
	goto L9003;
    }
/*      ENDIF */

/* CALCUL DES ADRESSES DES FLAGS */

    iadfd = iaddr + 8 - iaddr % 8;
    iadff = iadfd + 8 + izu;

/* CALCUL DE L'OFFSET UTILISATEUR : */
/*     . difference entre l'adresse de depart utilisateur et */
/*       l'adresse de la base */
/*     . convertit cette difference dans l'unite utilisateur */

    lofset = iadfd + 8 + loc % *iunit - loc;
    *iofset = lofset / *iunit;

/* Si phase de production alors controle des flags */
    if (iver == 1) {
	macrchk_();
    }

/*     MISE EN PLACE DES FLAGS */
/*     . le premier flag est mis en IADFD et le second en IADFF */
/*     . Si phase de production alors on met a overflow la ZU */
    macrgfl_(&iadfd, &iadff, &iver, &izu);

/* RANGEMENT DES PARAMETRES DANS MCRGENE */

    ++mcrgene_1.ncore;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 12] = mcrgene_1.lprot;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 11] = *iunit;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 10] = *isize;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 9] = loc;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 8] = *iofset;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 7] = ksys;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 6] = ibyte;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 5] = iaddr;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 4] = mcrgene_1.ncore;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 3] = iadfd;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 2] = iadff;
    mcrgene_1.icore[mcrgene_1.ncore * 12 - 1] = mcrgene_1.ncore;

    mcrgene_1.lprot = 0;

/* APPEL PERMETTANT UNE MISE EN PLACE AUTO DU SET WATCH PAR LE DEBUGGER */

    macrstw_(&iadfd, &iadff, &mcrgene_1.ncore);

/* STATISTIQUES */

    ++mcrstac_1.nrqst[ksys - 1];
    mcrstac_1.nbyte[ksys - 1] += mcrgene_1.icore[mcrgene_1.ncore * 12 - 11] * 
	    mcrgene_1.icore[mcrgene_1.ncore * 12 - 10];
/* Computing MAX */
    i__1 = mcrstac_1.mbyte[ksys - 1], i__2 = mcrstac_1.nbyte[ksys - 1];
    mcrstac_1.mbyte[ksys - 1] = max(i__1,i__2);

    goto L9900;

/* ----------------------------------------------------------------------*
 */
/*   TRAITEMENT DES ERREURS */

/*  NBRE MAXI D'ALLOC ATTEINT : */
L9001:
    *iercod = 1;
    ifmt = 1000;
    __s__copy(subr, "MCRRQST", 7L, 7L);
    macrmsg_(subr, iercod, &ifmt, &dfmt, " ", 7L, 1L);
    maostrd_();
    goto L9900;

/*  AURGUMENTS INCORRECTS */
L9002:
    *iercod = 2;
    ifmt = *iunit;
    __s__copy(subr, "MCRRQST", 7L, 7L);
    macrmsg_(subr, iercod, &ifmt, &dfmt, " ", 7L, 1L);
    goto L9900;

/* LE SYSTEME REFUSE L'ALLOCATION */
L9003:
    *iercod = 3;
    ifmt = ibyte;
    __s__copy(subr, "MCRRQST", 7L, 7L);
    macrmsg_(subr, iercod, &ifmt, &dfmt, " ", 7L, 1L);
    maostrd_();
    mcrlist_(&ier);
    goto L9900;

/* ----------------------------------------------------------------------*
 */

L9900:
    mcrgene_1.lprot = 0;
 return 0 ;
} /* mcrrqst_ */

