// File:	TDataStd_Position.cxx
// Created:	Tue Aug  3 18:25:50 1999
// Author:	Denis PASCAL
//		<dp@dingox.paris1.matra-dtv.fr>


#include <TDataStd_Position.ixx>
#include <TDF_Label.hxx>

//=======================================================================
//function : Set (class method)
//purpose  : 
//=======================================================================
void TDataStd_Position::Set(const TDF_Label& aLabel, const gp_Pnt& aPos) 
{
  Handle(TDataStd_Position) pos;
  if (!aLabel.FindAttribute(TDataStd_Position::GetID(), pos)) {
    pos = new TDataStd_Position();
    aLabel.AddAttribute(pos);
  }
  pos->SetPosition( aPos ); 
}

//=======================================================================
//function : Set
//purpose  : 
//=======================================================================
Handle(TDataStd_Position) TDataStd_Position::Set (const TDF_Label& L)
{
  Handle(TDataStd_Position) POS;
  if (!L.FindAttribute (TDataStd_Position::GetID (), POS)) {    
    POS = new TDataStd_Position;
    L.AddAttribute(POS);
  }
  return POS;
}

//=======================================================================
//function : Get (class method)
//purpose  : 
//=======================================================================
Standard_Boolean TDataStd_Position::Get(const TDF_Label& aLabel, gp_Pnt& aPos) 
{
  Handle(TDataStd_Position) pos;
  if( aLabel.FindAttribute( TDataStd_Position::GetID(), pos) ) {
    aPos = pos->GetPosition();
    return Standard_True; 
  }
  return Standard_False; 
}

//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================
const Standard_GUID& TDataStd_Position::GetID() 
{
  static Standard_GUID TDataStd_Position_guid("55553252-ce0c-11d1-b5d8-00a0c9064368");
  return TDataStd_Position_guid;
}

//=======================================================================
//function : TDataStd_Position
//purpose  : 
//=======================================================================
TDataStd_Position::TDataStd_Position()
  :myPosition(gp_Pnt(0.,0.,0.))
{
}

//=======================================================================
//function : GetPosition
//purpose  : 
//=======================================================================
const gp_Pnt& TDataStd_Position::GetPosition() const
{
  return myPosition;
}

//=======================================================================
//function : Position
//purpose  : 
//=======================================================================
void TDataStd_Position::SetPosition(const gp_Pnt& aPos) 
{
  // OCC2932 correction
  if(myPosition.X() == aPos.X() &&
     myPosition.Y() == aPos.Y() &&
     myPosition.Z() == aPos.Z())
    return;

  Backup();
  myPosition = aPos;
}

 

//=======================================================================
//function : ID
//purpose  : 
//=======================================================================
const Standard_GUID& TDataStd_Position::ID() const
{
  return GetID();
}

//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================
void TDataStd_Position::Restore(const Handle(TDF_Attribute)& anAttribute) 
{
  myPosition = Handle(TDataStd_Position)::DownCast(anAttribute)->GetPosition();
}

//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================
Handle(TDF_Attribute) TDataStd_Position::NewEmpty() const
{
  return new TDataStd_Position; 
}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================
void TDataStd_Position::Paste(const Handle(TDF_Attribute)& intoAttribute,
			     const Handle(TDF_RelocationTable)&) const
{
  Handle(TDataStd_Position)::DownCast(intoAttribute)->SetPosition(myPosition);
}
