package test;

import java.awt.Font;
import java.awt.Graphics;

import javax.swing.*;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.utils.LafConstants.AnimationKind;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class MenuTooltipFrame extends JFrame {
	public MenuTooltipFrame() {
		super("Menus have tooltips");

		JMenuBar jmb = new JMenuBar();
		JMenu fileMenu = new JMenu("File");

		JMenuItem openMenuItem = new JMenuItem("Open");
		openMenuItem.setToolTipText("Open action tooltip");
		openMenuItem.setFont(new Font("Arial", Font.PLAIN, 18));
		fileMenu.add(openMenuItem);

		JMenuItem saveMenuItem = new JMenuItem("Save") {
			@Override
			protected void paintComponent(Graphics g) {
				super.paintComponent(g);
				JRootPane jrp = SwingUtilities.getRootPane(this);
				JLayeredPane jlp = jrp.getLayeredPane();
				System.out.println(jlp
						.getComponentCountInLayer(JLayeredPane.POPUP_LAYER));
			}
		};
		saveMenuItem.setToolTipText("Save action tooltip");
		fileMenu.add(saveMenuItem);

		JMenuItem closeMenuItem = new JMenuItem("Close");
		closeMenuItem.setToolTipText("Close action tooltip");
		fileMenu.add(closeMenuItem);

		jmb.add(fileMenu);

		this.setJMenuBar(jmb);

		this.setSize(400, 400);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setLocationRelativeTo(null);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		UIManager.put(LafWidget.ANIMATION_KIND, AnimationKind.DEBUG);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new MenuTooltipFrame().setVisible(true);
			}
		});
	}

}
