/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.plaf.FontUIResource;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.FontSet;

public class SetVerdana extends JFrame {
	private static class CustomFontSet implements FontSet {
		protected FontUIResource font;

		public CustomFontSet(Font font) {
			this.font = new FontUIResource(font);
		}

		public FontUIResource getControlFont() {
			return this.font;
		}

		public FontUIResource getMenuFont() {
			return this.font;
		}

		public FontUIResource getMessageFont() {
			return this.font;
		}

		public FontUIResource getSmallFont() {
			return this.font;
		}

		public FontUIResource getTitleFont() {
			return this.font;
		}

		public FontUIResource getWindowTitleFont() {
			return this.font;
		}
	}

	public SetVerdana() {
		super("Set font policy");

		this.setLayout(new BorderLayout());

		JPanel panel = new JPanel(new FlowLayout());

		// create a slider to control the font size.
		JButton verdana = new JButton("Verdana");
		verdana.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						// Create the wrapper font set
						FontPolicy newFontPolicy = new FontPolicy() {
							public FontSet getFontSet(String lafName,
									UIDefaults table) {
								return new CustomFontSet(new Font("Verdana",
										Font.BOLD, 12));
							}
						};

						try {
							// set the new font policy
							SubstanceLookAndFeel.setFontPolicy(newFontPolicy);
							// reset the LAF to have the changes
							UIManager
									.setLookAndFeel(new SubstanceLookAndFeel());
							SwingUtilities
									.updateComponentTreeUI(SetVerdana.this);
						} catch (Exception exc) {
							exc.printStackTrace();
						}
					}
				});
			}
		});
		panel.add(verdana);

		panel.add(new JButton("button"));
		panel.add(new JComboBox(new Object[] { "item1", "item2" }));

		this.add(panel, BorderLayout.CENTER);

		this.setSize(400, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		JFrame.setDefaultLookAndFeelDecorated(true);
		JDialog.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new SetVerdana().setVisible(true);
			}
		});
	}
}
