package test;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel;

public class TestColorChooser extends JFrame {
	Window window;

	public TestColorChooser() {
		super("Color chooser");
		this.setLayout(new FlowLayout());
		JButton open = new JButton("open color chooser");
		open.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						window = new Window(TestColorChooser.this);
						window.setLayout(new BorderLayout());
						window.add(new JColorChooser());
						window.pack();
						window.setLocationRelativeTo(null);
						window.setVisible(true);
					}
				});
			}
		});
		this.add(open);

		this.setSize(200, 100);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceBusinessBlueSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TestColorChooser().setVisible(true);
			}
		});
	}
}
