package test.contrib.combotheme;

import java.awt.Color;

import javax.swing.JComponent;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;

public class ColorTheme extends SubstanceTheme {

	public void resetColorToDefault(JComponent button) {
		button.putClientProperty(SubstanceLookAndFeel.THEME_PROPERTY,
				SubstanceLookAndFeel.getTheme());
		button.repaint();
	}

	protected Color[] colors;

	public ColorTheme(String name, final Color[] colors) {
		super(new ColorScheme() {

			public Color getDarkColor() {
				return colors[5];
			}

			public Color getExtraLightColor() {
				return colors[2];
			}

			public Color getForegroundColor() {
				return colors[0];
			}

			public Color getLightColor() {
				return colors[3];
			}

			public Color getMidColor() {
				return colors[4];
			}

			public Color getUltraDarkColor() {
				return colors[6];
			}

			public Color getUltraLightColor() {
				return colors[1];
			}
		}, name, ThemeKind.DARK);
		this.colors = colors;
	}

	public void setTheme(JComponent boxButton, SubstanceTheme theme) {
		boxButton.putClientProperty(SubstanceLookAndFeel.THEME_PROPERTY, theme);
		boxButton.repaint();
	}
}