package test.contrib.tablerowmargin;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import org.jvnet.substance.SubstanceDefaultTableCellRenderer;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class Test extends JFrame {
	private static final long serialVersionUID = -982798754720311902L;

	public Test() {
		this.setLayout(new BorderLayout());

		JTable table = new TestJTable(new DefaultTableModel() {
			private static final long serialVersionUID = 5175106617325079345L;

			@Override
			public int getRowCount() {
				return 10;
			}

			@Override
			public int getColumnCount() {
				return 2;
			}

			@Override
			public Object getValueAt(int row, int column) {
				return row + ":" + column;
			}
		});

		table.setRowMargin(40);
		table.setShowGrid(false);

		table.setDefaultRenderer(Object.class,
				new SubstanceDefaultTableCellRenderer() {
					private static final long serialVersionUID = -2514832365261475281L;

					@Override
					public Component getTableCellRendererComponent(JTable arg0,
							Object arg1, boolean arg2, boolean arg3, int arg4,
							int arg5) {
						Component c = super.getTableCellRendererComponent(arg0,
								arg1, arg2, arg3, arg4, arg5);
						((JLabel) c).setIcon(new ImageIcon(getClass()
								.getResource("Test.png")));
						return c;
					}
				});

		this.add(new JScrollPane(table), BorderLayout.CENTER);

		this.setSize(600, 400);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new Test().setVisible(true);
			}
		});
	}
}