#include <stdio.h>

#include <X11/Xlib.h>
#include "generic.h"

#include "context.h"

tcontext tcontext_new(where, args)
titem where;
targs args;
{
	Display *xdpy;
	Colormap cmap;
	tdisplay dpy;
	ltcontext tmp;

	if(where==NULL)
		return(NULL);
	dpy=(tdisplay)titem_display(where);
	xdpy=(Display *)tdisplay_X(dpy);

	tmp=(ltcontext)titem_new(dpy, lt_context, sizeof(ltcontextd));
	if(tmp==NULL)
		return(NULL);

	tmp->dpy=dpy;
	tmp->f=tc_copy;
	tmp->linewidth=0;
	tmp->capstyle=tcap_butt;
	tmp->solid=1;
	tmp->offset=0;
	tmp->l1=4;
	tmp->l2=4;
	tmp->font=NULL;
	tmp->x=tmp->y=tmp->w=tmp->h=0;
	tmp->clippingon=0;
	tmp->stipple=NULL;
	tmp->fillstyle=tfill_solid;
	tmp->fg=(tcolor)tdisplay_Black(dpy);
	tmp->bg=(tcolor)tdisplay_White(dpy);

	return(tmp);
}

int tcontext_free(c)
ltcontext c;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	titem_free(c);
	return(1);
}

int tcontext_xcap_style(s)
tcap_style s;
{
	switch(s)
	{
		case tcap_notlast:
			return(CapNotLast);
		case tcap_butt:
			return(CapButt);
		case tcap_round:
			return(CapRound);
		case tcap_projecting:
			return(CapProjecting);
		default:
			return(-1);
	}
}

int tcontext_set_foreground(c, fg)
ltcontext c;
tcolor fg;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	if(fg==NULL)
		return(0);
	if(titem_type(fg)!=lt_color)
		return(0);
	
	c->fg=fg;
	return(1);
}

int tcontext_set_background(c, bg)
ltcontext c;
tcolor bg;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	if(bg==NULL)
		return(0);
	if(titem_type(bg)!=lt_color)
		return(0);
	
	c->bg=bg;
	return(1);
}

int tcontext_set_function(c, f)
ltcontext c;
tc_function f;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	c->f=f;
	return(1);
}

int tcontext_set_linewidth(c, l)
ltcontext c;
int l;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	if(l<0)
		return(0);
	
	c->linewidth=l;
	return(1);
}

int tcontext_set_fillstyle(c, s)
ltcontext c;
tfill_style s;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	if(s==tfill_none)
		return(0);
	
	c->fillstyle=s;
	return(1);
}

int tcontext_set_stipple(c, s)
ltcontext c;
tpic s;
{
	/* check type */
	if(c==NULL || s==NULL)
		return(0);
	if(titem_type(c)!=lt_context || titem_type(s)!=lt_pic)
		return(0);
	
	c->stipple=s;
	return(1);
}

int tcontext_set_capstyle(c, s)
ltcontext c;
tcap_style s;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	if(s==tcap_none)
		return(0);
	
	c->capstyle=s;
	return(1);
}

int tcontext_set_solid(c)
ltcontext c;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	c->solid=1;
	return(1);
}

int tcontext_set_dashes(c, o, l1, l2)
ltcontext c;
int o, l1, l2;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	if(l1<0 || l2<0)
		return(0);

	c->offset=o;
	c->l1=l1;
	c->l2=l2;
	c->solid=0;
	return(1);
}

int tcontext_set_font(c, f)
ltcontext c;
tfont f;
{
	/* check type */
	if(c==NULL || f==NULL)
		return(0);
	if(titem_type(c)!=lt_context || titem_type(f)!=lt_font)
		return(0);
	
	c->font=f;
	return(1);
}

int tcontext_set_cliparea(c, x,y,w,h)
ltcontext c;
int x,y,w,h;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	c->x=x;
	c->y=y;
	c->w=w;
	c->h=h;
	c->clippingon=1;
	return(1);
}

int tcontext_set_noclipping(c)
ltcontext c;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	c->clippingon=0;
	return(1);
}

int tcontext_get_foreground(c, fg)
ltcontext c;
tcolor *fg;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*fg=c->fg;
	return(1);
}

int tcontext_get_background(c, bg)
ltcontext c;
tcolor *bg;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*bg=c->bg;
	return(1);
}

int tcontext_get_function(c, f)
ltcontext c;
tc_function *f;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*f=c->f;
	return(1);
}

int tcontext_get_linewidth(c, l)
ltcontext c;
int *l;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*l=c->linewidth;
	return(1);
}

int tcontext_get_fillstyle(c, s)
ltcontext c;
int *s;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*s=c->fillstyle;
	return(1);
}

int tcontext_get_stipple(c, s)
ltcontext c;
tpic *s;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*s=c->stipple;
	return(1);
}

int tcontext_get_capstyle(c, s)
ltcontext c;
int *s;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*s=c->capstyle;
	return(1);
}

int tcontext_get_solid(c)
ltcontext c;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	return(c->solid);
}

int tcontext_get_dashes(c, o, l1, l2)
ltcontext c;
int *o, *l1, *l2;
{
	char dash_list[2];

	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);

	*o=c->offset;
	*l1=c->l1;
	*l2=c->l2;
	return(!(c->solid));
}

int tcontext_get_font(c, f)
ltcontext c;
tfont *f;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*f=c->font;
	return(1);
}

int tcontext_get_cliparea(c, x,y,w,h)
ltcontext c;
int *x,*y,*w,*h;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);
	
	*x=c->x;
	*y=c->y;
	*w=c->w;
	*h=c->h;
	return(c->clippingon);
}

tcontext tcontext_copy(c)
ltcontext c;
{
	ltcontext tmp;

	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_context)
		return(0);

	tmp=(ltcontext)titem_new(titem_parent(c), lt_context, sizeof(ltcontextd));
	tmp->dpy=c->dpy;
	tmp->fg=c->fg;
	tmp->bg=c->bg;
	tmp->f=c->f;
	tmp->linewidth=c->linewidth;
	tmp->capstyle=c->capstyle;
	tmp->solid=c->solid;
	tmp->offset=c->offset;
	tmp->l1=c->l1;
	tmp->l2=c->l2;
	tmp->font=c->font;
	tmp->x=c->x;
	tmp->y=c->y;
	tmp->w=c->w;
	tmp->h=c->h;
	tmp->clippingon=c->clippingon;
	tmp->stipple=c->stipple;
	tmp->fillstyle=c->fillstyle;
	return((tcontext)tmp);
}
