#include <stdio.h>

#include <xview/xview.h>
#include <xview/svrimage.h>

#include "generic.h"

typedef struct {
	ltgenericd g;
	Server_image p;
	int width, height;
	} ltpicd, *ltpic;

tpic tpic_new(bits, w, h)
char bits[];
int w, h;
{
    ltpic tmp;

    if(bits==NULL || w==0 || h==0)
		return(NULL);
    
    tmp=(ltpic)titem_new(NULL, lt_pic, sizeof(ltpicd));
    if(tmp==NULL)
		return(NULL);

    tmp->p=(Server_image)xv_create(NULL, SERVER_IMAGE,
		XV_WIDTH, w,
		XV_HEIGHT, h, 
		SERVER_IMAGE_X_BITS, bits,
		SERVER_IMAGE_DEPTH, 1,
		NULL);
    
    if(tmp->p==NULL)
    {
		titem_free(tmp);
		return(NULL);
    }
	tmp->width=w;
	tmp->height=h;
    return(tmp);
}

Server_image tpic_xview(p)
ltpic p;
{
    if(p==NULL)
		return(NULL);
    if(titem_type(p)!=lt_pic)
		return(NULL);
    
    return(p->p);
}

int tpic_free(p)
ltpic p;
{
    if(p==NULL)
		return(0);
    if(titem_type(p)!=lt_pic)
		return(0);
    
    xv_destroy_safe(p->p);
    titem_free(p);
    return(1);
}

Icon tpic_icon(p, s)
ltpic p;
char *s;
{
	Icon i;
	Xv_opaque xi;
	int makelabel;
	Rect ir, lr;

    if(p==NULL)
		return(NULL);
    if(titem_type(p)!=lt_pic)
		return(NULL);
	
	if(s==NULL)
		makelabel=0;
	else if(*s=='\0')
		makelabel=0;
	else
		makelabel=1;
    
	if(p->g.parent!=NULL)
		xi=(Xv_opaque)titem_xview_window(p->g.parent);
	else
		xi=NULL;
	if(makelabel)
	{
		rect_construct(&ir, 0, 0, p->width, p->height);
		rect_construct(&lr, 0, p->height, 0, 20);
		i=(Icon)xv_create(xi, ICON,
			ICON_IMAGE, p->p,
			XV_WIDTH, p->width,
			XV_HEIGHT, p->height+20,
			XV_LABEL, s,
			ICON_LABEL_RECT, &lr,
			ICON_IMAGE_RECT, &ir,
			NULL);
	}
	else
	{
		i=(Icon)xv_create(xi, ICON,
			ICON_IMAGE, p->p,
			XV_WIDTH, p->width,
			XV_HEIGHT, p->height,
			NULL);
	}
    return(i);
}
