#include <stdio.h>

#ifdef MEMDBG
#include "memdbg.h"
#endif

#include "treestruct.h"

#define INIT register char *sp = instring;
#define GETC() (*sp++)
#define PEEKC() (*sp)
#define UNGETC(c) (--sp)
#define RETURN(c) return(c)
#define ERROR(c) {regerr(c);return(ep);}
#include <regexp.h>

int reg_error;
char expbuf[1000];

regerr(c)
int c;
{
	reg_error=c;
}

int findnodebyname(t, str, n)
tree t;
char *str;		/* regular expression to search for */
treenode *n;	/* node found, passes in last node that was found */
/* returns: 0=ok, 1=not found, 2=bad search pattern, 3=bad parameters */
{
	list old;
	treenode c, start, found;

	if(str==NULL)
		return(3);
	if(nottree(t))
		return(3);
	
	compile(str, expbuf, &expbuf[1000+1], '\0');
	circf=1;

	if(reg_error!=0)
		return(2);
	
	old=listnode(t->nodes);

	if(*n==NULL || findnode(t->nodes, *n)==NULL)
	{
		startlist(t->nodes);
		start=listnext(t->nodes);
	}
	else
		start=*n;
			
	found=NULL;
	while((c=listnext(t->nodes))!=start)
	{
		if(c==NULL)
			startlist(t->nodes);
		else
			if(c->name!=NULL)
				if(step(c->name, expbuf))
				{
					found=c;
					break;
				}
	}
	*n=found;
	if(found==NULL)
		return(1);
	else
		return(0);
}
