#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

/* adjust.c:
 *
 * code for keeping the on-screen tree updated with the current data values.
 * when something (such as a branch) is changed, one of these routines is
 * called, and anything that needs to be changed so that the tree will draw
 * correctly is changed within this module */

#include "interface.h"

#include "treedata.h"

void adjust_branch_parameters(bd)
branchtypedata bd;
{
	tcontext_set_linewidth(bd->gc, bd->thickness);
	tcontext_set_foreground(bd->gc, bd->c);
}

void adjust_node_parameters(nd, td)
nodetypedata nd;
treetypedata td;
{
	static int x, y;

	tcontext_set_font(nd->gc, nd->font);
	tcontext_set_foreground(nd->gc, nd->c);
	ttext_change_font(nd->label, nd->font);
	ttext_set_color(nd->label, nd->c);
	x=nodex(nd, td);
	y=nodey(nd, td);
	x+=nd->lx;
	y+=nd->ly;
	ttext_move(nd->label, x, y);
}

void adjust_tree_parameters(td)
treetypedata td;
{
	static char pvalue[50];

	ttext_set_selection(td->percent, -1, -1);
	sprintf(pvalue, "%.2lf", td->pv);
	ttext_insert_string(td->percent, pvalue);
	tcontext_set_font(td->gc, td->pfont);
	tcontext_set_foreground(td->gc, td->c);
	ttext_change_font(td->percent, td->pfont);
	ttext_set_color(td->percent, td->c);
	center_scale_bar_text(td);
	center_scale_bar(td);
}

void adjust_node_angles(n, td)
treenode n;
treetypedata td;
{
	static nodetypedata nd, pd;
	static treenode p;
	static double dx, dy;

	p=parent(n);
	if(p!=NULL)
	{
		nd=ndta(n)->flower;
		pd=ndta(p)->flower;
		dx=nd->x-pd->x;
		dy=nd->y-pd->y;
		if(dx!=0.0 || dy!=0.0)
		{
			nd->a=atan2(dy, dx);
			norm_angle(nd->a);
		}
	}
}

void adjust_boxed_tree_parameters(t)
tree t;
{
	list c;
	treetypedata td;

	td=tdta(t)->boxed;

	lfor(t->nodes, c)
		adjust_node_parameters(ndta((treenode)nodeobj(c))->boxed, td);
	lfor(t->branches, c)
		adjust_branch_parameters(bdta((treebranch)nodeobj(c))->boxed);
	adjust_tree_parameters(tdta(t)->boxed);
}

void adjust_flower_tree_parameters(t)
tree t;
{
	list c;
	treetypedata td;

	td=tdta(t)->flower;

	lfor(t->nodes, c)
		adjust_node_parameters(ndta((treenode)nodeobj(c))->flower, td);
	lfor(t->branches, c)
		adjust_branch_parameters(bdta((treebranch)nodeobj(c))->flower);
	lfor(t->nodes, c)
		adjust_node_angles(nodeobj(c), td);
	adjust_tree_parameters(tdta(t)->flower);
}

void adjust_tree_type_parameters(t)
tree t;
{
	list c;

    switch(tdta(t)->type)
    {
        case Flower:
            /* setup td pointers to flower for tree, nodes and branches */
            tdta(t)->td=tdta(t)->flower;
            lfor(t->nodes, c)
                ndta(nodeobj(c))->td=ndta(nodeobj(c))->flower;
            lfor(t->branches, c)
                bdta(nodeobj(c))->td=bdta(nodeobj(c))->flower;
			globals->type=Flower;
            break;
        case Boxed:
        default:
            /* setup td pointers to boxed for tree, nodes and branches */
            tdta(t)->td=tdta(t)->boxed;
            lfor(t->nodes, c)
                ndta(nodeobj(c))->td=ndta(nodeobj(c))->boxed;
            lfor(t->branches, c)
                bdta(nodeobj(c))->td=bdta(nodeobj(c))->boxed;
			globals->type=Flower;
            break;
    }
}
