#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

#define Start "&&treetool:"
#define StartLen 11
#define End ""
#define NodeC "Node"
#define NodeCLen 4
#define TreeC "Tree"
#define TreeCLen 4
#define BranchC "Branch"
#define BranchCLen 6
#define FontC "Font"
#define FontCLen 4
#define ColorC "Color"
#define ColorCLen 5
#define BoxedType "Boxed"
#define BoxedTypeLen 5
#define FlowerType "Flower"
#define FlowerTypeLen 6

#define LineLen 78
#define CommentLen 3000

static char *comment;
static char buf[LineLen];
static int numout;
static FILE *f;
static tree outputtree;
static int indent;

#define treetoolcomment(s) (strncmp(s, Start, StartLen)==0)
#define nodecomment(s) (strncmp(&s[StartLen], NodeC, NodeCLen)==0)
#define treecomment(s) (strncmp(&s[StartLen], TreeC, TreeCLen)==0)
#define branchcomment(s) (strncmp(&s[StartLen], BranchC, BranchCLen)==0)
#define colorcomment(s) (strncmp(&s[StartLen], ColorC, ColorCLen)==0)
#define fontcomment(s) (strncmp(&s[StartLen], FontC, FontCLen)==0)
#define istoken(s, t) (strncmp(s, t, strlen(t))==0)

/* tokens */

/* output */

void next_line()
{
	static int i;

	fprintf(f, "\n");
	for(i=0;i<indent;i++)fprintf(f, "%c", ' ');
	numout=indent;
}

void output_buf()
{
	static int len;

	/*len=strlen(buf);*/
	/*if(numout+len>LineLen)*/
		/*next_line();*/
	/*fprintf(f, "%s", buf);*/
	/*numout+=len;*/
	strcat(comment, buf);
}

void start_comment()
{
	/*next_line();*/
	/*fprintf(f, "%s", Start);*/
	/*numout+=StartLen;*/
	comment=(char *)malloc(CommentLen);
	strcpy(comment, Start);
}

void end_comment()
{
	/*sprintf(buf, "%s", End);*/
	strcat(comment, End);
}

void write_int(s, i)
char *s;
int i;
{
	sprintf(buf, "%s=%d:", s, i);
	output_buf();
}

int read_int(s)
char *s;
{
	static int result;

	result=0;

	while(*s!='=')
		s++;
	s++;

	if(*s!='\0')
		sscanf(s, "%d", &result);
	return(result);
}

void write_double(s, i)
char *s;
double i;
{
	sprintf(buf, "%s=%.3lf:", s, i);
	output_buf();
}

double read_double(s)
char *s;
{
	static double result;

	result=0.0;

	while(*s!='=')
		s++;
	s++;

	if(*s!='\0')
		sscanf(s, "%lf", &result);
	return(result);
}

void write_string(s, i)
char *s;
char *i;
{
	sprintf(buf, "%s=%s:", s, i);
	output_buf();
}

void read_string(s, buf)
char *s;
char *buf;
{
	while(*s!='=')
		s++;
	s++;

	while(*s!=':' && *s!='\0')
		*buf++=*s++;
	*buf='\0';
}

void write_single_string(s)
char *s;
{
	sprintf(buf, "%s:", s);
	output_buf();
}

void write_longdouble(s, i)
char *s;
double i;
{
	sprintf(buf, "%s=%.8lf:", s, i);
	output_buf();
}

double read_longdouble(s)
char *s;
{
	static double result;

	result=0.0;

	while(*s!='=')
		s++;
	s++;

	if(*s!='\0')
		sscanf(s, "%lf", &result);
	return(result);
}

static list cl;

void write_color(s, c)
char *s;
tcolor c;
{
	static int i;
	static list t;

	i=0;
	lfor(cl, t)
	{
		if(nodeobj(t)==c)
			break;
		i++;
	}
	if(t==NULL)
	{
		endlist(cl);
		addnode(cl, c);
	}
	write_int(s, i);
}

tcolor read_color(s)
char *s;
{
	static tcolor result;
	static int num;
	list c;

	result=globals->fg;

	while(*s!='=')
		s++;
	s++;

	if(*s!='\0')
	{
		num=0;
		sscanf(s, "%d", &num);
		lfor(cl, c)
		{
			if(num==0)
				break;
			num--;
		}
		if(c!=NULL)
			result=nodeobj(c);
	}
	return(result);
}

static list fl;

void write_font(s, f)
char *s;
tfont f;
{
	static int i;
	static list t;

	i=0;
	lfor(fl, t)
	{
		if(nodeobj(t)==f)
			break;
		i++;
	}
	if(t==NULL)
	{
		endlist(fl);
		addnode(fl, f);
	}
	write_int(s, i);
}

tfont read_font(s)
char *s;
{
	static tfont result;
	static int num;
	list c;

	result=globals->cfont;

	while(*s!='=')
		s++;
	s++;

	if(*s!='\0')
	{
		num=0;
		sscanf(s, "%d", &num);
		lfor(fl, c)
		{
			if(num==0)
				break;
			num--;
		}
		if(c!=NULL)
			result=nodeobj(c);
	}
	return(result);
}

void write_color_info(c)
tcolor c;
{
	static int r, g, b;

	tcolor_values(c, &r,&g,&b);
	sprintf(buf, "%d,%d,%d:", r,g,b);
	output_buf();
}

tcolor read_color_info(s)
char *s;
{
	static tcolor result;
	static int r,g,b,num;

	result=globals->fg;
	num=sscanf(s, "%d,%d,%d", &r, &g, &b);
	if(num==3)
		result=tcolor_new(globals->c, NULL, r, g, b);
	if(result==NULL)
		result=globals->fg;
	return(result);
}

void write_font_info(f)
tfont f;
{
	static char *n, *s;
	static int z;

	n=(char *)tfont_name(f);
	s=(char *)tfont_style(f);
	z=tfont_size(f);
	sprintf(buf, "%s,%s,%d:", n,s,z);
	output_buf();
}

tfont read_font_info(s)
char *s;
{
	static tfont result;
	char name[100], style[100];
	static int size,num;

	result=globals->cfont;
	num=sscanf(s, "%[^,],%[^,],%d", name, style, &size);
	if(num==3)
		result=tfont_get_font_by_names(globals->c, name, style, size);
	if(result==NULL)
		result=globals->cfont;
	return(result);
}

void init_tree_comments(outt)
tree outt;
{
	outputtree=outt;
	cl=newlist();
	fl=newlist();
}

void end_tree_comments()
{
	freelist(cl);
	freelist(fl);
}

void add_comment_to_node(n, where)
treenode n;
where_in_tree where;
{
	list cmlist;
	char *newcm;

	switch(where)
	{
		case BEFORE_NODE:
			cmlist=n->bn;
			if(cmlist==NULL)
				cmlist=n->bn=newlist();
			break;
		case AFTER_LIST:
			cmlist=n->al;
			if(cmlist==NULL)
				cmlist=n->al=newlist();
			break;
		case AFTER_NAME:
			cmlist=n->an;
			if(cmlist==NULL)
				cmlist=n->an=newlist();
			break;
		case BEFORE_DISTANCE:
			cmlist=n->bd;
			if(cmlist==NULL)
				cmlist=n->bd=newlist();
			break;
		case AFTER_DISTANCE:
			cmlist=n->ad;
			if(cmlist==NULL)
				cmlist=n->ad=newlist();
			break;
		default:
			return;
	}

	newcm=(char *)strdup(comment);
	endlist(cmlist);
	addnode(cmlist, newcm);

	free(comment);
}

void add_tree_comment(t, doboxed, doflower)
tree t;
int doboxed, doflower;
{
	treetypedata td;
	list c;
	int r,g,b;
	char *n,*s;
	int z;

	if(doboxed||doflower)
	{
		start_comment();
		write_single_string(TreeC);
		if(tdta(t)->type==Boxed)
			write_string("tty", BoxedType);
		else
			write_string("tty", FlowerType);
		if(doflower)
		{
			td=tdta(t)->flower;
			write_int("tfx", td->x);
			write_int("tfy", td->y);
			write_int("tfw", td->w);
			write_int("tfh", td->h);
			write_double("tftx", td->tx);
			write_double("tfty", td->ty);
			write_longdouble("tfsx", td->tscalex);
			write_longdouble("tfsy", td->tscaley);
			write_double("tfsc", td->scale);
			write_int("tfsi", td->showinternals);
			write_int("tfst", td->showterminals);
			write_int("tfsp", td->showpct);
			write_double("tfpx", td->px);
			write_double("tfpy", td->py);
			write_double("tfpv", td->pv);
			write_color("tfpc", td->c);
			write_font("tfpf", td->pfont);
		}
		if(doboxed)
		{
			td=tdta(t)->boxed;
			write_int("tbx", td->x);
			write_int("tby", td->y);
			write_int("tbw", td->w);
			write_int("tbh", td->h);
			write_double("tbtx", td->tx);
			write_double("tbty", td->ty);
			write_longdouble("tbsx", td->tscalex);
			write_longdouble("tbsy", td->tscaley);
			write_double("tbsc", td->scale);
			write_int("tbsi", td->showinternals);
			write_int("tbst", td->showterminals);
			write_int("tbsp", td->showpct);
			write_double("tbpx", td->px);
			write_double("tbpy", td->py);
			write_double("tbpv", td->pv);
			write_color("tbpc", td->c);
			write_font("tbpf", td->pfont);
		}
		end_comment();
		add_comment_to_node(treeroot(t), AFTER_NAME);
	}
	startlist(cl);
	if(listnext(cl)!=NULL)
	{
		start_comment();
		write_single_string(ColorC);
		lfor(cl, c)
			write_color_info(nodeobj(c));
		end_comment();
		add_comment_to_node(treeroot(t), AFTER_NAME);
	}
	startlist(fl);
	if(listnext(fl)!=NULL)
	{
		start_comment();
		write_single_string(FontC);
		lfor(fl, c)
			write_font_info(nodeobj(c));
		end_comment();
		add_comment_to_node(treeroot(t), AFTER_NAME);
	}
}

void add_branch_comment(b, doboxed, doflower)
treebranch b;
int doboxed, doflower;
{
	branchtypedata bd;

	if(doboxed||doflower)
	{
		start_comment();
		write_single_string(BranchC);
		if(doflower)
		{
			bd=bdta(b)->flower;
			write_int("bft", bd->thickness);
			write_color("bfc", bd->c);
		}
		if(doboxed)
		{
			bd=bdta(b)->boxed;
			write_int("bbt", bd->thickness);
			write_color("bbc", bd->c);
		}
		end_comment();
		add_comment_to_node(b->down, AFTER_NAME);
	}
}

void add_node_comment(n, doboxed, doflower)
treenode n;
int doboxed, doflower;
{
	nodetypedata nd;

	if(doboxed||doflower)
	{
		start_comment();
		write_single_string(NodeC);
		if(doflower)
		{
			nd=ndta(n)->flower;
			write_double("nfx", nd->x);
			write_double("nfy", nd->y);
			write_int("nflx", nd->lx);
			write_int("nfly", nd->ly);
			write_color("nfc", nd->c);
			write_font("nff", nd->font);
			write_int("nftr", nd->textisreset);
		}
		if(doboxed)
		{
			nd=ndta(n)->boxed;
			write_double("nbx", nd->x);
			write_double("nby", nd->y);
			write_int("nblx", nd->lx);
			write_int("nbly", nd->ly);
			write_color("nbc", nd->c);
			write_font("nbf", nd->font);
			write_int("nbtr", nd->textisreset);
		}
		end_comment();
		add_comment_to_node(n, AFTER_NAME);
	}
}

void add_format_comments_to_tree(t)
tree t;
{
	list c;
	int doflower, doboxed;

	init_tree_comments(t);
	doflower=tdta(t)->flower->initialized;
	doboxed=tdta(t)->boxed->initialized;
	doflower=1;
	doboxed=1;
	lfor(t->nodes, c)
		add_node_comment(nodeobj(c), doboxed, doflower);
	lfor(t->branches, c)
		add_branch_comment(nodeobj(c), doboxed, doflower);
	add_tree_comment(t, doboxed, doflower);
	end_tree_comments();
}

/* input */

char *find_node_comment(n)
treenode n;
{
	char *s;

	s=NULL;
	if(n->bn!=NULL)
	{
		startlist(n->bn);
		while((s=listnext(n->bn))!=NULL)
			if(treetoolcomment(s) && nodecomment(s))
				break;
	}
	if(n->al!=NULL && s==NULL)
	{
		startlist(n->al);
		while((s=listnext(n->al))!=NULL)
			if(treetoolcomment(s) && nodecomment(s))
				break;
	}
	if(n->an!=NULL && s==NULL)
	{
		startlist(n->an);
		while((s=listnext(n->an))!=NULL)
			if(treetoolcomment(s) && nodecomment(s))
				break;
	}
	if(n->bd!=NULL && s==NULL)
	{
		startlist(n->bd);
		while((s=listnext(n->bd))!=NULL)
			if(treetoolcomment(s) && nodecomment(s))
				break;
	}
	if(n->ad!=NULL && s==NULL)
	{
		startlist(n->ad);
		while((s=listnext(n->ad))!=NULL)
			if(treetoolcomment(s) && nodecomment(s))
				break;
	}
	return(s);
}

char *find_branch_comment(b)
treebranch b;
{
	char *s;

	s=NULL;
	if(b->down->bn!=NULL)
	{
		startlist(b->down->bn);
		while((s=listnext(b->down->bn))!=NULL)
			if(treetoolcomment(s) && branchcomment(s))
				break;
	}
	if(b->down->al!=NULL && s==NULL)
	{
		startlist(b->down->al);
		while((s=listnext(b->down->al))!=NULL)
			if(treetoolcomment(s) && branchcomment(s))
				break;
	}
	if(b->down->an!=NULL && s==NULL)
	{
		startlist(b->down->an);
		while((s=listnext(b->down->an))!=NULL)
			if(treetoolcomment(s) && branchcomment(s))
				break;
	}
	if(b->down->bd!=NULL && s==NULL)
	{
		startlist(b->down->bd);
		while((s=listnext(b->down->bd))!=NULL)
			if(treetoolcomment(s) && branchcomment(s))
				break;
	}
	if(b->down->ad!=NULL && s==NULL)
	{
		startlist(b->down->ad);
		while((s=listnext(b->down->ad))!=NULL)
			if(treetoolcomment(s) && branchcomment(s))
				break;
	}
	return(s);
}

char *find_tree_comment(t)
tree t;
{
	char *s;

	s=NULL;
	if(treeroot(t)->bn!=NULL)
	{
		startlist(treeroot(t)->bn);
		while((s=listnext(treeroot(t)->bn))!=NULL)
			if(treetoolcomment(s) && treecomment(s))
				break;
	}
	if(treeroot(t)->al!=NULL && s==NULL)
	{
		startlist(treeroot(t)->al);
		while((s=listnext(treeroot(t)->al))!=NULL)
			if(treetoolcomment(s) && treecomment(s))
				break;
	}
	if(treeroot(t)->an!=NULL && s==NULL)
	{
		startlist(treeroot(t)->an);
		while((s=listnext(treeroot(t)->an))!=NULL)
			if(treetoolcomment(s) && treecomment(s))
				break;
	}
	if(treeroot(t)->bd!=NULL && s==NULL)
	{
		startlist(treeroot(t)->bd);
		while((s=listnext(treeroot(t)->bd))!=NULL)
			if(treetoolcomment(s) && treecomment(s))
				break;
	}
	if(treeroot(t)->ad!=NULL && s==NULL)
	{
		startlist(treeroot(t)->ad);
		while((s=listnext(treeroot(t)->ad))!=NULL)
			if(treetoolcomment(s) && treecomment(s))
				break;
	}
	return(s);
}

char *find_color_comment(t)
tree t;
{
	char *s;

	s=NULL;
	if(treeroot(t)->bn!=NULL)
	{
		startlist(treeroot(t)->bn);
		while((s=listnext(treeroot(t)->bn))!=NULL)
			if(treetoolcomment(s) && colorcomment(s))
				break;
	}
	if(treeroot(t)->al!=NULL && s==NULL)
	{
		startlist(treeroot(t)->al);
		while((s=listnext(treeroot(t)->al))!=NULL)
			if(treetoolcomment(s) && colorcomment(s))
				break;
	}
	if(treeroot(t)->an!=NULL && s==NULL)
	{
		startlist(treeroot(t)->an);
		while((s=listnext(treeroot(t)->an))!=NULL)
			if(treetoolcomment(s) && colorcomment(s))
				break;
	}
	if(treeroot(t)->bd!=NULL && s==NULL)
	{
		startlist(treeroot(t)->bd);
		while((s=listnext(treeroot(t)->bd))!=NULL)
			if(treetoolcomment(s) && colorcomment(s))
				break;
	}
	if(treeroot(t)->ad!=NULL && s==NULL)
	{
		startlist(treeroot(t)->ad);
		while((s=listnext(treeroot(t)->ad))!=NULL)
			if(treetoolcomment(s) && colorcomment(s))
				break;
	}
	return(s);
}

char *find_font_comment(t)
tree t;
{
	char *s;

	s=NULL;
	if(treeroot(t)->bn!=NULL)
	{
		startlist(treeroot(t)->bn);
		while((s=listnext(treeroot(t)->bn))!=NULL)
			if(treetoolcomment(s) && fontcomment(s))
				break;
	}
	if(treeroot(t)->al!=NULL && s==NULL)
	{
		startlist(treeroot(t)->al);
		while((s=listnext(treeroot(t)->al))!=NULL)
			if(treetoolcomment(s) && fontcomment(s))
				break;
	}
	if(treeroot(t)->an!=NULL && s==NULL)
	{
		startlist(treeroot(t)->an);
		while((s=listnext(treeroot(t)->an))!=NULL)
			if(treetoolcomment(s) && fontcomment(s))
				break;
	}
	if(treeroot(t)->bd!=NULL && s==NULL)
	{
		startlist(treeroot(t)->bd);
		while((s=listnext(treeroot(t)->bd))!=NULL)
			if(treetoolcomment(s) && fontcomment(s))
				break;
	}
	if(treeroot(t)->ad!=NULL && s==NULL)
	{
		startlist(treeroot(t)->ad);
		while((s=listnext(treeroot(t)->ad))!=NULL)
			if(treetoolcomment(s) && fontcomment(s))
				break;
	}
	return(s);
}

void remove_format_comments_from_list(l)
list l;
{
	list t;

	if(l==NULL)
		return;

	lfor(l, t)
		if(treetoolcomment(nodeobj(t)))
			t=rmnode(t);
}

void remove_format_comments_from_tree(t)
tree t;
{
	list c;

	lfor(t->nodes, c)
	{
		remove_format_comments_from_list(((treenode)nodeobj(c))->bn);
		remove_format_comments_from_list(((treenode)nodeobj(c))->al);
		remove_format_comments_from_list(((treenode)nodeobj(c))->an);
		remove_format_comments_from_list(((treenode)nodeobj(c))->bd);
		remove_format_comments_from_list(((treenode)nodeobj(c))->ad);
	}
}

char *first_item(s)
char *s;
{
	while(*s!=':')
	{
		if(*s=='\0')
			break;
		s++;
	}
	if(*s=='\0')
		return(NULL);
	s++;
	if(*s=='\0')
		return(NULL);
	while(*s!=':')
	{
		if(*s=='\0')
			break;
		s++;
	}
	if(*s=='\0')
		return(NULL);
	s++;
	if(*s=='\0')
		return(NULL);
	else
		return(s);
}

char *next_item(s)
char *s;
{
	while(*s!=':')
	{
		if(*s=='\0')
			break;
		s++;
	}
	if(*s=='\0')
		return(NULL);
	s++;
	if(*s=='\0')
		return(NULL);
	else
		return(s);
}

void read_color_list(t)
tree t;
{
	char *s;

	cl=newlist();

	s=find_color_comment(t);

	if(s!=NULL)
		for(s=first_item(s);s!=NULL;s=next_item(s))
			addnode(cl, read_color_info(s));
}

void read_font_list(t)
tree t;
{
	char *s;

	fl=newlist();

	s=find_font_comment(t);

	if(s!=NULL)
		for(s=first_item(s);s!=NULL;s=next_item(s))
			addnode(fl, read_font_info(s));
}

/*static int boxedinit, flowerinit;*/

void read_node_comment(n)
treenode n;
{
	char *s;
	nodetypedata fd, bd;

	fd=ndta(n)->flower;
	bd=ndta(n)->boxed;

	s=find_node_comment(n);
	if(s!=NULL)
	{
		for(s=first_item(s);s!=NULL;s=next_item(s))
		{
			if(istoken(s, "nfx"))
				fd->x=read_double(s);
			else if(istoken(s, "nfy"))
				fd->y=read_double(s);
			else if(istoken(s, "nflx"))
				fd->lx=read_int(s);
			else if(istoken(s, "nfly"))
				fd->ly=read_int(s);
			else if(istoken(s, "nfc"))
				fd->c=read_color(s);
			else if(istoken(s, "nff"))
				fd->font=read_font(s);
			else if(istoken(s, "nftr"))
				fd->textisreset=read_int(s);
			else if(istoken(s, "nbx"))
				bd->x=read_double(s);
			else if(istoken(s, "nby"))
				bd->y=read_double(s);
			else if(istoken(s, "nblx"))
				bd->lx=read_int(s);
			else if(istoken(s, "nbly"))
				bd->ly=read_int(s);
			else if(istoken(s, "nbc"))
				bd->c=read_color(s);
			else if(istoken(s, "nbf"))
				bd->font=read_font(s);
			else if(istoken(s, "nbtr"))
				bd->textisreset=read_int(s);
		}
	}
}

void read_branch_comment(b)
treebranch b;
{
	char *s;
	branchtypedata fd, bd;

	fd=bdta(b)->flower;
	bd=bdta(b)->boxed;

	s=find_branch_comment(b);
	if(s!=NULL)
	{
		for(s=first_item(s);s!=NULL;s=next_item(s))
		{
			if(istoken(s, "bft"))
				fd->thickness=read_int(s);
			else if(istoken(s, "bfc"))
				fd->c=read_color(s);
			else if(istoken(s, "bbt"))
				bd->thickness=read_int(s);
			else if(istoken(s, "bbc"))
				bd->c=read_color(s);
		}
	}
}

void read_tree_comment(t)
tree t;
{
	static char *s;
	static char typestring[100];
	static treetypedata fd, bd;

	fd=tdta(t)->flower;
	bd=tdta(t)->boxed;

	s=find_tree_comment(t);
	if(s!=NULL)
	{
		for(s=first_item(s);s!=NULL;s=next_item(s))
		{
			if(istoken(s, "tty"))
			{
				read_string(s, typestring);
				if(strcmp(typestring, BoxedType)==0)
					tdta(t)->type=Boxed;
				else if(strcmp(typestring, FlowerType)==0)
					tdta(t)->type=Flower;
			}
			else if(istoken(s, "tfx"))
			/*{*/
				/*flowerinit=1;*/
				fd->x=read_int(s, "tfx");
			/*}*/
			else if(istoken(s, "tfy"))
				fd->y=read_int(s, "tfy");
			else if(istoken(s, "tfw"))
				fd->w=read_int(s, "tfw");
			else if(istoken(s, "tfh"))
				fd->h=read_int(s, "tfh");
			else if(istoken(s, "tftx"))
				fd->tx=read_double(s, "tftx");
			else if(istoken(s, "tfty"))
				fd->ty=read_double(s, "tfty");
			else if(istoken(s, "tfsx"))
				fd->tscalex=read_longdouble(s, "tfsx");
			else if(istoken(s, "tfsy"))
				fd->tscaley=read_longdouble(s, "tfsy");
			else if(istoken(s, "tfsc"))
				fd->scale=read_double(s, "tfsc");
			else if(istoken(s, "tfsi"))
				fd->showinternals=read_int(s, "tfsi");
			else if(istoken(s, "tfst"))
				fd->showterminals=read_int(s, "tfst");
			else if(istoken(s, "tfsp"))
				fd->showpct=read_int(s, "tfsp");
			else if(istoken(s, "tfpx"))
				fd->px=read_double(s, "tfpx");
			else if(istoken(s, "tfpy"))
				fd->py=read_double(s, "tfpy");
			else if(istoken(s, "tfpv"))
				fd->pv=read_double(s, "tfpv");
			else if(istoken(s, "tfpc"))
				fd->c=read_color(s, "tfpc");
			else if(istoken(s, "tfpf"))
				fd->pfont=read_font(s, "tfpf");
			else if(istoken(s, "tbx"))
			/*{*/
				/*boxedinit=1;*/
				bd->x=read_int(s, "tbx");
			/*}*/
			else if(istoken(s, "tby"))
				bd->y=read_int(s, "tby");
			else if(istoken(s, "tbw"))
				bd->w=read_int(s, "tbw");
			else if(istoken(s, "tbh"))
				bd->h=read_int(s, "tbh");
			else if(istoken(s, "tbtx"))
				bd->tx=read_double(s, "tbtx");
			else if(istoken(s, "tbty"))
				bd->ty=read_double(s, "tbty");
			else if(istoken(s, "tbsx"))
				bd->tscalex=read_longdouble(s, "tbsx");
			else if(istoken(s, "tbsy"))
				bd->tscaley=read_longdouble(s, "tbsy");
			else if(istoken(s, "tbsc"))
				bd->scale=read_double(s, "tbsc");
			else if(istoken(s, "tbsi"))
				bd->showinternals=read_int(s, "tbsi");
			else if(istoken(s, "tbst"))
				bd->showterminals=read_int(s, "tbst");
			else if(istoken(s, "tbsp"))
				bd->showpct=read_int(s, "tbsp");
			else if(istoken(s, "tbpx"))
				bd->px=read_double(s, "tbpx");
			else if(istoken(s, "tbpy"))
				bd->py=read_double(s, "tbpy");
			else if(istoken(s, "tbpv"))
				bd->pv=read_double(s, "tbpv");
			else if(istoken(s, "tbpc"))
				bd->c=read_color(s, "tbpc");
			else if(istoken(s, "tbpf"))
				bd->pfont=read_font(s, "tbpf");
		}
	}
}

void read_tree_comment_info(t)
tree t;
{
	list c;

	read_color_list(t);
	read_font_list(t);
	/*boxedinit=0;*/
	/*flowerinit=0;*/
	lfor(t->nodes, c)
		read_node_comment(nodeobj(c));
	lfor(t->branches, c)
		read_branch_comment(nodeobj(c));
	read_tree_comment(t);
	freelist(cl);
	freelist(fl);
	/*tdta(t)->flower->initialized=flowerinit;*/
	/*tdta(t)->boxed->initialized=boxedinit;*/
	adjust_flower_tree_parameters(t);
	adjust_boxed_tree_parameters(t);
	adjust_tree_type_parameters(t);
}

int formatted_tree(t)
{
	if(find_tree_comment(t)!=NULL)
		return(1);
	else
		return(0);
}
