#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "interface.h"

#include "treedata.h"

node_update_label_position(n, t)
treenode n;
tree_type t;
{
    static treetypedata td;
    static nodetypedata nd;
    static int nx, ny;

    td=ttdta(tree_get_tree(n),t);

	nd=tndta(n,t);
	nx=nodex(nd, td)+nd->lx;
	ny=nodey(nd, td)+nd->ly;
	ttext_move(nd->label, nx, ny);
}

tree_move_all_labels(t, ty)
tree t;
tree_type ty;
{
    static list c;
    static treetypedata td;
    static nodetypedata nd;
    static int nx, ny;

    td=ttdta(t,ty);

    lfor(t->nodes, c)
    {
        nd=tndta(nodeobj(c),ty);
        nx=nodex(nd, td)+nd->lx;
        ny=nodey(nd, td)+nd->ly;
        ttext_move(nd->label, nx, ny);
    }
	td->labelsinvalid=0;
}

position_breaknode(n, ty)
treenode n;
tree_type ty;
{
	static treenode p, c;
	static nodetypedata nd, pd, cd;
	static double dist;
	static list l;

	p=parent(n);
	firstsubtree(n, &l);
	c=subtree(l);
	nd=tndta(n, ty);
	pd=tndta(p, ty);
	cd=tndta(c, ty);
	parentdistance(n, &dist);

	if(ty==Boxed ||
		(ty==NoTreeType && tdta(tree_get_tree(n))->type==Boxed))
	{
		nd->x=pd->x+dist;
		nd->y=cd->y;
	}
	else if(ty==Flower ||
		(ty==NoTreeType && tdta(tree_get_tree(n))->type==Flower))
	{
		nd->a=cd->a;
		nd->x=pd->x+dist*cos(nd->a);
		nd->y=pd->y+dist*sin(nd->a);
	}

	node_update_label_position(n, ty);
}

translate_subtree(n, x, y, ty)
/* move subtree n to position x,y */
treenode n;
double x, y;
tree_type ty;
{
	nodetypedata nd, pd;
	double dx, dy, dist;

	nd=tndta(n, ty);
	parentdistance(n, &dist);
	if(ty==Boxed ||
		(ty==NoTreeType && tdta(tree_get_tree(n))->type==Boxed))
	{
		dx=nd->x-dist-x;
		dy=nd->y-y;
	}
	else if(ty==Flower ||
		(ty==NoTreeType && tdta(tree_get_tree(n))->type==Flower))
	{
		dx=nd->x-dist*cos(nd->a)-x;
		dy=nd->y-dist*sin(nd->a)-y;
	}

	move_subtree(n, ty, -dx, -dy);
}

/* boxed routines */

choose_x_locations(n)
treenode n;
{
	nodetypedata nd, pd;
	treenode p;
	list t;
	double dist;

	nd=tndta(n,Boxed);

	p=parent(n);

	if(p==NULL)
		nd->x=0.0;
	else
	{
		pd=tndta(p, Boxed);
		parentdistance(n, &dist);
		nd->x=pd->x+dist;
	}

	tforsubtree(n, t)
		choose_x_locations(subtree(t));
}


double initialize_node_locations_boxed(n, d, bt, w, start, y1, y2, scalex)
treenode n;
double d;
branch_type bt;
int w;
double *start, *y1, *y2, *scalex;
{
	nodetypedata nd;
	double t;
	list c;
	int putmidway;
	double topy, boty;
	int texth, textw;

	nd=tndta(n, Boxed);

	/* set label offsets */
	nd->lx=INITBOXLX;
	texth=ttext_height(nd->label);
	textw=ttext_width(nd->label);
	nd->ly=-texth/2;

	/* set x position */
	nd->x=d;

	putmidway=0;
	if(!showlabel(n, Boxed))
		putmidway=1;
	
	/* do first subtree */
	firstsubtree(n, &c);
	if(c!=NULL && !nd->childrenhidden)
	{
		parentdistance(subtree(c), &t);
		topy=boty=initialize_node_locations_boxed(subtree(c), d+t, bt,
			w, start, y1, y2, scalex);
	}
	else
		putmidway=0;
	
	if(!putmidway)
	{
		/* put room for parent node */
		nd->y=*start-nd->ly;
		*start+=tfont_height(nd->font);
	}
	if(c!=NULL)
	{
		nextsubtree(n, &c);
		while(c!=NULL)
		{
			parentdistance(subtree(c), &t);
			boty=initialize_node_locations_boxed(subtree(c), d+t, bt,
				w, start, y1, y2, scalex);
			nextsubtree(n, &c);
		}
	}
	if(putmidway)
		nd->y=(topy+boty)/2.0;

	/* calculate bounds */
	if(showlabel(n, Boxed))
	{
		if(*scalex==-1.0 || (w-textw-nd->lx)/nd->x<*scalex)
			*scalex=(w-textw-nd->lx)/nd->x;
		if(nd->y+nd->ly<*y1)
			*y1=nd->y+nd->ly;
		if(nd->y+nd->ly+texth>*y2)
			*y2=nd->y+nd->ly+texth;
	}
	else
	{
		if(*scalex==-1.0 || w/nd->x<*scalex)
			*scalex=w/nd->x;
		if(nd->y<*y1)
			*y1=nd->y;
		if(nd->y>*y2)
			*y2=nd->y;
	}

	return(nd->y);
}

reset_scale_bar_position(t,ty)
tree t;
tree_type ty;
{
	treetypedata td;

	td=ttdta(t,ty);

	td->percentisreset=1;
	td->px=td->x+td->w/2;
	td->py=td->y+td->h+25;
	center_scale_bar(td);
	center_scale_bar_text(td);
}

initialize_format_boxed(t)
tree t;
{
	static treetypedata td;
	static double scalex, y1, y2, start;
	static int w;

	td=tdta(t)->boxed;

	td->x=INITBOXX;
	td->y=INITBOXY;

	start=0.0;
	y1=y2=0.0;
	w=INITBOXWIDTH-TREEMARGINX*2;
	scalex=-1.0;

	initialize_node_locations_boxed(treeroot(t), 0.0, td->bt,
		w, &start, &y1, &y2, &scalex);

	td->tscaley=1.0;
	td->tscalex=scalex;

	td->w=INITBOXWIDTH;
	td->h=(y2-y1)*td->tscaley+TREEMARGINY*2;

	td->tx=TREEMARGINX;
	td->ty=TREEMARGINY-y1*td->tscaley;

	tree_move_all_labels(t, Boxed);

	reset_scale_bar_position(t, Boxed);

	canvas_add_tree(t);
	td->initialized=1;
}

void reset_even_spacing_boxed(t)
tree t;
{
	static treetypedata td;
	static int w;
	static double start, bot, top, scalex;

	td=tdta(t)->boxed;

	w=td->w-TREEMARGINX*2;

	start=bot=top=0.0;
	scalex=-1.0;

	canvas_add_tree(t);

	initialize_node_locations_boxed(treeroot(t), 0.0, td->bt,
		w, &start, &top, &bot, &scalex);
	
	td->tscaley=1.0;

	td->h=(bot-top)*td->tscaley+TREEMARGINY*2;

	td->tx=TREEMARGINX;
	td->ty=TREEMARGINY-top*td->tscaley;

	tree_move_all_labels(t, Boxed);

	refit_tree(t, Boxed);

	if(td->percentisreset)
		reset_scale_bar_position(t, Boxed);

	td->spacinginvalid=0;
	td->formatinvalid=0;
	td->boxinvalid=0;
}

void reset_even_spacing_flower(t)
tree t;
{
	static treetypedata td;
	static int w, h;

	td=tdta(t)->flower;

	w=td->w-TREEMARGINX*2;
	h=td->h-TREEMARGINY*2;

	canvas_add_tree(t);

	initialize_node_locations_flower(treeroot(t));
	
	/*td->tscaley=1.0;*/
	/*td->tscalex=1.0;*/

	/*td->h=(bot-top)*td->tscaley+TREEMARGINY*2;*/

	/*td->tx=TREEMARGINX;*/
	/*td->ty=TREEMARGINY-top*td->tscaley;*/

	/*tree_move_all_labels(t, Flower);*/

	/*refit_tree(t, Flower);*/

	/*if(td->percentisreset)*/
		/*reset_scale_bar_position(t, Flower);*/

	resize_whole_tree_flower(t, td->x, td->y, w, h);

	td->spacinginvalid=0;
	td->formatinvalid=0;
	td->boxinvalid=0;
}

int reset_even_spacing(t, ty)
tree t;
tree_type ty;
{
	if(ty==Boxed || (ty==NoTreeType && tdta(t)->type==Boxed))
	{
		reset_even_spacing_boxed(t);
		modify();
		return(1);
	}
	if(ty==Flower || (ty==NoTreeType && tdta(t)->type==Flower))
	{
		reset_even_spacing_flower(t);
		modify();
		return(1);
	}
}

/* flower routines */

reset_label_location_flower(n)
/* calculates lx and ly based on the branch's angle */
treenode n;
{
	static nodetypedata nd, ud;
	static treenode p;
	static double dx, dy;
	static double a, s, c;
	static double w, h, dw, dh;
	static xsign, ysign;

	nd=ndta(n)->flower;
	nd->textisreset=1;
	p=parent(n);

	if(p==NULL)
	{
		nd->lx=INITBOXLX;
		if(nd->label==NULL)
			nd->ly=0;
		else
			nd->ly=-ttext_height(nd->label)/2;
	}
	else if(nd->label!=NULL)
	{
		ud=ndta(p)->flower;

		/* get branch vector */
		dx=nd->x-ud->x;
		dy=nd->y-ud->y;

		/* normalize to positive, save signs */
		if(dx<0.0)
		{
			xsign=-1.0;
			dx*=-1.0;
		}
		else
			xsign=1.0;
		if(dy<0.0)
		{
			ysign=-1.0;
			dy*=-1.0;
		}
		else
			ysign=1.0;

		/* width and height from center of text to top left corner */
		w=ttext_width(nd->label)/2;
		h=ttext_height(nd->label)/2;

		/* calculate sin and cos of angle */
		if(dy==0.0 && dx==0.0)
			a=0.0;
		else
			a=atan2(dy,dx);
		sincos(a,&s,&c); /* s=sin, c=cos */

		/* find vector from center of text to an edge, in the same direction
			as the branch vector */

		if(dy==0.0)
		{
			dw=w;
			dh=0.0;
		}
		else if(dx==0.0)
		{
			dh=h;
			dw=0.0;
		}
		else
		{
			dw=dx*h/dy;
			dh=dy*w/dx;

			if(dw>w)
				dw=w;
			else
				dh=h;
		}

		/* add on extra to push label away from node */
		
		dw+=INITFLOWERLOFF*c;
		dh+=INITFLOWERLOFF*s;

		/* return signs */
		dw*=xsign;
		dh*=ysign;

		/* normalize to offset to top left, not to center */
		dw-=w;
		dh-=h;

		nd->lx=dw;
		nd->ly=dh;
	}
}

reset_subtree_label_locations_flower(n)
treenode n;
{
	list t;

	reset_label_location_flower(n);
	tforsubtree(n, t)
		reset_subtree_label_locations_flower(subtree(t));
}

int calculate_number_of_leaves(n)
treenode n;
{
	nodetypedata nd;
	list t;
	int num;

	nd=ndta(n)->flower;

	if(treeleaf(n))
		num=1;
	else
	{
		num=0;
		tforsubtree(n, t)
			num+=calculate_number_of_leaves(subtree(t));
	}
	nd->tmp=num;
	return(num);
}

void calculate_angles(n, angle, room)
treenode n;
double angle, room;
{
	nodetypedata nd, td;
	list t;
	double roomperleaf, newroom, newangle;

	nd=ndta(n)->flower;

	nd->a=angle;

	if(!treeleaf(n))
	{

		roomperleaf=room/nd->tmp;
		newangle=angle-room/2;

		tforsubtree(n, t)
		{
			td=ndta(subtree(t))->flower;
			newroom=roomperleaf*td->tmp;
			newangle+=newroom/2;
			calculate_angles(subtree(t), newangle, newroom);
			newangle+=newroom/2;
		}
	}
}

choose_positions(n)
treenode n;
{
	nodetypedata nd, pd;
	treenode p;
	list t;
	double dist;

	nd=ndta(n)->flower;
		

	p=parent(n);

	if(p==NULL)
	{
		nd->x=0.0;
		nd->y=0.0;
	}
	else
	{
		pd=ndta(p)->flower;
		parentdistance(n, &dist);
		nd->x=pd->x+dist*cos(nd->a);
		nd->y=pd->y+dist*sin(nd->a);
	}
	if(nd->textisreset)
		reset_label_location_flower(n);
	tforsubtree(n, t)
		choose_positions(subtree(t));
}

initialize_node_locations_flower(n)
treenode n;
{
	calculate_number_of_leaves(n);
	calculate_angles(n, 0.0, 2*M_PI);
	choose_positions(n);
}

initialize_format_flower(t)
tree t;
{
	static treetypedata td;
	static int w;

	td=tdta(t)->flower;

	/* choose format */
	initialize_node_locations_flower(treeroot(t));

	/* choose label positions */
	/* done in initialize, choose_positions now */
	/*reset_subtree_label_locations_flower(treeroot(t));*/

	/* resize tree to fit initial size */
	resize_whole_tree_flower(t, INITFLOWERX, INITFLOWERY,
		INITFLOWERSIZE, INITFLOWERSIZE);

	td->initialized=1;
}

tree_full_extents(t, ty, x1, y1, x2, y2)
tree t;
tree_type ty;
double *x1, *y1, *x2, *y2;
{
    static list c;
    static nodetypedata nd;
    static treetypedata td;
    static double tx1, ty1, tx2, ty2;

    td=ttdta(t, ty);
    c=firstnode(t->nodes);
    nd=tndta(nodeobj(c),ty);
    *x1=nodex(nd, td);
    *y1=nodey(nd, td);
    *x2=nodex(nd, td);
    *y2=nodey(nd, td);

    lfor(t->nodes, c)
    {
        nd=tndta(nodeobj(c), ty);
		if(!nd->hidden)
		{
			tx1=nodex(nd, td)+nd->lx;
			ty1=nodey(nd, td)+nd->ly;
			tx2=tx1+ttext_width(nd->label);
			ty2=ty1+ttext_height(nd->label);
			if(nodex(nd, td)<*x1)
				*x1=nodex(nd, td);
			if(nodey(nd, td)<*y1)
				*y1=nodey(nd, td);
			if(nodex(nd, td)>*x2)
				*x2=nodex(nd, td);
			if(nodey(nd, td)>*y2)
				*y2=nodey(nd, td);
			if(showlabel(nodeobj(c), ty))
			{
				if(tx1<*x1)
					*x1=tx1;
				if(ty1<*y1)
					*y1=ty1;
				if(tx2>*x2)
					*x2=tx2;
				if(ty2>*y2)
					*y2=ty2;
			}
		}
    }
}

refit_tree(t, ty)
/* a node has moved, or a text has changed size, so the tree may no longer
	fit in it's box */
/* resize box, and adjust tx, ty */
tree t;
tree_type ty;
{
	static double x1, y1, x2, y2;
	static treetypedata td;
	static int oldy, oldx;

	td=ttdta(t,ty);

	canvas_add_tree(t);

	/* get maximum extents */
	tree_full_extents(t, ty, &x1, &y1, &x2, &y2);

	td->w=x2-x1+TREEMARGINX*2;
	td->h=y2-y1+TREEMARGINY*2;

	oldx=td->x;
	oldy=td->y;
	td->x=x1-TREEMARGINX;
	td->y=y1-TREEMARGINY;

	td->tx-=(td->x-oldx);
	td->ty-=(td->y-oldy);

	canvas_add_tree(t);

	td->boxinvalid=0;
}

tree_extents_internal(t, ty, y1, y2, w, scalex)
tree t;
tree_type ty;
int w;
double *y1, *y2, *scalex;
{
    static list c;
    static nodetypedata nd;
    static treetypedata td;
    static double tx1, ty1, tx2, ty2;
	static int textw, texth;

	td=ttdta(t, ty);

    c=firstnode(t->nodes);
    nd=tndta(nodeobj(c), ty);

	/* calculate initial bounds */
	if(showlabel(nodeobj(c), ty))
	{
		*scalex=(w-ttext_width(nd->label)-nd->lx)/nd->x;
		*y1=nodey(nd, td)+nd->ly;
		*y2=nodey(nd, td)+nd->ly+ttext_height(nd->label);
	}
	else
	{
		*scalex=w/nd->x;
		*y1=nodey(nd, td);
		*y2=nodey(nd, td);
	}

    lfor(t->nodes, c)
    {
        nd=tndta(nodeobj(c), ty);
        textw=ttext_width(nd->label);
        texth=ttext_height(nd->label);

		/* calculate bounds */
		if(showlabel(nodeobj(c), ty))
		{
			if((w-textw-nd->lx)/nd->x<*scalex)
				*scalex=(w-textw-nd->lx)/nd->x;
			if(nodey(nd, td)+nd->ly<*y1)
				*y1=nodey(nd, td)+nd->ly;
			if(nodey(nd, td)+nd->ly+texth>*y2)
				*y2=nodey(nd, td)+nd->ly+texth;
		}
		else
		{
			if(w/nd->x<*scalex)
				*scalex=w/nd->x;
			if(nodey(nd, td)<*y1)
				*y1=nodey(nd, td);
			if(nodey(nd, td)>*y2)
				*y2=nodey(nd, td);
		}
    }
}

change_scale_to_fit_boxed(t, w, h, top, left)
tree t;
int w, h;
double *top, *left;
{
	nodetypedata nd;
	treetypedata td;
	list n;
	int more;
	int first;
	double newscale;
	double nx, ny;
	double x1, x2, y1, y2;
	double nx1, ny1;
	double width, height;
	int tx, tw, ty, th;
	int textw;
	int numit;

	td=tdta(t)->boxed;

	width=td->w;
	w-=TREEMARGINX*2;
	width-=TREEMARGINX*2;

    n=firstnode(t->nodes);
    nd=tndta(nodeobj(n), Boxed);

	/* calculate initial bounds */
	if(showlabel(nodeobj(n), Boxed))
		newscale=(w-ttext_width(nd->label)-nd->lx)/nd->x;
	else
		newscale=w/nd->x;

    lfor(t->nodes, n)
    {
        nd=tndta(nodeobj(n), Boxed);
		if(!nd->hidden)
		{
			textw=ttext_width(nd->label);

			/* calculate bounds */
			if(showlabel(nodeobj(n), Boxed))
			{
				if((w-textw-nd->lx)/nd->x<newscale)
					newscale=(w-textw-nd->lx)/nd->x;
			}
			else
			{
				if(w/nd->x<newscale)
					newscale=w/nd->x;
			}
		}
    }

	td->tscalex=newscale;

	height=td->h;
	h-=TREEMARGINY*2;
	height-=TREEMARGINY*2;

	n=firstnode(t->nodes);
	n=nextnode(n);
	if(n==NULL)
		return;

	newscale=1.0;
	more=1;
	numit=0;

	do
	{
		numit++;
		/* find current height */
		first=1;
		lfor(t->nodes, n)
		{
			nd=ndta(nodeobj(n))->boxed;
			if(!nd->hidden)
			{
				ty=nd->y*newscale;
				tx=nd->x*newscale;
				if(first)
				{
					y1=ty;
					y2=ty;
					x1=tx;
					first=0;
				}
				th=ttext_height(nd->label);
				if(tx<x1)
					x1=tx;
				if(ty<y1)
					y1=ty;
				if(ty>y2)
					y2=ty;
				if(ty+nd->ly<y1)
					y1=ty+nd->ly;
				if(ty+nd->ly+th>y2)
					y2=ty+nd->ly+th;
			}
		}
		height=y2-y1;

		if(fabs(height-h)>=0.5)
		{
			ny=h/height;
			newscale*=ny;
		}
		else
			more=0;
	} while(more && numit<20);

	/* get top-left node */
	*top=y1;
	*left=x1;

	td->tscaley=newscale;
}

resize_whole_tree_boxed(t, x, y, w, h)
tree t;
int x, y, w, h;
{
	static treetypedata td;
	static double top, left;

	canvas_add_tree(t);

	td=tdta(t)->boxed;

	if(td->w!=w || td->h!=h)
	{
		change_scale_to_fit_boxed(t, w, h, &top, &left);

		td->x=x;
		td->y=y;

		td->w=w;
		td->h=h;

		td->tx=TREEMARGINX-left;
		td->ty=TREEMARGINY-top;
	}
	else
	{
		td->x=x;
		td->y=y;
	}

	tree_move_all_labels(t, Boxed);


	refit_tree(t, Boxed);

	if(td->percentisreset)
		reset_scale_bar_position(t, Boxed);
	else
		center_scale_bar(ttdta(t, Boxed));

	canvas_add_tree(t);
}

change_scale_to_fit_flower(t, w, h, top, left)
tree t;
int w, h;
double *top, *left;
{
	nodetypedata nd;
	treetypedata td;
	list n;
	int more;
	int first;
	double newscale;
	double nx, ny;
	double x1, x2, y1, y2;
	double nx1, ny1;
	double width, height;
	int tx, tw, ty, th;
	int numit;

	td=tdta(t)->flower;

	width=td->w;
	height=td->h;
	w-=TREEMARGINX*2;
	width-=TREEMARGINX*2;
	h-=TREEMARGINY*2;
	height-=TREEMARGINY*2;

	n=firstnode(t->nodes);
	n=nextnode(n);
	if(n==NULL)
		return;

	newscale=1.0;
	more=1;
	numit=0;

	do
	{
		numit++;
		/* find current width */
		first=1;
		lfor(t->nodes, n)
		{
			nd=ndta(nodeobj(n))->flower;
			if(!nd->hidden)
			{
				tx=nd->x*newscale;
				ty=nd->y*newscale;
				if(first)
				{
					x1=tx;
					y1=ty;
					x2=tx;
					y2=ty;
					first=0;
				}
				tw=ttext_width(nd->label);
				th=ttext_height(nd->label);
				if(tx<x1)
					x1=tx;
				if(tx>x2)
					x2=tx;
				if(ty<y1)
					y1=ty;
				if(ty>y2)
					y2=ty;
				if(tx+nd->lx<x1)
					x1=tx+nd->lx;
				if(ty+nd->ly<y1)
					y1=ty+nd->ly;
				if(tx+nd->lx+tw>x2)
					x2=tx+nd->lx+tw;
				if(ty+nd->ly+th>y2)
					y2=ty+nd->ly+th;
			}
		}
		width=x2-x1;
		height=y2-y1;

		if(fabs(width-w)>=5.0 && fabs(height-h)>=5.0)
		{
			nx=w/width;
			ny=h/height;
			if(nx<1.0 && ny < 1.0)
			{
				if(nx>ny)
					newscale*=nx;
				else
					newscale*=ny;
			}
			else if(nx<1.0)
			{
				newscale*=nx;
			}
			else if(ny<1.0)
			{
				newscale*=ny;
			}
			else
			{
				if(nx>ny)
					newscale*=ny;
				else
					newscale*=nx;
			}
		}
		else
			more=0;
	} while(more && numit<20);

	/* get top-left node */
	*top=y1;
	*left=x1;

	td->tscalex=newscale;
	td->tscaley=newscale;
}

resize_whole_tree_flower(t, x, y, w, h)
tree t;
int x, y, w, h;
{
	static treetypedata td;
	static double top, left;

	canvas_add_tree(t);

	td=tdta(t)->flower;

	if(td->w!=w || td->h!=h)
	{
		change_scale_to_fit_flower(t, w, h, &top, &left);

		td->x=x;
		td->y=y;

		td->w=w;
		td->h=h;

		td->tx=TREEMARGINX-left;
		td->ty=TREEMARGINY-top;
	}
	else
	{
		td->x=x;
		td->y=y;
	}

	tree_move_all_labels(t, Flower);


	refit_tree(t, Flower);

	if(td->percentisreset)
		reset_scale_bar_position(t, Flower);
	else
		center_scale_bar(ttdta(t, Flower));

	canvas_add_tree(t);
}

resize_whole_tree(t, ty, x, y, w, h)
tree t;
tree_type ty;
int x, y, w, h;
{
	if(ty==Boxed || (ty==NoTreeType && tdta(t)->type==Boxed))
		resize_whole_tree_boxed(t, x, y, w, h);
	else if(ty==Flower || (ty==NoTreeType && tdta(t)->type==Flower))
		resize_whole_tree_flower(t, x, y, w, h);
	modify();
}

tree_get_minmax_size(t, ty, sx, sy, bx, by)
tree t;
tree_type ty;
double *sx, *sy, *bx, *by;
{
    static list c;
    static nodetypedata nd;
    static double tx1, ty1, tx2, ty2;
    static double x1, y1, x2, y2;
    static int num_nodes;


    x1=0.0;
    y1=0.0;
    x2=0.0;
    y2=0.0;
    num_nodes=0;

    lfor(t->nodes, c)
    {
        num_nodes++;
        /* calculate maxes for this node */
        nd=tndta(nodeobj(c), ty);
        tx1=nd->lx;
        ty1=nd->ly;
        tx2=tx1+ttext_width(nd->label);
        ty2=ty1+ttext_height(nd->label);
        if(tx1<x1)
            x1=tx1;
        if(ty1<y1)
            y1=ty1;
        if(tx2>x2)
            x2=tx2;
        if(ty2>y2)
            y2=ty2;
    }
    /* now x,y1,2=min size of tree */
    *sx=(x2-x1)+TREEMARGINX*2;
    *sy=(y2-y1)+TREEMARGINY*2;
    *bx=-1.0;
    *by=-1.0;
    if(num_nodes==1)
    {
        *bx=*sx;
        *by=*sy;
    }
}

move_whole_tree(t, ty, dx, dy)
tree t;
tree_type ty;
int dx, dy;
{
	static int nx, ny;
	static treetypedata td;
	static nodetypedata nd;

	canvas_add_tree(t);

	td=ttdta(t, ty);

	td->x+=dx;
	td->y+=dy;
	td->px+=dx;
	td->py+=dy;
	td->plx+=dx;
	td->ply+=dy;
	nx=td->px-ttext_width(td->percent)/2.0;
	ny=td->py-SCALEBARLY-ttext_height(td->percent);
	ttext_move(td->percent, nx, ny);
	tree_move_all_labels(t, ty);
	modify();

	canvas_add_tree(t);
}

move_subtree1(n, ty, dx, dy)
treenode n;
tree_type ty;
double dx, dy;
{
	list t;
	nodetypedata nd;
	treetypedata td;
	int nx, ny;

	canvas_add_node(n);

	nd=tndta(n, ty);
	td=ttdta(tree_get_tree(n), ty);

	nd->x+=dx;
	nd->y+=dy;
	nx=nodex(nd, td)+nd->lx;
	ny=nodey(nd, td)+nd->ly;
	ttext_move(nd->label, nx, ny);

	canvas_add_node(n);
	tforsubtree(n, t)
		move_subtree1(subtree(t), ty, dx, dy);
}

move_subtree(n, ty, dx, dy)
treenode n;
tree_type ty;
double dx, dy;
{
	static treetypedata td;

	td=ttdta(tree_get_tree(n), ty);
	dx=dx/td->tscalex;
	dy=dy/td->tscaley;
	move_subtree1(n, ty, dx, dy);
}

move_node(n, ty, dx, dy)
treenode n;
tree_type ty;
double dx, dy;
{
	static list t;
	static nodetypedata nd;
	static treetypedata td;
	static int nx, ny;

	canvas_add_node(n);

	nd=tndta(n, ty);
	td=ttdta(tree_get_tree(n), ty);

	dx=dx/td->tscalex;
	dy=dy/td->tscaley;
	nd->x+=dx;
	nd->y+=dy;
	nx=nodex(nd, td)+nd->lx;
	ny=nodey(nd, td)+nd->ly;
	ttext_move(nd->label, nx, ny);

	canvas_add_node(n);
}

node_full_extents(n, ty, x1, y1, x2, y2)
treenode n;
tree_type ty;
double *x1, *y1, *x2, *y2;
{
	static list c;
	static nodetypedata nd;
	static double tx1, ty1, tx2, ty2;
	static treetypedata td;


	/* calculate maxes for this node */
	nd=tndta(n, ty);
	td=ttdta(tree_get_tree(n), ty);
	*x1=nodex(nd, td);
	*y1=nodey(nd, td);
	*x2=nodex(nd, td);
	*y2=nodey(nd, td);
	tx1=nodex(nd, td)+nd->lx;
	ty1=nodey(nd, td)+nd->ly;
	tx2=tx1+ttext_width(nd->label);
	ty2=ty1+ttext_height(nd->label);
	if(tx1<*x1)
		*x1=tx1;
	if(ty1<*y1)
		*y1=ty1;
	if(tx2>*x2)
		*x2=tx2;
	if(ty2>*y2)
		*y2=ty2;
}

subtree_full_extents1(n, ty, x1, y1, x2, y2, td)
treenode n;
tree_type ty;
double *x1, *y1, *x2, *y2;
treetypedata td;
{
	list c;
	nodetypedata nd;
	double tx1, ty1, tx2, ty2;


	/* calculate maxes for this node */
	nd=tndta(n, ty);
	tx1=nodex(nd, td)+nd->lx;
	ty1=nodey(nd, td)+nd->ly;
	tx2=tx1+ttext_width(nd->label);
	ty2=ty1+ttext_height(nd->label);
	if(nodex(nd, td)<*x1)
		*x1=nodex(nd, td);
	if(nodey(nd, td)<*y1)
		*y1=nodey(nd, td);
	if(nodex(nd, td)>*x2)
		*x2=nodex(nd, td);
	if(nodey(nd, td)>*y2)
		*y2=nodey(nd, td);
	if(tx1<*x1)
		*x1=tx1;
	if(ty1<*y1)
		*y1=ty1;
	if(tx2>*x2)
		*x2=tx2;
	if(ty2>*y2)
		*y2=ty2;
	/* do for children */
	tforsubtree(n, c)
		subtree_full_extents1(subtree(c), ty, x1, y1, x2, y2, td);
}

subtree_full_extents(n, ty, x1, y1, x2, y2)
treenode n;
tree_type ty;
double *x1, *y1, *x2, *y2;
{
	static list c;
	static nodetypedata nd;
	static treetypedata td;
	static double tx1, ty1, tx2, ty2;


	td=ttdta(tree_get_tree(n), ty);
	nd=tndta(n, ty);
	/* initialize values */
	*x1=nodex(nd, td);
	*y1=nodey(nd, td);
	*x2=nodex(nd, td);
	*y2=nodey(nd, td);
	/* calculate max for all nodes in subtree */
	subtree_full_extents1(n, ty, x1, y1, x2, y2, td);
}

subtree_range1(n, ty, pa, px, py, a1, a2)
treenode n;
tree_type ty;
double pa;
double px, py;
double *a1, *a2;
{
	list t;
	nodetypedata nd;
	double ta;
	double ta1, ta2;

	nd=tndta(n, ty);

	/* work with this node's angle */
	ta=atan2(nd->y-py, nd->x-px)-pa;
	pos_angle(ta);

	nd->a1=nd->a2=ta;

	tforsubtree(n, t)
	{
		subtree_range1(subtree(t), ty, pa, px, py, &ta1, &ta2);
		if(ta1<nd->a1)
			nd->a1=ta1;
		if(ta2>nd->a2)
			nd->a2=ta2;
	}

	*a1=nd->a1;
	*a2=nd->a2;
	nd->a1+=pa;
	nd->a2+=pa;
}

subtree_range(n, ty, a1, a2)
treenode n;
tree_type ty;
double *a1, *a2;
{
	nodetypedata nd, pd;
	list t;
	int first;
	double ta1, ta2;

	if(parent(n)==NULL)
		return;
	nd=tndta(n, ty);
	pd=tndta(parent(n), ty);
	subtree_range1(n, ty,
			nd->a+M_PI, pd->x, pd->y, a1, a2);
	*a1+=nd->a+M_PI;
	*a2+=nd->a+M_PI;
}

reformat_new_tree(t)
/* reformats newly created tree around the nodes that were pasted into it */
tree t;
{
	treetypedata td;
	static double x1, y1, x2, y2;

	/* do boxed first */
	td=ttdta(t, Boxed);

	choose_x_locations(treeroot(t));
	td->x=0;
	td->y=0;
	td->tx=0.0;
	td->ty=0.0;
	tree_full_extents(t, Boxed, &x1, &y1, &x2, &y2);
	td->w=x2-x1+TREEMARGINX*2;
	td->h=y2-y1+TREEMARGINY*2;
	td->tx=TREEMARGINX-x1;
	td->ty=TREEMARGINY-y1;
	td->x=INITBOXX;
	td->y=INITBOXY;
	tcontext_set_foreground(td->gc, td->c);
	tcontext_set_font(td->gc, td->pfont);
	ttext_set_color(td->percent, td->c);
	ttext_change_font(td->percent, td->pfont);
	reset_scale_bar_position(t, Boxed);
	invalidate_labels(t, Boxed);
	invalidate_spacing(t, Boxed);

	/* do flower next */
	td=ttdta(t, Flower);

	choose_positions(treeroot(t));
	td->x=0;
	td->y=0;
	td->tx=0.0;
	td->ty=0.0;
	tree_full_extents(t, Flower, &x1, &y1, &x2, &y2);
	td->w=x2-x1+TREEMARGINX*2;
	td->h=y2-y1+TREEMARGINY*2;
	td->tx=TREEMARGINX-x1;
	td->ty=TREEMARGINY-y1;
	td->x=INITFLOWERX;
	td->y=INITFLOWERY;
	tcontext_set_foreground(td->gc, td->c);
	tcontext_set_font(td->gc, td->pfont);
	ttext_set_color(td->percent, td->c);
	ttext_change_font(td->percent, td->pfont);
	reset_scale_bar_position(t, Flower);
	invalidate_labels(t, Flower);
	invalidate_spacing(t, Flower);
}
