#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

treenode move_parent()
{
	treenode n, p;

	n=(treenode)first_selected_node();
	if(n==NULL)
		return(NULL);

	p=parent(n);
	return(p);
}

treenode move_left_child()
{
	treenode n, p;
	list t;

	n=(treenode)first_selected_node();
	if(n==NULL)
		return(NULL);

	lastsubtree(n, &t);
	if(t==NULL)
		return(NULL);

	p=subtree(t);
	return(p);
}

treenode move_right_child()
{
	treenode n, p;
	list t;

	n=(treenode)first_selected_node();
	if(n==NULL)
		return(NULL);

	firstsubtree(n, &t);
	if(t==NULL)
		return(NULL);

	p=subtree(t);
	return(p);
}

treenode move_right_sister()
{
	treenode n, p;
	list t;

	n=(treenode)first_selected_node();
	if(n==NULL)
		return(NULL);
	
	p=parent(n);
	if(p==NULL)
		return(NULL);
	
	firstsubtree(p, &t);
	while(t!=NULL)
		if(subtree(t)==n)
			break;
		else
			nextsubtree(p, &t);
	if(t==NULL)
		return(NULL);
	nextsubtree(p, &t);
	if(t==NULL)
		return(NULL);

	return(subtree(t));
}

treenode move_left_sister()
{
	treenode n, p;
	list t;

	n=(treenode)first_selected_node();
	if(n==NULL)
		return(NULL);
	
	p=parent(n);
	if(p==NULL)
		return(NULL);
	
	lastsubtree(p, &t);
	while(t!=NULL)
		if(subtree(t)==n)
			break;
		else
			prevsubtree(p, &t);
	if(t==NULL)
		return(NULL);
	prevsubtree(p, &t);
	if(t==NULL)
		return(NULL);

	return(subtree(t));
}

int move_selection(c, e)
command c;
tevent e;
{
	treenode p;

	p=NULL;

	switch(c)
	{
		case MoveToParent:
			p=move_parent();
			break;
		case MoveToLeftChild:
			p=move_right_child();
			break;
		case MoveToRightChild:
			p=move_left_child();
			break;
		case MoveToLeftSister:
			p=move_left_sister();
			break;
		case MoveToRightSister:
			p=move_right_sister();
			break;
		default:
			break;
		
	}

	if(p==NULL)
		return(0);

	select_by_state(NodeSubtreeSel, p, 0.0, e);
	move_node_on_screen(p);
	return(1);
}
