#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

static int dragging=0;
static int fx, fy, ow, oh;

int do_drag_box(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static int result;

	result=0;

	if(installing)
	{
		dragging=0;
		canvas_add_event_function(do_drag_box, f);
		return(1);
	}
	else if(uninstalling)
	{
		canvas_remove_event_function(do_drag_box);
		return(1);
	}
	else if(printing) printf("zdragbox\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			if(!dragging)
			{
				select_by_state(NoSel, NULL, 0.0, e);
				uninstall(do_change_text);
				dragging=1;
				install_dragging_function(do_drag_box);
				fx=x;
				fy=y;
				ow=0;
				oh=0;
				drag_rectangle(c, fx, fy, ow, oh);
			}
			result=1;
			break;
		case te_drag:
			if(dragging)
			{
				drag_rectangle(c, fx, fy, ow, oh);
				ow=x-fx;
				oh=y-fy;
				drag_rectangle(c, fx, fy, ow, oh);
				result=1;
			}
			break;
		case te_mouseup:
			if(dragging)
			{
				dragging=0;
				uninstall_dragging_function(do_drag_box);
				drag_rectangle(c, fx, fy, ow, oh);
				ow=x-fx;
				oh=y-fy;
				if(ow!=0 && oh!=0)
				{
					normalize_rect(&fx, &fy, &ow, &oh);
					select_all_nodes_in_rect(c, fx, fy, ow, oh);
				}
				result=1;
			}
			break;
		default:
			if(dragging)
				result=1;
			break;
	}
	return(result);
}
