#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

int do_drag_tree(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static tree t;
	static treetypedata td;
	static int cx, cy;
	static int dragging_corner=0;
	static int dragging_tree=0;
	static int notyet;
	static direction corner;
	static tree drag_tree;
	static int dx, dy, dw, dh, offx, offy;
	static int newx, newy;
	static int minw, minh, maxw, maxh;
	static int result;
	static tree lasttree;
	static unsigned long lasttime, thistime;

	result=0;

	if(installing)
	{
		dragging_tree=0;
		dragging_corner=0;
		lasttree=NULL;
		canvas_add_event_function(do_drag_tree, f);
		return(1);
	}
	else if(uninstalling)
	{
		canvas_remove_event_function(do_drag_tree);
		return(1);
	}
	else if(printing) printf("zdragtree\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			if(!dragging_corner && !dragging_tree)
			{
				if((t=(tree)which_corner(c, x, y, &corner))!=NULL)
				{
					double sx, sy, bx, by;

					select_by_state(SubtreeSel, treeroot(t), 0.0, e);
					if(ndta(treeroot(t))->selected)
					{
						dragging_corner=1;
						notyet=1;
						install_dragging_function(do_drag_tree);
						drag_tree=t;
						td=tdta(t)->td;
						dx=td->x;
						dy=td->y;
						dw=td->w;
						dh=td->h;
						get_corner(dx, dy, dw, dh, corner, &cx, &cy);
						offx=x-cx;
						offy=y-cy;
						canvas_no_clipping();
						drag_rectangle(c, dx, dy, dw, dh);
						tree_get_minmax_size(t, NoTreeType, &sx, &sy, &bx, &by);
						minw=sx;
						minh=sy;
						maxw=bx;
						maxh=by;
						if(globals->autoformat && tdta(t)->type==Boxed)
							maxh=minh=td->h;
					}
					result=1;
				}
				else if((t=(tree)which_tree(c, x, y))!=NULL)
				{
					thistime=tevent_time(e);
					if(lasttree==t && thistime-lasttime<DBLCLICK)
					{
						show_tree_info_frame();
						lasttree=NULL;
						result=1;
					}
					else
					{
						lasttime=thistime;
						lasttree=t;

						select_by_state(SubtreeSel, treeroot(t), 0.0, e);
						if(ndta(treeroot(t))->selected)
						{
							dragging_tree=1;
							notyet=1;
							install_dragging_function(do_drag_tree);
							drag_tree=t;
							td=tdta(t)->td;
							dx=td->x;
							dy=td->y;
							dw=td->w;
							dh=td->h;
							offx=x-dx;
							offy=y-dy;
							canvas_no_clipping();
							drag_rectangle(c, dx, dy, dw, dh);
						}
						result=1;
					}
				}
			}
			else
				result=1;
			break;
		case te_drag:
			if(dragging_tree)
			{
				drag_rectangle(c, dx, dy, dw, dh);
				newx=x-offx;
				newy=y-offy;
				if(notyet)
				{
					if(abs(newx-dx)>5 || abs(newy-dy)>5)
						notyet=0;
				}
				if(!notyet)
				{
					dx=newx;
					dy=newy;
				}
				drag_rectangle(c, dx, dy, dw, dh);
				result=1;
			}
			else if(dragging_corner)
			{
				drag_rectangle(c, dx, dy, dw, dh);
				newx=x-offx;
				newy=y-offy;
				if(notyet)
				{
					get_corner(dx, dy, dw, dh, corner, &cx, &cy);
					if(abs(newx-cx)>5 || abs(newy-cy)>5)
						notyet=0;
				}
				if(!notyet)
				{
					set_corner(&dx, &dy, &dw, &dh, corner, newx, newy);
					constrain_rect_min(&dx, &dy, &dw, &dh,
						minw, minh, corner);
					constrain_rect_max(&dx, &dy, &dw, &dh,
						maxw, maxh, corner);
				}
				drag_rectangle(c, dx, dy, dw, dh);
				result=1;
			}
			break;
		case te_mouseup:
			if(dragging_tree)
			{
				dragging_tree=0;
				uninstall_dragging_function(do_drag_tree);
				drag_rectangle(c, dx, dy, dw, dh);
				newx=x-offx;
				newy=y-offy;
				if(notyet)
				{
					if(abs(newx-dx)>5 || abs(newy-dy)>5)
						notyet=0;
				}
				if(!notyet)
				{
					dx=newx;
					dy=newy;
					td=tdta(drag_tree)->td;
					offx=dx-td->x;
					offy=dy-td->y;
					do_command(EveryTree, NULL, NULL, 0.0, 0.0, offx, offy,
						0, 0, MoveTree);
				}
				result=1;
			}
			else if(dragging_corner)
			{
				dragging_corner=0;
				uninstall_dragging_function(do_drag_tree);
				drag_rectangle(c, dx, dy, dw, dh);
				newx=x-offx;
				newy=y-offy;
				if(notyet)
				{
					get_corner(dx, dy, dw, dh, corner, &cx, &cy);
					if(abs(newx-cx)>5 || abs(newy-cy)>5)
						notyet=0;
				}
				if(!notyet)
				{
					set_corner(&dx, &dy, &dw, &dh, corner, newx, newy);
					constrain_rect_min(&dx, &dy, &dw, &dh,
						minw, minh, corner);
					constrain_rect_max(&dx, &dy, &dw, &dh,
						maxw, maxh, corner);
					td=tdta(drag_tree)->td;
					do_command(ResizeTree, drag_tree, NULL, 0.0, 0.0,
						dx, dy, dw, dh, 0);
				}
				result=1;
			}
			break;
		default:
			if(dragging_tree || dragging_corner)
				result=1;
			break;
	}
	return(result);
}
