/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLFunc;
import gnu.gleem.HitPoint;
import gnu.gleem.Manip;
import gnu.gleem.ManipPart;
import gnu.gleem.ManipPartTwoWayArrow;
import gnu.gleem.linalg.Line;
import gnu.gleem.linalg.Mat4f;
import gnu.gleem.linalg.MathUtil;
import gnu.gleem.linalg.Vec3f;
import java.util.List;

public class Translate1Manip
extends Manip {
    private ManipPart parts = new ManipPartTwoWayArrow();
    private Vec3f translation = new Vec3f(0.0f, 0.0f, 0.0f);
    private Vec3f axis = new Vec3f(1.0f, 0.0f, 0.0f);
    private Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Mat4f xform = new Mat4f();
    private Line dragLine = new Line();
    private Vec3f dragOffset = new Vec3f();

    public Translate1Manip() {
        this.recalc();
    }

    public void setTranslation(Vec3f translation) {
        this.translation.set(translation);
        this.recalc();
    }

    public Vec3f getTranslation() {
        return new Vec3f(this.translation);
    }

    public void setAxis(Vec3f axis) {
        this.axis.set(axis);
        this.recalc();
    }

    public Vec3f getAxis() {
        return new Vec3f(this.axis);
    }

    public void setScale(Vec3f scale) {
        this.scale.set(scale);
        this.recalc();
    }

    public Vec3f getScale() {
        return new Vec3f(this.scale);
    }

    public void replaceGeometry(ManipPart geom) {
        this.parts = geom;
    }

    public void intersectRay(Vec3f rayStart, Vec3f rayDirection, List results) {
        this.parts.intersectRay(rayStart, rayDirection, results, this);
    }

    public void highlight(HitPoint hit) {
        if (hit.manipPart != this.parts) {
            throw new RuntimeException("My old geometry disappeared; how did this happen?");
        }
        this.parts.highlight();
    }

    public void clearHighlight() {
        this.parts.clearHighlight();
    }

    public void makeActive(HitPoint hit) {
        this.parts.highlight();
        this.dragLine.setDirection(this.axis);
        this.dragLine.setPoint(hit.intPt.getIntersectionPoint());
        this.dragOffset.sub(this.translation, hit.intPt.getIntersectionPoint());
    }

    public void drag(Vec3f rayStart, Vec3f rayDirection) {
        Vec3f closestPoint = new Vec3f();
        if (!this.dragLine.closestPointToRay(rayStart, rayDirection, closestPoint)) {
            return;
        }
        this.translation.set(closestPoint);
        this.translation.add(this.dragOffset);
        this.recalc();
        super.drag(rayStart, rayDirection);
    }

    public void makeInactive() {
        this.parts.clearHighlight();
    }

    public void render(GLFunc gl) {
        this.parts.render(gl);
    }

    private void recalc() {
        Mat4f scaleMat = new Mat4f();
        Mat4f rotMat = new Mat4f();
        Mat4f xlateMat = new Mat4f();
        Mat4f tmpMat = new Mat4f();
        scaleMat.makeIdent();
        scaleMat.set(0, 0, this.scale.x());
        scaleMat.set(1, 1, this.scale.y());
        scaleMat.set(2, 2, this.scale.z());
        Vec3f p0 = new Vec3f();
        Vec3f p1 = new Vec3f();
        MathUtil.makePerpendicular(this.axis, p0);
        p1.cross(this.axis, p0);
        p0.normalize();
        p1.normalize();
        rotMat.makeIdent();
        rotMat.set(0, 0, this.axis.x());
        rotMat.set(1, 0, this.axis.y());
        rotMat.set(2, 0, this.axis.z());
        rotMat.set(0, 1, p0.x());
        rotMat.set(1, 1, p0.y());
        rotMat.set(2, 1, p0.z());
        rotMat.set(0, 2, p1.x());
        rotMat.set(1, 2, p1.y());
        rotMat.set(2, 2, p1.z());
        xlateMat.makeIdent();
        xlateMat.set(0, 3, this.translation.x());
        xlateMat.set(1, 3, this.translation.y());
        xlateMat.set(2, 3, this.translation.z());
        tmpMat.mul(xlateMat, rotMat);
        this.xform.mul(tmpMat, scaleMat);
        this.parts.setTransform(this.xform);
    }
}

