# GNU Enterprise Common Library - PostgreSQL database driver using psycopg
#
# Copyright 2000-2007 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: psycopg2drv.py 9222 2007-01-08 13:02:49Z johannes $

"""
Database driver plugin for PostgreSQL backends using the psycopg2 DBSIG2 module.
"""

__all__ = ['Connection']

__pluginalias__ = ['psycopg2']

from gnue.common.datasources.drivers.sql.postgresql import Base


# =============================================================================
# Test if plugin is functional
# =============================================================================

def __initplugin__ ():
  from gnue.common.datasources import GConnections
  try:
    import psycopg2
  except:
    raise GConnections.DependencyError, ('psycopg2', None)


# =============================================================================
# Driver info
# =============================================================================

class DriverInfo:

  name = "psycopg2"

  url = "http://initd.org/projects/psycopg2"

  doc = """
Description
-----------
From the Psycopg2 website:
psycopg 2 is an almost complete rewrite of psycopg. It still supports all the
features of psycopg but add real adaptation for Python to PostgreSQL type
conversions, asynchronous queries, support for the Python built-in datetime
module and the new (Python 2.4) Decimal type.

psycopg 2 is now the stable branch (psycopg 1 support has been discontinued.)

Written by initd.org volunteers.

Support
-------
Supported Platforms:

  - Linux/BSD
  - MS Windows 98/NT/2000/XP (Installer available)

Connection Properties
---------------------
* dbname -- database name (required)
* host  -- host address (defaults to UNIX socket if not provided) (optional)
* port -- port number (defaults to 5432 if not provided) (optional)
* use_oid -- if set to any value, the driver uses Postgres' OID field as an
    implicit primary key for all tables. OID fields were generated by default
    for all tables for Postgres 7.x and are not generated by default for
    Postgres 8.x.

Examples
--------
  [myconn]
  provider=psycopg2       # Use the psycopg2 adapter
  host=localhost          # The hostname/IP of the postgresql host
  dbname=mydb             # The name of the pg database

Notes
-----
1. Available in Debian as: "apt-get install python-psycopg2".

2. Windows installer available at: http://www.stickpeople.com/projects/python/win-psycopg/index.html.
"""


# =============================================================================
# Connection class
# =============================================================================

class Connection (Base.Connection):
  """
  Connection class for PostgreSQL backends using the psycopg2 DBISG2 module.
  """

  _drivername_ = 'psycopg2'
  _need_rollback_after_exception_ = True
