# GNU Enterprise Forms - QT 3 UI driver - Menu
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: menu.py 9956 2009-10-11 18:54:57Z reinhard $

import qt

from gnue.forms.uidrivers.qt3.widgets._base import UIHelper

# =============================================================================
# Wrap an UI layer around a menu
# =============================================================================

class UIMenu(UIHelper):
    """
    Implements a menu object.
    """

    # -------------------------------------------------------------------------
    # Create a new menu widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Create a menu widget
        """

        if self._gfObject.name == '__main_menu__' \
                and not self._form._features['GUI:MENUBAR:SUPPRESS']:
            # Only access the menu bar for main forms
            if isinstance(self._uiForm.main_window, qt.QMainWindow):
                widget = self._uiForm.main_window.menuBar()
            else:
                widget = None

        else:
            widget = qt.QPopupMenu(event.container)
            if isinstance(event.container, (qt.QPopupMenu, qt.QMenuBar)):
                event.container.insertItem(self._gfObject.label, widget)

        self._container = widget
        return widget


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
   'baseClass': UIMenu,
   'provides' : 'GFMenu',
   'container': 1,
}

