# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: GFwin32App.py 9956 2009-10-11 18:54:57Z reinhard $


import win32gui

__all__ = ['get_win32_app']

__win32app = None


def get_win32_app():
    """
    Get the global win32 application instance
    """
    global __win32app
    if not __win32app:
        __win32app = GFwin32App()
    return __win32app


class GFwin32App:
    """
    The win32 application object used in gnue-forms and gnue-navigator
    """
    _main_loop = None

    _HwndToTkObj = {}
    _MainWindowList = []

    def main_loop (self):
        """
        Launch win32's mainloop
        """
        if self._main_loop is None:
        # just to launch one win32's mainloop
            self._main_loop = 1
            win32gui.PumpMessages()
