# GNU Enterprise Forms - wx 2.6 UI Driver - Menu widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: menu.py 9956 2009-10-11 18:54:57Z reinhard $

import wx

from gnue.forms.uidrivers.wx26.widgets._base import UIHelper


# =============================================================================
# Wrap an UI layer around a wxMenu widget
# =============================================================================

class UIMenu(UIHelper):
    """
    Implements a menu object.
    """

    # -------------------------------------------------------------------------
    # Create a menu widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new Menu widget.
        """

        if self._gfObject.name == '__main_menu__' \
                and not self._form._features['GUI:MENUBAR:SUPPRESS']:
            # Menu bar of the form
            widget = wx.MenuBar()

            # We do not set the menubar using main_window.SetMenuBar() here,
            # because on OS X some menu items will get rearranged (like Quit,
            # About, Help-menu ...).  This rearrangement won't work if the
            # menubar is set before the items are created.
            if isinstance(self._uiForm.main_window, wx.Frame):
                self._uiForm._menubar_ = widget
        else:
            # Submenu or popup menu
            widget = wx.Menu()

            # On OS X the 'Help' and 'Window' menus will be added automatically
            # to the menubar.  To avoid having two 'Help' menus we have to name
            # the help-menu '&Help'.  This will be translated to the current
            # language automatically then.
            if self._gfObject.name == '__help__' and 'wxMac' in wx.PlatformInfo:
                lb = '&Help'
            else:
                lb = self._gfObject.label

            if isinstance(event.container, wx.Menu):
                event.container.AppendMenu(wx.ID_ANY, lb, widget)

            elif isinstance(event.container, wx.MenuBar):
                event.container.Append(widget, lb)

        self._container = widget

        return widget


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIMenu,
  'provides' : 'GFMenu',
  'container': 1,
}
