#
#   application.make
#
#   Makefile rules to build GNUstep-based applications.
#
#   Copyright (C) 1997 Free Software Foundation, Inc.
#
#   Author:  Ovidiu Predescu <ovidiu@net-community.com>
#   Based on the original version by Scott Christley.
#
#   This file is part of the GNUstep Makefile Package.
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
#   
#   You should have received a copy of the GNU General Public
#   License along with this library; see the file COPYING.LIB.
#   If not, write to the Free Software Foundation,
#   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# prevent multiple inclusions
ifeq ($(APPLICATION_MAKE_LOADED),)
APPLICATION_MAKE_LOADED=yes

#
# Include in the common makefile rules
#
include $(GNUSTEP_MAKEFILES)/rules.make

#
# The name of the application is in the APP_NAME variable.
# The list of application resource directories is in xxx_RESOURCE_DIRS
# The list of application resource files is in xxx_RESOURCE_FILES
# The list of localized resource files is in xxx_LOCALIZED_RESOURCE_FILES
# The list of supported languages is in xxx_LANGUAGES
# The name of the application icon (if any) is in xxx_APPLICATION_ICON
# The name of the app class is xxx_PRINCIPAL_CLASS (defaults to NSApplication).
# The name of a file containing info.plist entries to be inserted into
# Info-gnustep.plist (if any) is xxxInfo.plist
# where xxx is the application name
#

APP_NAME:=$(strip $(APP_NAME))

# Determine the application directory extension
ifeq ($(profile), yes)
  APP_EXTENSION = profile
else
  ifeq ($(debug), yes)
    APP_EXTENSION=debug
  else
    APP_EXTENSION=app
  endif
endif

ifeq ($(INTERNAL_app_NAME),)
# This part gets included by the first invoked make process.
internal-all:: $(APP_NAME:=.all.app.variables)

internal-install:: $(APP_NAME:=.install.app.variables)

internal-uninstall:: $(APP_NAME:=.uninstall.app.variables)

internal-clean:: $(APP_NAME:=.clean.app.variables)

internal-distclean:: $(APP_NAME:=.distclean.app.variables)

$(APP_NAME):
	@$(MAKE) -f $(MAKEFILE_NAME) --no-print-directory $@.all.app.variables

else

# Libraries that go before the GUI libraries
ALL_GUI_LIBS = $(ADDITIONAL_GUI_LIBS) $(AUXILIARY_GUI_LIBS) $(GUI_LIBS) \
   $(BACKEND_LIBS) $(ADDITIONAL_TOOL_LIBS) $(AUXILIARY_TOOL_LIBS) \
   $(FND_LIBS) $(ADDITIONAL_OBJC_LIBS) $(AUXILIARY_OBJC_LIBS) $(OBJC_LIBS) \
   $(SYSTEM_LIBS) $(TARGET_SYSTEM_LIBS)

ALL_GUI_LIBS := \
    $(shell $(WHICH_LIB_SCRIPT) $(LIB_DIRS_NO_SYSTEM) $(ALL_GUI_LIBS) \
	debug=$(debug) profile=$(profile) shared=$(shared) libext=$(LIBEXT) \
	shared_libext=$(SHARED_LIBEXT))


# Don't include these definitions the first time make is invoked. This part is
# included when make is invoked the second time from the %.build rule (see
# rules.make).
APP_DIR_NAME = $(INTERNAL_app_NAME:=.$(APP_EXTENSION))
APP_RESOURCE_DIRS =  $(foreach d, $(RESOURCE_DIRS), $(APP_DIR_NAME)/Resources/$(d))
ifeq ($(strip $(RESOURCE_FILES)),)
  override RESOURCE_FILES=""
endif
ifeq ($(strip $(LOCALIZED_RESOURCE_FILES)),)
  override LOCALIZED_RESOURCE_FILES=""
endif
ifeq ($(strip $(LANGUAGES)),)
  override LANGUAGES="English"
endif

# Support building NeXT applications
ifneq ($(OBJC_COMPILER), NeXT)
APP_FILE = \
    $(APP_DIR_NAME)/$(GNUSTEP_TARGET_DIR)/$(LIBRARY_COMBO)/$(INTERNAL_app_NAME)$(EXEEXT)
else
APP_FILE = $(APP_DIR_NAME)/$(INTERNAL_app_NAME)$(EXEEXT)
endif

#
# Internal targets
#

$(APP_FILE): $(C_OBJ_FILES) $(OBJC_OBJ_FILES) $(SUBPROJECT_OBJ_FILES)
	$(LD) $(ALL_LDFLAGS) -o $(LDOUT)$@ $(C_OBJ_FILES) $(OBJC_OBJ_FILES) \
		$(SUBPROJECT_OBJ_FILES) \
		$(ALL_LIB_DIRS) $(ALL_GUI_LIBS)
ifeq ($(OBJC_COMPILER), NeXT)
	@$(TRANSFORM_PATHS_SCRIPT) `echo $(ALL_LIB_DIRS) | sed 's/-L//g'` \
		>$(APP_DIR_NAME)/library_paths.openapp
# This is a hack for OPENSTEP systems to remove the iconheader file
# automatically generated by the makefile package.
	rm -f $(INTERNAL_app_NAME).iconheader
else
	@$(TRANSFORM_PATHS_SCRIPT) `echo $(ALL_LIB_DIRS) | sed 's/-L//g'` \
	>$(APP_DIR_NAME)/$(GNUSTEP_TARGET_CPU)/$(GNUSTEP_TARGET_OS)/$(LIBRARY_COMBO)/library_paths.openapp
endif

#
# Compilation targets
#
ifeq ($(OBJC_COMPILER), NeXT)
internal-app-all:: before-$(TARGET)-all $(INTERNAL_app_NAME).iconheader \
	$(GNUSTEP_OBJ_DIR) $(APP_DIR_NAME) $(APP_FILE) app-resource-files \
	after-$(TARGET)-all

before-$(TARGET)-all::

after-$(TARGET)-all::

$(INTERNAL_app_NAME).iconheader:
	@(echo "F	$(INTERNAL_app_NAME).$(APP_EXTENSION)	$(INTERNAL_app_NAME)	$(APP_EXTENSION)"; \
	  echo "F	$(INTERNAL_app_NAME)	$(INTERNAL_app_NAME)	app") >$@

$(APP_DIR_NAME):
	mkdir $@

else

internal-app-all:: before-$(TARGET)-all $(GNUSTEP_OBJ_DIR) \
   $(APP_DIR_NAME)/$(GNUSTEP_TARGET_DIR)/$(LIBRARY_COMBO) $(APP_FILE) \
   $(APP_DIR_NAME)/$(INTERNAL_app_NAME) app-resource-files \
   app-localized-resource-files after-$(TARGET)-all

before-$(TARGET)-all::

after-$(TARGET)-all::

$(APP_DIR_NAME)/$(GNUSTEP_TARGET_DIR)/$(LIBRARY_COMBO):
	@$(MKDIRS) $(APP_DIR_NAME)/$(GNUSTEP_TARGET_DIR)/$(LIBRARY_COMBO)

$(APP_DIR_NAME)/$(INTERNAL_app_NAME):
	cp $(GNUSTEP_MAKEFILES)/executable.template $(APP_DIR_NAME)/$(INTERNAL_app_NAME)
	chmod a+x $(APP_DIR_NAME)/$(INTERNAL_app_NAME)
endif

app-resource-dir::
	@$(MKDIRS) $(APP_RESOURCE_DIRS)

app-resource-files:: $(APP_DIR_NAME)/Resources/Info-gnustep.plist app-resource-dir
	@(if [ "$(RESOURCE_FILES)" != "" ]; then \
	  echo "Copying resources into the application wrapper..."; \
	  cp -r $(RESOURCE_FILES) $(APP_DIR_NAME)/Resources; \
	fi)

app-localized-resource-files:: $(APP_DIR_NAME)/Resources/Info-gnustep.plist app-resource-dir
	@(if [ "$(LOCALIZED_RESOURCE_FILES)" != "" ]; then \
	  echo "Copying localized resources into the application wrapper..."; \
	  for l in $(LANGUAGES); do \
	    if [ ! -f $$l.lproj ]; then \
	      $(MKDIRS) $(APP_DIR_NAME)/Resources/$$l.lproj; \
	    fi; \
	    for f in $(LOCALIZED_RESOURCE_FILES); do \
	      if [ -f $$l.lproj/$$f ]; then \
	        cp -r $$l.lproj/$$f $(APP_DIR_NAME)/Resources/$$l.lproj; \
	      fi; \
	    done; \
	  done; \
	fi)
	

ifeq ($(PRINCIPAL_CLASS),)
override PRINCIPAL_CLASS = NSApplication
endif

$(APP_DIR_NAME)/Resources/Info-gnustep.plist: $(APP_DIR_NAME)/Resources _FORCE
	@(echo "{"; echo '  NOTE = "Automatically generated, do not edit!";'; \
	  echo "  NSExecutable = \"$(INTERNAL_app_NAME)\";"; \
	  if [ "$(MAIN_MODEL_FILE)" = "" ]; then \
	    echo "  NSMainNibFile = \"\";"; \
	  else \
	    echo "  NSMainNibFile = \"`echo $(MAIN_MODEL_FILE) | sed -e 's/.gmodel//' -e 's/.gorm//' -e 's/.nib//'`\";"; \
	  fi; \
	  if [ "$(APPLICATION_ICON)" != "" ]; then \
	    echo "  NSIcon = \"$(APPLICATION_ICON)\";"; \
	  fi; \
	  echo "  NSPrincipalClass = \"$(PRINCIPAL_CLASS)\";"; \
	  echo "}") >$@
	  @(if [ -r "$(INTERNAL_app_NAME)Info.plist" ]; then \
	    plmerge $@ $(INTERNAL_app_NAME)Info.plist; \
	  fi)

$(APP_DIR_NAME)/Resources:
	@$(MKDIRS) $@

_FORCE::

internal-app-install:: internal-app-all internal-install-dirs
	rm -rf $(GNUSTEP_APPS)/$(APP_DIR_NAME)
	$(TAR) cf - $(APP_DIR_NAME) | (cd $(GNUSTEP_APPS); $(TAR) xf -)

internal-install-dirs::
	$(MKDIRS) $(GNUSTEP_APPS)

internal-app-uninstall::
	(cd $(GNUSTEP_APPS); rm -rf $(APP_DIR_NAME))

#
# Cleaning targets
#
internal-app-clean::
	rm -rf $(GNUSTEP_OBJ_PREFIX)/$(GNUSTEP_TARGET_CPU)/$(GNUSTEP_TARGET_OS)/$(LIBRARY_COMBO)
ifeq ($(OBJC_COMPILER), NeXT)
	rm -f *.iconheader
	for f in *.$(APP_EXTENSION); do \
	  rm -f $$f/`basename $$f .$(APP_EXTENSION)`; \
	done
else
	rm -rf *.$(APP_EXTENSION)/$(GNUSTEP_TARGET_CPU)/$(GNUSTEP_TARGET_OS)/$(LIBRARY_COMBO)
endif


internal-app-distclean::
	rm -rf shared_obj static_obj shared_debug_obj shared_profile_obj \
	  static_debug_obj static_profile_obj shared_profile_debug_obj \
	  static_profile_debug_obj *.app *.debug *.profile *.iconheader

endif

endif
# application.make loaded

## Local variables:
## mode: makefile
## End:
