// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "bayonne.h"
#include <iomanip>

class TestDebug : public Debug
{
private:
	bool script;
	int test;
	int success;

public:
	TestDebug();
	void DebugService(Trunk *trunk, char *msg);
	void DebugState(Trunk *trunk, char *state);
	void DebugScript(Trunk *trunk, char *msg);
	void DebugStep(Trunk *trunk, scriptline_t *line);
	bool DebugTest(void);
} testdebug;

TestDebug::TestDebug() :
Debug()
{
	success = 0;
	test = 0;
	slog(SLOG_INFO) << "debug: test module loaded" << endl;
}

bool TestDebug::DebugTest(void)
{
	TrunkEvent event;
	Trunk *trunk = driver->getTrunkPort(0);

	if(!trunk)
	{
		slog(SLOG_ERROR) << "debug: trunk 0 not available for tests" << endl;
		return true;
	}
	slog(SLOG_INFO) << "debug: *** start of regression test series" << endl;
	ccxx_sleep(1000);
	event.id = TRUNK_MAKE_IDLE;
	trunk->postEvent(&event);
	ccxx_sleep(1000);

	slog(SLOG_INFO) << "debug: *** start of cdr test" << endl;
	++test;
	script = false;
	keyserver.setValue("default", "test1");
	event.parm.ring.digit = 0;
	event.id = TRUNK_RINGING_ON;
	trunk->postEvent(&event);
	ccxx_sleep(250);
	event.id = TRUNK_RINGING_OFF;
	trunk->postEvent(&event);
	ccxx_sleep(2000);
	if(script)
	{
		++success;
		slog(SLOG_INFO) << "debug: *** test cdr successful" << endl;
	}
	else
		slog(SLOG_INFO) << "debug: *** test cde failed" << endl;

	slog(SLOG_INFO) << "debug: *** start of state handler test" << endl;
	++test;
	script = false;
	keyserver.setValue("default", "test2");
	event.parm.ring.digit = 0;
	event.id = TRUNK_RINGING_ON;
	trunk->postEvent(&event);
	ccxx_sleep(250);
	event.id = TRUNK_RINGING_OFF;
	trunk->postEvent(&event);
	ccxx_sleep(4000);
	if(script)
	{
		++success;
		slog(SLOG_INFO) << "debug: *** test state successful" << endl;
	}
	else
		slog(SLOG_INFO) << "debug: *** test state failed" << endl;

	slog(SLOG_INFO) << "debug: *** start of trap test" << endl;
	++test;
	script = false;
	keyserver.setValue("default", "test3");
	event.parm.ring.digit = 0;
	event.id = TRUNK_RINGING_ON;
	trunk->postEvent(&event);
	event.id = TRUNK_RINGING_OFF;
	trunk->postEvent(&event);
	ccxx_sleep(500);
	event.id = TRUNK_DTMF_KEYUP;
	event.parm.dtmf.digit = 1;
	trunk->postEvent(&event);
	ccxx_sleep(1000);
	if(script)
	{
		++success;
		slog(SLOG_INFO) << "debug: *** test trap successful" << endl;
	}
	else
		slog(SLOG_INFO) << "debug: *** test trap failed" << endl;

	// we cannot self test tgi thu here yet since we block
	// the main thread until after we return, and hence it can
	// never process requests.

	// slog(SLOG_INFO) << "debug: *** start of test tgi" << endl;
	// ++test;
	// script = false;
	// keyserver.setValue("default", "test4");
	// event.parm.ring.digit = 0;
	// event.id = TRUNK_RINGING_ON;
	// trunk->postEvent(&event);
	// event.id = TRUNK_RINGING_OFF;
	// trunk->postEvent(&event);
	// ccxx_sleep(4000);
	// if(script)
	// {
	//	++success;
	//	slog(SLOG_INFO) << "debug: *** test tgi successful" << endl;
	// }
	// else
	//	slog(SLOG_INFO) << "debug: *** test tgi failed" << endl;

	ccxx_sleep(2000);
	slog(SLOG_INFO) << "debug: *** test series completed ";
	slog() << success << " of " << test << " successful" << endl;
	return true;
}

void TestDebug::DebugService(Trunk *trunk, char *msg)
{
	char buffer[32];
	if(test > 1)
		return;

	EnterMutex();
	if(trunk)
	{
		trunk->getName(buffer);
		slog(SLOG_DEBUG) << "debug: " << buffer << ": ";
	}
	else
		slog(SLOG_DEBUG) << "debug: ";
	slog() << "service " << msg << endl;
	LeaveMutex();
}

void TestDebug::DebugScript(Trunk *trunk, char *msg)
{
	char buffer[32];
	char *value;

	script = true;
	EnterMutex();
	script = true;
	trunk->getName(buffer);
	slog(SLOG_DEBUG) << buffer << ": " << msg << endl;
	LeaveMutex();
}

void TestDebug::DebugStep(Trunk *trunk, scriptline_t *line)
{
	int i;

	char buffer[32];
	trunk->getName(buffer);

	if(!line)
	{
		slog(SLOG_DEBUG) << buffer << ": exit" << endl;
		return;
	}

	EnterMutex();
	slog(SLOG_DEBUG) << buffer << ": step ";
	slog() << setbase(16) << line->mask << " " << setbase(10);
	slog() << line->cmd << "(";
	for(i = 0; i < line->argc; ++i)
	{
		if(i)
			slog() << ",";
		slog() << line->args[i];
	}
	slog() << ")" << endl;	
	LeaveMutex();
}

void TestDebug::DebugState(Trunk *trunk, char *state)
{
	char buffer[32];
	trunk->getName(buffer);

	EnterMutex();
	slog(SLOG_DEBUG) << buffer << ": " << state << endl;
	LeaveMutex();
}

