// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "driver.h"

ConfigDriver::ConfigDriver() :
Keydata("/bayonne/phone")
{
	static KEYDEF defkeys[] = {
	{"devices", "16"},
	{"wink", "100"},
	{"buffers", "1"},
	{NULL, NULL}};

	Load(defkeys);
}

IVRDriver::IVRDriver() :
Driver()
{
	port_count = getDevices();
	status = TrunkDriver::status;
	memset(TrunkDriver::status, ' ', sizeof(TrunkDriver::status));
	ports = new TrunkDriver *[port_count];
	groups = new TrunkGroup *[port_count];
	memset(ports, 0, sizeof(TrunkDriver *) * port_count);
	memset(groups, 0, sizeof(TrunkGroup *) * port_count);

	thread_count = thread_select = 0;
	
	slog(SLOG_INFO) << "Generic Phone Device (phonedev) driver loaded; capacity=" << port_count << endl;
}

IVRDriver::~IVRDriver()
{
	Stop();
	delete ports;
	delete groups;
}

int IVRDriver::Start(void)
{
	char path[32];
	int fd, ts;
	int count = 0;
	int scount = keythreads.getServices();

	if(active)
	{
		slog(SLOG_ERROR) << "driver already started" << endl;
		return 0;
	}

	slog(SLOG_INFO) << "driver starting " << scount << " service thread(s)" << endl;
	threads = new ServiceDriver[scount];

	for(ts = 0; ts < port_count; ++ts)
	{
		sprintf(path, "/dev/phone%d", ts);
		fd = open(path, O_RDWR);
		if(fd < 0)
			continue;
		if(!getuid())
			fchown(fd, keyserver.getUid(), keyserver.getGid());
		ports[ts] = new TrunkDriver(fd, ts);
		++count;
	}

	active = true;
	return count;
}

void IVRDriver::Stop(void)
{
	int id;
	if(!active)
		return;

	if(ports)
	{
		for(id = 0; id < port_count; ++id)
		{
			if(ports[id])
				delete ports[id];
		}
	}
	memset(ports, 0, sizeof(TrunkDriver *) * port_count);
	delete[] threads;
	
	active = false;
	slog(SLOG_INFO) << "driver stopping service thread(s)" << endl;
}

Trunk *IVRDriver::getTrunkPort(int id)
{
	if(id < 0 || id >= port_count)
		return NULL;

	return (Trunk *)ports[id];
}

ServiceDriver *IVRDriver::getService(void)
{
	ServiceDriver *svc = &threads[thread_select++];
	if(thread_select >= thread_count)
		thread_select = 0;
	return svc;
}

void IVRDriver::Notify(unsigned char id)
{
	TrunkEvent event;
	TrunkDriver *trunk;

	if(id < 1 || id > port_count)
		return;

	trunk = ports[--id];
	if(!trunk)
		return;

	event.id = TRUNK_NOTIFICATION;
	trunk->postEvent(&event);
}

IVRDriver ivr;
