// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "server.h"

Server *Server::first = NULL;
Audit *Audit::first = NULL;
Auditdata Audit::keys;
Translator *Translator::first = NULL;
Sync *Sync::first = NULL;

Auditdata::Auditdata()
{
	Load("/bayonne/audit");
	Load("~bayonne/audit");
}

Audit::Audit() :
Mutex()
{
	next = first;
	first = this;
}

Driver::Driver() :
aaScript()
{
	active = false;
	if(driver)
		throw(this);

	groups = NULL;
	driver = this;
	status = NULL;
}

aaImage *Driver::getImage(void)
{
	return new aaImage((aaScript *)this);
}

void Driver::getStatus(char *buffer)
{
	if(!status)
		return;

	memcpy(buffer, status, getTrunkCount());
}

void Functions::Load(FUNCTIONS *map)
{
	int count = 0;
	while(map->name)
	{
		driver->addFunction(map->name, map->function);
		++map;
		++count;
	}
	slog(SLOG_DEBUG) << getName() << ": loaded " << count << " functions" << endl;
}

void audit(char *detail)
{
	Audit *au = Audit::first;

	while(au)
	{
		au->Report(detail);
		au = au->next;
	}
}

Debug::Debug() :
Mutex()
{
	if(debug)
		throw this;

	debug = this;
}

Translator::Translator(const char *conf, const char *lib) :
Keydata(conf)
{
	char keypath[33];
	next = first;
	first = this;

	if(lib)
		Load(lib);

	slog(SLOG_DEBUG) << "loaded lib" << endl;
	if(isDir("/etc/bayonne.d"))
		if(canAccess("/etc/bayonne.d"))
			scanDir(conf, lib);

	strcpy(keypath, conf);
	*keypath = '~';
	Load(keypath);

	if(!lib)
		return;

	strcpy(keypath, lib);
	*keypath = '~';
	Load(keypath);
}

void Translator::scanDir(const char *lang, const char *lib)
{
	char buffer[65];
	char *name, *ext;
	Dir dir("/etc/bayonne.d");
	if(*lang == '/')
		lang = strrchr(lang, '/');

	if(lib)
		if(*lib == '/')
			lib = strrchr(lib, '/');

	while(NULL != (name = dir.getName()))
	{
		ext = strrchr(name, '.');
		if(!ext)
			continue;

		if(strcmp(ext, ".conf"))
			continue;

		strcpy(buffer, "/bayonne.d/");
		*ext = 0;
		strcat(buffer, name);
		strcat(buffer, lang);
		Load(buffer);
		if(!lib)
			continue;
		strcpy(buffer, "/bayonne.d/");
		strcat(buffer, name);
		strcat(buffer, "lib");
		Load(buffer);
	}
}

char *Translator::getPlayBuffer(Trunk *trunk)
{
	char *pbuf;
	
	pbuf = trunk->data.play.list;
	trunk->data.play.name = pbuf;
	trunk->data.play.limit = trunk->data.play.offset = 0;
	*pbuf = 0;
	return pbuf;
}

Translator *getTranslator(char *name)
{
	Translator *trans = Translator::first;

	while(trans)
	{
		if(!stricmp(name, trans->getName()))
			return trans;
		trans = trans->next;
	}
	return NULL;
}

Sync::Sync()
{
	next = first;
	first = this;
	time(&runtime);
}

Database::Database()
{
	if(database)
		throw this;

	database = this;
}

Server::Server(int pri) :
Thread(NULL, pri)
{
	next = first;
	first = this;
}

void startServers(void)
{
	Server *server = Server::first;

	while(server)
	{
		server->Start();
		server = server->next;
	}
}

void stopServers(void)
{
	Server *server = Server::first;

	while(server)
	{
		server->Stop();
		server = server->next;
	}
}

PortManager::PortManager(Trunk *trk)
{
	trunk = trk;
	trunk->manager = this;
}

StatMon::StatMon() : 
Keydata("/bayonne/statmon")
{
	if(statmon)
		throw this;
	statmon = this;
	Load("~bayonne/statmon");
}

Debug *debug = NULL;
Driver *driver = NULL;
StatMon *statmon = NULL;
Database *database = NULL;
