/* glpapi/glp_new_coef.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_new_coef - create new constraint coefficient.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_new_coef(double val);
--
-- *Description*
--
-- The glp_new_coef creates new constraint coefficient, which is placed
-- in the current row and in the current column and has the value val.
-- Being created new coefficient becomes the current coefficient.
--
-- The application program needn't specify zero coefficients, because if
-- a coefficient was not specified, it considered as zero.
--
-- *Complexity*
--
-- This operation has time complexity O(1).
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the current row or/and column are undefined. */

int glp_new_coef(double val)
{     GLPCOEF *coef;
      if (glp->this_row == NULL || glp->this_col == NULL) return 1;
      /* create new constraint coefficient */
      coef = get_atom(glp->coef_pool);
      coef->row = glp->this_row;
      coef->col = glp->this_col;
      coef->val = val;
      coef->next1 = glp->this_row->ptr, glp->this_row->ptr = coef;
      coef->next2 = glp->this_col->ptr, glp->this_col->ptr = coef;
      /* new coefficient becomes the current coefficient */
      glp->this_coef = coef;
      return 0;
}

/* eof */
