/* glpapi/glp_create_prob.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_create_prob - create problem instance.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- LPI *glp_create_prob(char *name);
--
-- *Description*
--
-- The routine glp_create_prob creates and initializes a new problem
-- instance, which is "empty", i.e. has no rows and no columns.
--
-- The parameter name specifies a symbolic name, which is assigned to
-- the new problem. If this parameter is NULL, no name is assigned.
--
-- *Returns*
--
-- The routine returns a pointer to the created problem instance. */

LPI *glp_create_prob(char *name)
{     LPI *lp;
      lp = umalloc(sizeof(LPI));
      lp->row_pool = create_pool(sizeof(LPIROW));
      lp->col_pool = create_pool(sizeof(LPICOL));
      lp->elem_pool = create_pool(sizeof(ELEM));
      lp->str_pool = create_str_pool();
      lp->check = 0;
      lp->name = NULL;
      lp->m_max = 100;
      lp->n_max = 100;
      lp->m = 0;
      lp->n = 0;
      lp->row = ucalloc(1+lp->m_max, sizeof(LPIROW *));
      lp->col = ucalloc(1+lp->n_max, sizeof(LPICOL *));
      lp->row_tree = create_avl((int (*)(void *, void *))compare_str);
      lp->col_tree = create_avl((int (*)(void *, void *))compare_str);
      lp->c0 = 0.0;
      lp->sense = '-';
      lp->basis = '?';
      lp->status = GLP_UNDEF;
      lp->objval = 0.0;
      /* assign problem name */
      if (name != NULL)
      {  if (glp_check_name(name))
            fault("glp_create_prob: invalid problem name");
         lp->name = create_str(lp->str_pool);
         set_str(lp->name, name);
      }
      return lp;
}

/* eof */
