/*
* (C) 2000 David O'Toole $Date: 2001/03/07 03:18:12 $
*
* MIXER.C
* Flow network analysis, and DSP tasks
* 
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
*
*/
static const char rcsid[]="$Id: mixer.c,v 1.1.1.1 2001/03/07 03:18:12 dto Exp $";

#include "mixer.h"
#include <string.h>
#include <stdio.h>
#include <assert.h>

void (*mx_action_table[])(engine*,int,int) = {mx_execute,
						 mx_add,
						 mx_remix,
						 mx_clear,
						 mx_finish};

char *mx_action_names[] = {"mx_execute", 
							"mx_add",
							"mx_remix", 
							"mx_clear",
							"mx_finish"};


mx_action *mx_create(int opcode, int a, int b)
{
	mx_action* q;

	q = malloc(sizeof(mx_action));
	q->opcode = opcode;
	q->a = a;
	q->b = b;
	q->next = 0;
	return q; 
}


mx_action *mx_destroy(mx_action *head)
{
	mx_action *p, *current;
	
	if (head == 0) return 0;
	for (p = head; p; ) {
		current = p; 
		p = p->next; 
		free(current);
	}

	return NULL;		

}


mx_action* mx_append(mx_action* head, mx_action* q)
{
	mx_action* p; 

	if (head == 0) return q;

	for (p = head; p->next; p = p->next);  /* seek to end */ 
	p->next = q;
     
	return head; /* give back original list */ 
}


int mx_do_action(engine* e, mx_action* q)
{
	int x = sizeof(mx_action_table)/sizeof(mx_action_table[0]);

	if (q->opcode > x) ox_die("Invalid opcode in mixer sequence.");
	mx_action_table[q->opcode] (e, q->a, q->b);
	return 1; 
}

void mx_print_program(mx_action *q) 
{
	char *t;

	printf("\n\n");

	for (; q; q=q->next) {
		t = mx_action_names[q->opcode];
		printf("### %s %d\n", t, q->a);

	}
}





mx_action* mx_compile_digraph(engine* e, int m, mx_action* p) 
{
  int i, inputs = 0; 
  mx_action* ep = p;

	// HANDLE INCOMING SIGNALS
	
	for (i=1; i<e->last_machine; i++) {
		if (e->signals[i][m] == en_nosignal)  /* skip ones without signals */  
			continue; 
  
	// OK, SIGNAL COMING FROM MACHINE I

    ep = mx_compile_digraph(e, i, ep);
    inputs++;
    }

	// NOW MIX THE FILLED MACHINES INTO MIXBUF

	if (inputs) ep = mx_append(ep, mx_create(mxc_clear, 0, 0));

	for (i=1; i<e->last_machine; i++) {
		if (e->signals[i][m] == en_nosignal)
			continue; 
		ep = mx_append(ep, mx_create(mxc_add, i, 0));
	}

  /* remix if needed */
  if (inputs)
    ep = mx_append(ep, mx_create(mxc_remix, 0, 0));


	// EXECUTE

	if (m != master) 
			ep = mx_append(ep, mx_create(mxc_execute, m, 0));
	else ep = mx_append(ep, mx_create(mxc_finish, 0, 0));	

  return ep; 
}



void mx_execute  (engine* e, int a, int b) 
{
	machine *m = e->machines[a];	
	
	assert(a);
	assert(m->frame <= e->frame);

	// check to see whether machine has already been executed in this frame
	if (m->frame == e->frame) return; 
	
	// otherwise, make the machine "catch up" and then generate some sound
	m->frame = e->frame; 

	// someone will have updated the parameters of all machines for thisblock 

	// machine takes input from mix buffer
	
	m->lin = e->lmix;
	m->rin = e->rmix;

	// "generated" doesn't need to be initialized anywhere else, since
	// only mx_add calls will be using it. 

	m->generated = m->type->ox_work(m, e->block_size);	

}

// eventually add an mx_replace just for first buffer coming in
// ... this will prevent the mx_clear from getting called so often

void mx_add  (engine* e, int a, int b) 
{
	// TEMP MONO CODE

	samp *src, *sink;
	int i, j = e->block_size;
	machine *m = e->machines[a];
	
	// if machine didn't generate anything, do nothing

	if (m->generated == 0) return;	

	src = m->lout;
	sink = e->lmix;

	for (i=0; i<j; i++)
		sink[i] += src[i];

	// add output buffer, applying connection amp as needed
	// copy m2s, m2m, and s2s in obvious way
	// stereo inputs require pan value; apply pan
	// copy s2m by using left channel
}

void mx_remix  (engine* e, int a, int b) 
{
	int i; 
	samp *buf = e->lmix;

	for (i=0; i < e->block_size; i++, buf++) {
		if (*buf > OX_RANGE_MAX) *buf = OX_RANGE_MAX;
		else if (*buf < OX_RANGE_MIN) *buf = OX_RANGE_MIN;
	}
}

void mx_clear  (engine* e, int a, int b) 
{
	// TEMP MONO CODE
	
	int i, j = e->block_size;

	for (i=0; i<j; i++) {
		e->lmix[i] = 0.0;
		e->rmix[i] = 0.0;
	}
}

void mx_finish (engine *e, int a, int b)
{
	e->frame++;
}

