/*
* Copyright(c) 2014-2016 Intel Corporation
* All rights reserved.
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* Authors: Shreyas Nc <shreyas.nc@intel.com>
*
*/
#include "pvt_local.h"

struct skl_dfw_module_mod dfw_wrap[] = {
{
.name = "media0_in cpr 0",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 0,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 1,
	.dev_type = 5,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 1,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "media0_in mi",
.skl_dfw_mod = {
	.uuid = {178, 110, 101, 57, 113, 59, 73, 64, 141, 63, 249, 44, 213, 196, 60, 9},
	.module_id = 1,
	.instance_id = 0,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 1,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 0,
	.conn_type = 0,
	.dev_type = 6,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 1,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "media0_out mo",
.skl_dfw_mod = {
	.uuid = {90, 80, 86, 60, 215, 36, 143, 65, 189, 220, 193, 245, 163, 172, 42, 224},
	.module_id = 2,
	.instance_id = 2,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 8,
	.max_out_queue = 1,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 0,
	.conn_type = 0,
	.dev_type = 6,
	.hw_conn_type = 2,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 2,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "media0_out cpr 6",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 6,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 0,
	.dev_type = 5,
	.hw_conn_type = 2,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 2,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "codec0_out mo",
.skl_dfw_mod = {
	.uuid = {90, 80, 86, 60, 215, 36, 143, 65, 189, 220, 193, 245, 163, 172, 42, 224},
	.module_id = 2,
	.instance_id = 0,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 8,
	.max_out_queue = 1,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 0,
	.conn_type = 0,
	.dev_type = 6,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 3,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x4,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "codec0_out cpr 4",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 4,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = 0,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 2,
	.dev_type = 2,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 3,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x4,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "codec1_out mo",
.skl_dfw_mod = {
	.uuid = {90, 80, 86, 60, 215, 36, 143, 65, 189, 220, 193, 245, 163, 172, 42, 224},
	.module_id = 2,
	.instance_id = 1,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 8,
	.max_out_queue = 1,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 0,
	.conn_type = 0,
	.dev_type = 6,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 4,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "codec1_out cpr 5",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 5,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = 0,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 2,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 2,
	.dev_type = 2,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 4,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "codec0_in cpr 1",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 1,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = 0,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 2,
	.dev_type = 2,
	.hw_conn_type = 2,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 5,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "codec0_in mi",
.skl_dfw_mod = {
	.uuid = {178, 110, 101, 57, 113, 59, 73, 64, 141, 63, 249, 44, 213, 196, 60, 9},
	.module_id = 1,
	.instance_id = 1,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 1,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 0,
	.conn_type = 0,
	.dev_type = 6,
	.hw_conn_type = 2,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 5,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "dmic01_hifi_in cpr 3",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 3,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = 0,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 2,
	.dev_type = 1,
	.hw_conn_type = 2,
	.rsvd2 = 0,
	.params_fixup = 4,
	.converter = 4,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 6,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "dmic01_hifi_in mi",
.skl_dfw_mod = {
	.uuid = {178, 110, 101, 57, 113, 59, 73, 64, 141, 63, 249, 44, 213, 196, 60, 9},
	.module_id = 1,
	.instance_id = 3,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 1,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 0,
	.conn_type = 0,
	.dev_type = 6,
	.hw_conn_type = 2,
	.rsvd2 = 0,
	.params_fixup = 0,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 6,
		.pipe_priority = 0,
		.conn_type = 2,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "hdmi1_pt_out cpr 7",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 7,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 1,
	.dev_type = 5,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 7,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 7,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "hdmi1_pt_out cpr 8",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 8,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 1,
	.dev_type = 4,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 7,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 7,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "hdmi2_pt_out cpr 9",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 9,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 1,
	.dev_type = 5,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 7,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 8,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "hdmi2_pt_out cpr 10",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 10,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 1,
	.dev_type = 4,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 7,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 8,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "hdmi3_pt_out cpr 11",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 11,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 1,
	.dev_type = 5,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 7,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 9,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 32,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
{
.name = "hdmi3_pt_out cpr 12",
.skl_dfw_mod = {
	.uuid = {131, 12, 160, 155, 18, 202, 131, 74, 148, 60, 31, 162, 232, 47, 157, 218},
	.module_id = 3,
	.instance_id = 12,
	.max_mcps = 0x186a0,
	.mem_pages = 0x1,
	.obs = 384,
	.ibs = 384,
	.vbus_id = -1,
	.max_in_queue = 1,
	.max_out_queue = 2,
	.time_slot = 0,
	.core_id = 0,
	.rsvd1 = 0,
	.module_type = 1,
	.conn_type = 1,
	.dev_type = 4,
	.hw_conn_type = 1,
	.rsvd2 = 0,
	.params_fixup = 7,
	.converter = 0,
	.input_pin_type = 0,
	.output_pin_type = 0,
	.is_dynamic_in_pin = 1,
	.is_dynamic_out_pin = 1,
	.is_loadable = 0,
	.rsvd3 = 0,
	.pipe = {
		.pipe_id = 9,
		.pipe_priority = 0,
		.conn_type = 1,
		.rsvd = 0,
		.memory_pages = 0x2,
	},
	.in_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.out_fmt = {
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
		{
			.channels = 2,
			.freq = 48000,
			.bit_depth = 32,
			.valid_bit_depth = 24,
			.ch_cfg = 1,
			.interleaving_style = 0,
			.sample_type = 0,
			.ch_map = 0xffffff10,
		},
	},
	.in_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	.out_pin = {
		{
			.module_id = 0,
			.instance_id = 0,
		},
		{
			.module_id = 0,
			.instance_id = 0,
		},
	},
	},
},
	};
