%define	name	ntfsprogs
%define	ver	2.0.0
%define	rel	1
%define	prefix	/usr
%define bindir	/usr/bin
%define sbindir /usr/sbin
%define mandir	/usr/share/man


Summary		: NTFS filesystem libraries and utilities
Name		: %{name}
Version		: %{ver}
Release		: %{rel}
Source		: http://prdownloads.sf.net/linux-ntfs/ntfsprogs-%{ver}.tar.gz
Buildroot	: %{_tmppath}/%{name}-root
Packager	: Anton Altaparmakov <aia21@cantab.net>
License		: GPL
Group		: System Environment/Base
%description
The Linux-NTFS project (http://www.linux-ntfs.org/) aims to bring full support
for the NTFS filesystem to the Linux operating system.  The ntfsprogs package
currently consists of a static library and utilities such as mkntfs, ntfscat,
ntfsls, ntfsresize, and ntfsundelete (for a full list of included utilities
see man 8 ntfsprogs after installation).


%package gnomevfs
Summary		: NTFS GNOME virtual filesystem module
Group		: System Environment/Base
Requires	: ntfsprogs = %{ver}-%{rel}
BuildRequires	: glib2-devel
Requires	: glib2
BuildRequires	: gnome-vfs2-devel
Requires	: gnome-vfs2
%description gnomevfs
This package contains the NTFS GNOME virtual filesystem (VFS) module which
allows GNOME VFS clients to seamlessly utilize the NTFS library (libntfs).


%package -n ntfsmount
Summary		: NTFS FUSE module (ntfsmount)
Group		: System Environment/Base
Requires	: ntfsprogs = %{ver}-%{rel}
Requires	: fuse >= 2.6.1
%description -n ntfsmount
This package contains the ntfsmount utility which is an userspace read/write
NTFS driver allowing users to mount an ntfs filesystem using FUSE and accessing
it using the functionality provided by the NTFS library (libntfs).


%package devel
Summary		: files required to compile software that uses libntfs
Group		: Development/System
Requires	: ntfsprogs = %{ver}-%{rel}
%description devel
This package includes the header files and libraries needed to link software
with the NTFS library (libntfs).


%prep
%setup

%build
if [ -n "$LINGUAS" ]; then unset LINGUAS; fi
%configure --enable-gnome-vfs --enable-fuse-module
make


%install
rm -rf "$RPM_BUILD_ROOT"
make DESTDIR="$RPM_BUILD_ROOT" install-strip


%clean
rm -rf "$RPM_BUILD_ROOT"


%post
/sbin/ldconfig


%postun
/sbin/ldconfig


%files
%defattr(-,root,root)
%doc AUTHORS COPYING CREDITS ChangeLog INSTALL NEWS README TODO.include TODO.libntfs TODO.ntfsprogs doc/CodingStyle doc/attribute_definitions doc/attributes.txt doc/compression.txt doc/tunable_settings doc/template.c doc/template.h doc/system_files.txt doc/system_security_descriptors.txt
%{bindir}/ntfs[^m][^o]*
%{sbindir}/*
/sbin/mkfs.ntfs
%{mandir}/man8/mkntfs.8*
%{mandir}/man8/mkfs.ntfs.8*
%{mandir}/man8/ntfs[^m][^o]*.8*
%{_libdir}/libntfs.*so*

%files gnomevfs
%defattr(-,root,root)
%{mandir}/man8/libntfs-gnomevfs.8*
%{_libdir}/gnome-vfs-2.0/modules/libntfs-gnomevfs.*so*
%config %{_sysconfdir}/gnome-vfs-2.0/modules/libntfs.conf

%files -n ntfsmount
%defattr(-,root,root)
%{bindir}/ntfsmount*
/sbin/mount.ntfs-fuse
%{mandir}/man8/ntfsmount.8*
%{mandir}/man8/mount.ntfs-fuse.8*

%files devel
%defattr(-,root,root)
%{_includedir}/*
%{_libdir}/libntfs.*a*
%{_libdir}/gnome-vfs-2.0/modules/libntfs-gnomevfs.*a*

%changelog
* Mon Sep 10 2007 Yura Pakhuchiy <pakhuchiy@gmail.com>
- Rename rpm ntfsprogs-fuse to ntfsmount.

* Fri Oct 7 2005 Anton Altaparmakov <aia21@cantab.net>
- Fix the file distribution after new binaries have been added as they were
  ending up in the wrong rpms.

* Mon Aug 15 2005 Szabolcs Szakacsits <szaka@sienet.hu>
- Add mkfs.ntfs.

* Mon Jul 18 2005 Anton Altaparmakov <aia21@cantab.net>
- Add ntfsmount fuse module in separate rpm ntfsprogs-fuse.

* Wed Mar 10 2004 Anton Altaparmakov <aia21@cantab.net>
- Cleanup descriptions ready for 1.9.0 release.

* Mon Jan 19 2004 Anton Altaparmakov <aia21@cantab.net>
- Add %config to tell rpm that libntfs.conf is a config file.

* Thu Nov 6 2003 Anton Altaparmakov <aia21@cantab.net>
- update description (it was getting too long)
- merge libntfs-gnomevfs

* Fri Oct 19 2003 Richard Russon <ntfs@flatcap.org>
- added the new utility ntfscat

* Tue Sep 30 2003 Anton Altaparmakov <aia21@cantab.net>
- added the new utilities, ntfsclone, ntfscluster, ntfsinfo, ntfsls.

* Sat Jan 18 2003 Anton Altaparmakov <aia21@cantab.net>
- renamed to ntfsprogs.spec.in
- change source tar ball name to ntfsprogs

* Tue Dec 10 2002 Anton Altaparmakov <aia21@cantab.net>
- added ntfsresize

* Wed Jul 18 2002 Richard Russon <ntfs@flatcap.org>
- added ntfsundelete
- change TODO names

* Wed Jul 3 2002 Anton Altaparmakov <aia21@cantab.net>
- update my email address

* Mon Jun 3 2002 Anton Altaparmakov <aia21@cam.ac.uk>
- update %doc with new TODO files

* Tue Apr 12 2002 Anton Altaparmakov <aia21@cam.ac.uk>
- update %description text for ntfslabel

* Tue Mar 12 2002 Anton Altaparmakov <aia21@cam.ac.uk>
- update %description text

* Sat Jan 26 2002 Anton Altaparmakov <aia21@cam.ac.uk>
- update %description text
- make dependencies pick the right version automatically

* Thu Jan 10 2002 Anton Altaparmakov <aia21@cam.ac.uk>
- add dependency on linux-ntfs to linux-ntfs-devel
- update %description text

* Fri Nov 09 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- update %description text
- (re)enable installation of shared libraries

* Wed Aug 22 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- update %description text

* Thu Aug 2 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- update %description text

* Wed Jul 25 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- include sbin install path (mkntfs now is in sbin)

* Tue Jul 24 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- update %description text

* Mon Jun 11 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- remove duplicate %configure options
- remove shared library installation as shared libraries are disabled by
default

* Sun Jun 10 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- add man pages stuff
- update info text
- add new doc/ stuff
- modify installation to do install-strip instead of install followed by manual
stripping
- update download URL to be the fast sourceforge http download server

* Fri Feb 2 2001 Anton Altaparmakov <aia21@cam.ac.uk>
- started changelog

