<?php
/*
	wp-newblog.php for WordPress Mu
	Plans are to make it a plugin, wrap a user interface around the settings and do some proper logging
	
	Change Log:
		Fixed typo (thanks JuanManuel)
		Fixed Missing location tag for redirection (thanks ontime)
		Added Example callback
		
	Dasher - 27-02-2005

	Rewritten on 26-05-2005 by donncha@linux.ie
	(This message will disappear in the next update)
*/


define('PREG_FIND_RECURSIVE', 1);	// PREG_FIND_RECURSIVE   - go into subdirectorys looking for more files
define('PREG_FIND_DIRMATCH', 2);	// PREG_FIND_DIRMATCH    - return directorys that match the pattern also
define('PREG_FIND_FULLPATH', 4);	// PREG_FIND_FULLPATH    - search for the pattern in the full path (dir+file)
define('PREG_FIND_NEGATE', 8);		// PREG_FIND_NEGATE      - return files that don't match the pattern
define('PREG_FIND_DIRONLY', 16);	// PREG_FIND_DIRONLY     - return only directorys that match the pattern (no files)
define('PREG_FIND_RETURNASSOC', 32);// PREG_FIND_RETURNASSOC - Instead of just returning a plain array of matches,
									// return an associative array with file stats
									// to use more than one simply seperate them with a | character

// Handle installs < PHP 4.3
if (!function_exists('file_get_contents')) {
   function file_get_contents($file) {
       $file = file($file);
       return !$file ? false : implode('', $file);
   }
}

function displayInitalForm( $weblog_id = '', $weblog_title = '', $admin_email = '' ) {
    print '
	<form name="setup" id="setup" method="post" action="wp-newblog.php">
	<input type="hidden" name="stage" value="1">
	<table>
	<tr>
	<th width="33%">Weblog ID:</th>
	<td><input name="weblog_id" type="text" id="weblog_id" value="'.$weblog_id.'" size="10" /><br />Your ID should contain only letters or numbers, no spaces or punctuation marks suchs as \' " , .</td>
	</tr>
	<tr>
	<th width="33%">Weblog Title:</th>
	<td><input name="weblog_title" type="text" id="weblog_title" value="'.$weblog_title.'" size="20" /></td>
	</tr>
	<tr>
	<th width="33%">Your Email:</th>
	<td><input name="admin_email" type="text" id="admin_email" value="'.$admin_email.'" size="20" /></td>
	</tr>
	</table>
	<h2 class="step">
	<input type="submit" name="Submit" value="Continue to Second Step &raquo;" />
	</h2>
	</form>';
}

function displaySecondForm() {
    global $url;
    print "Well done! You've now setup a new WordPress MU blog! Check your email for more information!<br>";
    print "Visit: <a href='$url'>$url</a><br>";
    print "Login: <a href='".$url."wp-login.php'>".$url."wp-login.php</a><br>";
}

/* 
   Cleans user entered data
   @var string $data  The form posted data
*/
function cleanData($data) {
    // Call me paranoid but...
    $result = rtrim($data, "\x00..\x1F");
    $result= str_replace("..", "", $result);
    $result = strip_tags($result);		
    $result = trim($result);

    if (preg_match('/((\\"|\'|`|\\s))/', $result)) {
	// Invalid characters in the name
	$result = '';			
    }
    return $result;
}
/*
   Determines the directory path - using the current script
 */
function determineDirPath() {
    global $_SERVER;

    $result = dirname( $_SERVER["SCRIPT_NAME"] );	
    if( substr($result, -1 ) == '/') {
	$result = substr($result, 0, -1);
    }

    $result = str_replace("/wp-inst","",$result);
    return $result;
}

/* 
   Determines if a blog of $name exists already.
   Currently checks via the directory - but will become a table in MySQL
   @var string $name	The name to check
 */
function nameExists($name) {
    // Currently checking directories - there should be a table in the database
    if (is_dir( "./wp-content/blogs/".$name)) {
	return true;
    }
    return false;
}

/*
   Make a dir with the specified perms
   @var string $name	The dirname to create
 */
function makeDir($name) {
    $oldMask = umask(0);
    @mkdir( "./wp-content/blogs/".$name, 0777);
    umask($oldMask);
}

/*
   Recursive copy function - that copies files & dir's
   @var string $source 		The source to copy
   @var string $destination 	The target to copy it to
   @var int	$perm			Permissions for DIR's
*/
function recursiveCopy($source, $destination, $perm = 0777) {
    // Simple copy for a file

    if (is_file($source)) {
	return @copy($source, $destination);
    }

    // Make destination directory
    if (!is_dir($destination)) {
	$oldMask = umask(0);
	@mkdir($destination, $perm);
	umask($oldMask);
    }

    // Loop through the folder
    $dir = dir($source);
    while (false !== $entry = $dir->read()) {
	// Skip pointers
	if ($entry == '.' || $entry == '..') {
	    continue;
	}

	// Deep copy directories
	if ($destination !== "$source/$entry") {
	    recursiveCopy("$source/$entry", "$destination/$entry");
	}
    }

    // Clean up
    $dir->close();
    return true;
}

/*
* Find files in a directory matching a pattern
*
*
* Paul Gregg <pgregg@pgregg.com>
* 20 March 2004,  Updated 20 April 2004
*
* Open Source Code:   If you use this code on your site for public
* access (i.e. on the Internet) then you must attribute the author and
* source web site: http://www.pgregg.com/projects/php/code/preg_find.phps
* Working example: http://www.pgregg.com/projects/php/code/preg_find_ex.phps
*
*/
Function preg_find($pattern, $start_dir='.', $args=NULL) {
	// Search for files matching $pattern in $start_dir.
	// if args contains PREG_FIND_RECURSIVE then do a recursive search
	// return value is an associative array, the key of which is the path/file
	// and the value is the stat of the file.
	
	$files_matched = array();
	
	$fh = opendir($start_dir);
	
	while (($file = readdir($fh)) !== false) {
		if (strcmp($file, '.')==0 || strcmp($file, '..')==0) continue;
		$filepath = $start_dir . '/' . $file;
		if (preg_match($pattern,
		($args & PREG_FIND_FULLPATH) ? $filepath : $file)) {
			$doadd =    is_file($filepath)
			|| (is_dir($filepath) && ($args & PREG_FIND_DIRMATCH))
			|| (is_dir($filepath) && ($args & PREG_FIND_DIRONLY));
			if ($args & PREG_FIND_DIRONLY && $doadd && !is_dir($filepath)) $doadd = false;
			if ($args & PREG_FIND_NEGATE) $doadd = !$doadd;
			if ($doadd) {
				if ($args & PREG_FIND_RETURNASSOC) { // return more than just the filenames
					$fileres = array();
					if (function_exists('stat')) {
						$fileres['stat'] = stat($filepath);
						$fileres['du'] = $fileres['stat']['blocks'] * $fileres['stat']['blksize'] / 8;
					}
					if (function_exists('fileowner')) $fileres['uid'] = fileowner($filepath);
					if (function_exists('filegroup')) $fileres['gid'] = filegroup($filepath);
					if (function_exists('filetype')) $fileres['filetype'] = filetype($filepath);
					if (function_exists('mime_content_type')) $fileres['mimetype'] = mime_content_type($filepath);
					if (function_exists('dirname')) $fileres['dirname'] = dirname($filepath);
					if (function_exists('basename')) $fileres['basename'] = basename($filepath);
					if (isset($fileres['uid']) && function_exists('posix_getpwuid ')) $fileres['owner'] = posix_getpwuid ($fileres['uid']);
					$files_matched[$filepath] = $fileres;
				} else
				array_push($files_matched, $filepath);
			}
		}
		if ( is_dir($filepath) && ($args & PREG_FIND_RECURSIVE) ) {
			$files_matched = array_merge($files_matched,
			preg_find($pattern, $filepath, $args));
		}
	}
	
	closedir($fh);
	return $files_matched;
}

/*
   Updates the templates and rewrites the path 
   @var string $newBlogID	The new blog ID of the user
 */
function copyTemplates($newBlogID) {		
    global $scriptBaseName;

    recursiveCopy( './wp-content/sitetemplates/humancondition/templates', "./wp-content/blogs/$newBlogID/templates");
    $files = preg_find("/\.css$/", './wp-content/blogs/'.$newBlogID, PREG_FIND_RECURSIVE);

    foreach ($files as $thisFile) {
	// Update the css file
	$cssfile = '';
	$cssfile = file_get_contents($thisFile, false);
	if ($cssfile!=false) {
	    $cssfile = str_replace( "BASE", $scriptBaseName, $cssfile );
	    $fp = fopen($thisFile, "w" );
	    fwrite( $fp, $cssfile );
	    fclose( $fp );
	}
    }
}


switch( $_POST[ 'stage' ] )
{
    case "1":
	$newBlogID = cleanData($_POST['weblog_id']);
        if (isset($newBlogID) && ($newBlogID !='' )) {
	    $scriptBaseName = determineDirPath();
	    $serverName = $_SERVER[ 'SERVER_NAME' ];
	    $url = 'http://'.$serverName.$scriptBaseName."/".$newBlogID."/";
	    if (nameExists($newBlogID) == false ) {
		// Define the skeleton dir structure
		makeDir($newBlogID);
		makeDir($newBlogID.'/images');
		makeDir($newBlogID.'/templates');
		makeDir($newBlogID.'/templates_c');
		makeDir($newBlogID.'/smartycache');

		// Copy the templates
		copyTemplates($newBlogID);

		// Install the db tables START
		define( "WP_INSTALLING", true );
		// taken from WP install.php
		$wpblog = $newBlogID;
		require_once('./wp-config.php');
		require_once('./wp-admin/upgrade-functions.php');
		$wpdb->hide_errors();
		$installed = $wpdb->get_results("SELECT * FROM $wpdb->users");
		if ($installed) die(__('<h1>Already Installed</h1><p>You appear to have already installed WordPress. To reinstall please clear your old database tables first.</p>') . '</body></html>');
		flush();

		// Set everything up
		make_db_current_silent();
		populate_options();

		// fix url.
		update_option('siteurl', $url);

		$wpdb->query("UPDATE $wpdb->options SET option_value = '$weblog_title' WHERE option_name = 'blogname'");
		$wpdb->query("UPDATE $wpdb->options SET option_value = '$admin_email' WHERE option_name = 'admin_email'");

		// Now drop in some default links
		$wpdb->query("INSERT INTO $wpdb->linkcategories (cat_id, cat_name) VALUES (1, '".addslashes(__('Blogroll'))."')");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://blog.carthik.net/index.php', 'Carthik', 1, 'http://blog.carthik.net/feed/');");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://blogs.linux.ie/xeer/', 'Donncha', 1, 'http://blogs.linux.ie/xeer/feed/');");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://zengun.org/weblog/', 'Michel', 1, 'http://zengun.org/weblog/feed/');");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://boren.nu/', 'Ryan', 1, 'http://boren.nu/feed/');");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://photomatt.net/', 'Matt', 1, 'http://xml.photomatt.net/feed/');");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://zed1.com/journalized/', 'Mike', 1, 'http://zed1.com/journalized/feed/');");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://www.alexking.org/', 'Alex', 1, 'http://www.alexking.org/blog/wp-rss2.php');");
		$wpdb->query("INSERT INTO $wpdb->links (link_url, link_name, link_category, link_rss) VALUES ('http://dougal.gunters.org/', 'Dougal', 1, 'http://dougal.gunters.org/feed/');");

		// Default category
		$wpdb->query("INSERT INTO $wpdb->categories (cat_ID, cat_name, category_nicename) VALUES ('0', '".addslashes(__('Uncategorized'))."', '".sanitize_title(__('Uncategorized'))."')");

		// First post
		$now = date('Y-m-d H:i:s');
		$now_gmt = gmdate('Y-m-d H:i:s');
		$wpdb->query("INSERT INTO $wpdb->posts (post_author, post_date, post_date_gmt, post_content, post_title, post_category, post_name, post_modified, post_modified_gmt) VALUES ('1', '$now', '$now_gmt', '".addslashes(__('Welcome to WordPress MU. This is your first post. Edit or delete it, then start blogging!'))."', '".addslashes(__('Hello world!'))."', '0', '".addslashes(__('hello-world'))."', '$now', '$now_gmt')");

		$wpdb->query( "INSERT INTO $wpdb->post2cat (`rel_id`, `post_id`, `category_id`) VALUES (1, 1, 1)" );

		// Default comment
		$wpdb->query("INSERT INTO $wpdb->comments (comment_post_ID, comment_author, comment_author_email, comment_author_url, comment_author_IP, comment_date, comment_date_gmt, comment_content) VALUES ('1', '".addslashes(__('Mr WordPress'))."', '', 'http://wordpress.org', '127.0.0.1', '$now', '$now_gmt', '".addslashes(__('Hi, this is a comment.<br />To delete a comment, just log in, and view the posts\' comments, there you will have the option to edit or delete them.'))."')");

		// Set up admin user
		$random_password = substr(md5(uniqid(microtime())), 0, 6);
		$wpdb->query("INSERT INTO $wpdb->users (ID, user_login, user_pass, user_nickname, user_email, user_level, user_idmode, user_registered) VALUES ( '1', '".$wpblog."', MD5('$random_password'), '".addslashes(__('Administrator'))."', '$admin_email', '10', 'nickname', NOW() )");

		$message_headers = 'From: ' . stripslashes($_POST['weblog_title']) . ' <wordpress@' . $_SERVER['SERVER_NAME'] . '>';
		$message = __("Dear User,\n\nYour new WordPressMU blog has been successfully set up at:\n".$url."\n\nYou can log in to the administrator account with the following information:\n Username: ".$wpblog."\n Password: ".$random_password."\nLogin Here: ".$url."wp-login.php\n\nWe hope you enjoy your new weblog.\n Thanks!\n\n--The WordPressMU Team\nhttp://mu.wordpress.org/\n");
		@mail($_POST[ 'admin_email' ], __('New WordPress MU Blog'), $message, $message_headers);

		upgrade_all();
		// Install the db tables END
		displaySecondForm();
	    }
	    else
	    {
		print "Sorry, that blog already exists!";
		displayInitalForm( $_POST[ 'weblog_id' ], $_POST[ 'weblog_title' ], $_POST[ 'admin_email' ] );
	    }
	}
        break;
    default:
	displayInitalForm();
	break;

}
?>
