//
// Filename: xojpanel.h
//
// XojPanel class declaration.
/*
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

   In addition, as a special exception, Joe Piolunek
   gives permission to link the code of this program with the
   OpenSSL library (or with modified versions of OpenSSL that use the
   same license as OpenSSL), and distribute linked combinations including
   the two.  You must obey the GNU General Public License in all
   respects for all of the code used other than OpenSSL.  If you modify
   this file, you may extend this exception to your version of the
   file, but you are not obligated to do so.  If you do not wish to
   do so, delete this exception statement from your version.
*/

// Copyright (C) 2000-2002 Joe Piolunek
//
// This is an expanded and nearly completely re-written version
// of the original xojpanel application released by Andreas Fester.
//
// Thanks to David Paschal for contributing a patch to allow xojpanel to exit
// gracefully if the peripheral does not support LCD message requests.
// David Paschal also did the ojlib->PTAL conversion.
//


#ifndef XOJPANEL_H
#define XOJPANEL_H

#include "ptal.h"
#include <qwidget.h>
#include <qpixmap.h>
#include <qlabel.h>

class XojPanel : public QWidget
{
	Q_OBJECT
public:
	XojPanel(int argc, char **argv, QWidget *parent=0, const char *name=0 );
	void paintEvent( QPaintEvent* );
	void closeEvent( QCloseEvent* );

private slots:
	void getPrinterLCDMessages();
	void updateLCDPixmap();

private:
	void createInterface( QString, bool );
	void createLCD( void );
	void createCoverGraphic( void );
	void createTimers( void );
	void adjustMessageContents( char[], int );
	void displayLCDMessage( QString*, QString*, bool, bool );
	void drawLCDTextLine( QPainter*, QString*, int, int );
	void buildCharacterMap( bool );

	//int findCoordY( QPainter *, int );
	int findCoordY( int );
	
	QWidget *xojpanel;
	QPixmap *pm;
	QPixmap *lcdPixmap;
	QLabel *lcdGraphic;
	QString Line1;    // upper line of the LCD
	QString Line2;    // lower line of the LCD
	unsigned char* characterTranslationMap; // Pointer to characterMap[]

	char* caption;
	char* ptalDeviceName;
 	
	bool useCaption;
	
	ptalDevice_t dev;
	// objHpLineX are for the HP MIB.
	// objSpmLineX are for the Standard Printer MIB.
	// objLineX start out pointing to the HP objects,
	// but may get changed to the SPM objects if the
	// peripheral doesn't support the HP objects.
	ptalPmlObject_t objLine1;
	ptalPmlObject_t objLine2;
	ptalPmlObject_t objHpLine1;
	ptalPmlObject_t objHpLine2;
	ptalPmlObject_t objSpmLine1;
	ptalPmlObject_t objSpmLine2;
};



#endif
