/* testcollection.c generated by valac 0.11.5, the Vala compiler
 * generated from testcollection.vala, do not modify */

/* testcollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
enum  {
	COLLECTION_TESTS_DUMMY_PROPERTY
};
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void collection_tests_test_type_correctness (CollectionTests* self);
static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self);
static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self);
void collection_tests_test_mutable_iterator (CollectionTests* self);
static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_size_and_is_empty (CollectionTests* self);
static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_remove (CollectionTests* self);
static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self);
void collection_tests_test_clear (CollectionTests* self);
static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_all (CollectionTests* self);
static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_all (CollectionTests* self);
static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_remove_all (CollectionTests* self);
static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_retain_all (CollectionTests* self);
static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_to_array (CollectionTests* self);
static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self);
void collection_tests_test_gobject_properties (CollectionTests* self);
static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
static void collection_tests_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self) {
	collection_tests_test_type_correctness (self);
}


static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self) {
	collection_tests_test_iterator_returns_all_elements_once (self);
}


static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self) {
	collection_tests_test_mutable_iterator (self);
}


static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_size_and_is_empty (self);
}


static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_remove (self);
}


static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self) {
	collection_tests_test_clear (self);
}


static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_all (self);
}


static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_all (self);
}


static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_remove_all (self);
}


static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_retain_all (self);
}


static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self) {
	collection_tests_test_to_array (self);
}


static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	collection_tests_test_gobject_properties (self);
}


CollectionTests* collection_tests_construct (GType object_type, const gchar* name) {
	CollectionTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (CollectionTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] type correctness", _collection_tests_test_type_correctness_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator returns all elements once", _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] mutable iterator", _collection_tests_test_mutable_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains, size and is_empty", _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add and remove", _collection_tests_test_add_remove_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _collection_tests_test_clear_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add_all", _collection_tests_test_add_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains_all", _collection_tests_test_contains_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove_all", _collection_tests_test_remove_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] retain_all", _collection_tests_test_retain_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] to_array", _collection_tests_test_to_array_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] GObject properties", _collection_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


void collection_tests_test_type_correctness (CollectionTests* self) {
	GType _tmp0_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_iterable_get_element_type ((GeeIterable*) self->test_collection);
	g_assert (_tmp0_ == G_TYPE_STRING);
}


void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self) {
	gboolean has_next = FALSE;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* iterator;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	iterator = _tmp0_;
	_tmp1_ = gee_iterator_has_next (iterator);
	g_assert (!_tmp1_);
	_tmp2_ = gee_iterator_next (iterator);
	g_assert (!_tmp2_);
	_tmp3_ = gee_iterator_first (iterator);
	g_assert (!_tmp3_);
	_tmp4_ = gee_collection_add (self->test_collection, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add (self->test_collection, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add (self->test_collection, "three");
	g_assert (_tmp6_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (iterator);
	iterator = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_;
		gboolean _tmp10_;
		gpointer _tmp11_ = NULL;
		gchar* element;
		_tmp9_ = gee_iterator_has_next (iterator);
		has_next = _tmp9_;
		_tmp10_ = gee_iterator_next (iterator);
		g_assert (has_next == _tmp10_);
		if (!has_next) {
			break;
		}
		_tmp11_ = gee_iterator_get (iterator);
		element = (gchar*) _tmp11_;
		if (g_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (g_strcmp0 (element, "two") == 0) {
				if (two_found) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				if (g_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp12_ = gee_iterator_has_next (iterator);
	has_next = _tmp12_;
	g_assert (!has_next);
	_tmp13_ = gee_iterator_next (iterator);
	g_assert (has_next == _tmp13_);
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (two_found);
	g_assert (two_found_once);
	g_assert (three_found);
	g_assert (three_found_once);
	_tmp14_ = gee_iterator_first (iterator);
	g_assert (_tmp14_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		gpointer _tmp15_ = NULL;
		gchar* element;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = gee_iterator_get (iterator);
		element = (gchar*) _tmp15_;
		if (g_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (g_strcmp0 (element, "two") == 0) {
				if (two_found) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				if (g_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp16_ = gee_iterator_has_next (iterator);
		has_next = _tmp16_;
		_tmp17_ = gee_iterator_next (iterator);
		g_assert (has_next == _tmp17_);
		if (!has_next) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp18_ = gee_iterator_has_next (iterator);
	has_next = _tmp18_;
	g_assert (!has_next);
	_tmp19_ = gee_iterator_next (iterator);
	g_assert (has_next == _tmp19_);
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (two_found);
	g_assert (two_found_once);
	g_assert (three_found);
	g_assert (three_found_once);
	_g_object_unref0 (iterator);
}


void collection_tests_test_mutable_iterator (CollectionTests* self) {
	gboolean has_next = FALSE;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* iterator;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeIterator* _tmp4_ = NULL;
	GeeIterator* _tmp5_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	iterator = _tmp0_;
	_tmp1_ = gee_collection_add (self->test_collection, "one");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add (self->test_collection, "two");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add (self->test_collection, "three");
	g_assert (_tmp3_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (iterator);
	iterator = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		gpointer _tmp8_ = NULL;
		gchar* element;
		_tmp6_ = gee_iterator_has_next (iterator);
		has_next = _tmp6_;
		_tmp7_ = gee_iterator_next (iterator);
		g_assert (has_next == _tmp7_);
		if (!has_next) {
			break;
		}
		_tmp8_ = gee_iterator_get (iterator);
		element = (gchar*) _tmp8_;
		if (g_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (g_strcmp0 (element, "two") == 0) {
				if (two_found) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
				gee_iterator_remove (iterator);
			} else {
				if (g_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp9_ = gee_iterator_has_next (iterator);
	has_next = _tmp9_;
	g_assert (!has_next);
	_tmp10_ = gee_iterator_next (iterator);
	g_assert (has_next == _tmp10_);
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (two_found);
	g_assert (two_found_once);
	g_assert (three_found);
	g_assert (three_found_once);
	_tmp11_ = gee_iterator_first (iterator);
	g_assert (_tmp11_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		gpointer _tmp12_ = NULL;
		gchar* element;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = gee_iterator_get (iterator);
		element = (gchar*) _tmp12_;
		if (g_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (g_strcmp0 (element, "two") == 0) {
				two_found = TRUE;
			} else {
				if (g_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp13_ = gee_iterator_has_next (iterator);
		has_next = _tmp13_;
		_tmp14_ = gee_iterator_next (iterator);
		g_assert (has_next == _tmp14_);
		if (!has_next) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp15_ = gee_iterator_has_next (iterator);
	has_next = _tmp15_;
	g_assert (!has_next);
	_tmp16_ = gee_iterator_next (iterator);
	g_assert (has_next == _tmp16_);
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (!two_found);
	g_assert (three_found);
	g_assert (three_found_once);
	_g_object_unref0 (iterator);
}


void collection_tests_test_contains_size_and_is_empty (CollectionTests* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gint _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gint _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gint _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gint _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gint _tmp50_;
	gboolean _tmp51_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_collection_contains (self->test_collection, "one");
	g_assert (!_tmp0_);
	_tmp1_ = gee_collection_contains (self->test_collection, "two");
	g_assert (!_tmp1_);
	_tmp2_ = gee_collection_contains (self->test_collection, "three");
	g_assert (!_tmp2_);
	_tmp3_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp3_ == 0);
	_tmp4_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add (self->test_collection, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_contains (self->test_collection, "one");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_contains (self->test_collection, "two");
	g_assert (!_tmp7_);
	_tmp8_ = gee_collection_contains (self->test_collection, "three");
	g_assert (!_tmp8_);
	_tmp9_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp9_ == 1);
	_tmp10_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (!_tmp10_);
	_tmp11_ = gee_collection_remove (self->test_collection, "one");
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_contains (self->test_collection, "one");
	g_assert (!_tmp12_);
	_tmp13_ = gee_collection_contains (self->test_collection, "two");
	g_assert (!_tmp13_);
	_tmp14_ = gee_collection_contains (self->test_collection, "three");
	g_assert (!_tmp14_);
	_tmp15_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp15_ == 0);
	_tmp16_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp16_);
	_tmp17_ = gee_collection_add (self->test_collection, "one");
	g_assert (_tmp17_);
	_tmp18_ = gee_collection_contains (self->test_collection, "one");
	g_assert (_tmp18_);
	_tmp19_ = gee_collection_contains (self->test_collection, "two");
	g_assert (!_tmp19_);
	_tmp20_ = gee_collection_contains (self->test_collection, "three");
	g_assert (!_tmp20_);
	_tmp21_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp21_ == 1);
	_tmp22_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (!_tmp22_);
	_tmp23_ = gee_collection_add (self->test_collection, "two");
	g_assert (_tmp23_);
	_tmp24_ = gee_collection_contains (self->test_collection, "one");
	g_assert (_tmp24_);
	_tmp25_ = gee_collection_contains (self->test_collection, "two");
	g_assert (_tmp25_);
	_tmp26_ = gee_collection_contains (self->test_collection, "three");
	g_assert (!_tmp26_);
	_tmp27_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp27_ == 2);
	_tmp28_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (!_tmp28_);
	_tmp29_ = gee_collection_add (self->test_collection, "three");
	g_assert (_tmp29_);
	_tmp30_ = gee_collection_contains (self->test_collection, "one");
	g_assert (_tmp30_);
	_tmp31_ = gee_collection_contains (self->test_collection, "two");
	g_assert (_tmp31_);
	_tmp32_ = gee_collection_contains (self->test_collection, "three");
	g_assert (_tmp32_);
	_tmp33_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp33_ == 3);
	_tmp34_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (!_tmp34_);
	_tmp35_ = gee_collection_remove (self->test_collection, "two");
	g_assert (_tmp35_);
	_tmp36_ = gee_collection_contains (self->test_collection, "one");
	g_assert (_tmp36_);
	_tmp37_ = gee_collection_contains (self->test_collection, "two");
	g_assert (!_tmp37_);
	_tmp38_ = gee_collection_contains (self->test_collection, "three");
	g_assert (_tmp38_);
	_tmp39_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp39_ == 2);
	_tmp40_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (!_tmp40_);
	_tmp41_ = gee_collection_remove (self->test_collection, "two");
	g_assert (!_tmp41_);
	_tmp42_ = gee_collection_contains (self->test_collection, "one");
	g_assert (_tmp42_);
	_tmp43_ = gee_collection_contains (self->test_collection, "two");
	g_assert (!_tmp43_);
	_tmp44_ = gee_collection_contains (self->test_collection, "three");
	g_assert (_tmp44_);
	_tmp45_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp45_ == 2);
	_tmp46_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (!_tmp46_);
	gee_collection_clear (self->test_collection);
	_tmp47_ = gee_collection_contains (self->test_collection, "one");
	g_assert (!_tmp47_);
	_tmp48_ = gee_collection_contains (self->test_collection, "two");
	g_assert (!_tmp48_);
	_tmp49_ = gee_collection_contains (self->test_collection, "three");
	g_assert (!_tmp49_);
	_tmp50_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp50_ == 0);
	_tmp51_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp51_);
}


void collection_tests_test_add_remove (CollectionTests* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_ = NULL;
	gchar** to_add;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size;
	gint _tmp46_;
	gint _tmp55_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = g_strdup ("one");
	_tmp1_ = g_strdup ("two");
	_tmp2_ = g_strdup ("three");
	_tmp3_ = g_strdup ("four");
	_tmp4_ = g_strdup ("five");
	_tmp5_ = g_strdup ("six");
	_tmp6_ = g_strdup ("seven");
	_tmp7_ = g_strdup ("eight");
	_tmp8_ = g_strdup ("nine");
	_tmp9_ = g_strdup ("ten");
	_tmp10_ = g_strdup ("eleven");
	_tmp11_ = g_strdup ("twelve");
	_tmp12_ = g_strdup ("thirteen");
	_tmp13_ = g_strdup ("fourteen");
	_tmp14_ = g_strdup ("fifteen");
	_tmp15_ = g_strdup ("sixteen");
	_tmp16_ = g_strdup ("seventeen");
	_tmp17_ = g_strdup ("eighteen");
	_tmp18_ = g_strdup ("nineteen");
	_tmp19_ = g_strdup ("twenty");
	_tmp20_ = g_strdup ("twenty one");
	_tmp21_ = g_strdup ("twenty two");
	_tmp22_ = g_strdup ("twenty three");
	_tmp23_ = g_strdup ("twenty four");
	_tmp24_ = g_strdup ("twenty five");
	_tmp25_ = g_strdup ("twenty six");
	_tmp26_ = g_strdup ("twenty seven");
	_tmp27_ = g_strdup ("twenty eight");
	_tmp28_ = g_strdup ("twenty nine");
	_tmp29_ = g_strdup ("thirty");
	_tmp30_ = g_strdup ("thirty one");
	_tmp31_ = g_strdup ("thirty two");
	_tmp32_ = g_strdup ("thirty four");
	_tmp33_ = g_strdup ("thirty five");
	_tmp34_ = g_strdup ("thirty six");
	_tmp35_ = g_strdup ("thirty seven");
	_tmp36_ = g_strdup ("thirty eight");
	_tmp37_ = g_strdup ("thirty nine");
	_tmp38_ = g_strdup ("fourty");
	_tmp39_ = g_new0 (gchar*, 39 + 1);
	_tmp39_[0] = _tmp0_;
	_tmp39_[1] = _tmp1_;
	_tmp39_[2] = _tmp2_;
	_tmp39_[3] = _tmp3_;
	_tmp39_[4] = _tmp4_;
	_tmp39_[5] = _tmp5_;
	_tmp39_[6] = _tmp6_;
	_tmp39_[7] = _tmp7_;
	_tmp39_[8] = _tmp8_;
	_tmp39_[9] = _tmp9_;
	_tmp39_[10] = _tmp10_;
	_tmp39_[11] = _tmp11_;
	_tmp39_[12] = _tmp12_;
	_tmp39_[13] = _tmp13_;
	_tmp39_[14] = _tmp14_;
	_tmp39_[15] = _tmp15_;
	_tmp39_[16] = _tmp16_;
	_tmp39_[17] = _tmp17_;
	_tmp39_[18] = _tmp18_;
	_tmp39_[19] = _tmp19_;
	_tmp39_[20] = _tmp20_;
	_tmp39_[21] = _tmp21_;
	_tmp39_[22] = _tmp22_;
	_tmp39_[23] = _tmp23_;
	_tmp39_[24] = _tmp24_;
	_tmp39_[25] = _tmp25_;
	_tmp39_[26] = _tmp26_;
	_tmp39_[27] = _tmp27_;
	_tmp39_[28] = _tmp28_;
	_tmp39_[29] = _tmp29_;
	_tmp39_[30] = _tmp30_;
	_tmp39_[31] = _tmp31_;
	_tmp39_[32] = _tmp32_;
	_tmp39_[33] = _tmp33_;
	_tmp39_[34] = _tmp34_;
	_tmp39_[35] = _tmp35_;
	_tmp39_[36] = _tmp36_;
	_tmp39_[37] = _tmp37_;
	_tmp39_[38] = _tmp38_;
	to_add = _tmp39_;
	to_add_length1 = 39;
	_to_add_size_ = 39;
	expected_size = 0;
	{
		gchar** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			gchar* _tmp40_;
			gchar* a;
			_tmp40_ = g_strdup (a_collection[a_it]);
			a = _tmp40_;
			{
				gboolean _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gboolean _tmp44_;
				gboolean _tmp45_;
				_tmp41_ = gee_collection_contains (self->test_collection, a);
				g_assert (!_tmp41_);
				_tmp42_ = gee_collection_get_size (self->test_collection);
				_tmp43_ = expected_size;
				expected_size = _tmp43_ + 1;
				g_assert (_tmp42_ == _tmp43_);
				_tmp44_ = gee_collection_add (self->test_collection, a);
				g_assert (_tmp44_);
				_tmp45_ = gee_collection_contains (self->test_collection, a);
				g_assert (_tmp45_);
				_g_free0 (a);
			}
		}
	}
	_tmp46_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp46_ == to_add_length1);
	{
		gchar** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			gchar* _tmp47_;
			gchar* a;
			_tmp47_ = g_strdup (a_collection[a_it]);
			a = _tmp47_;
			{
				gboolean _tmp48_;
				_tmp48_ = gee_collection_contains (self->test_collection, a);
				g_assert (_tmp48_);
				_g_free0 (a);
			}
		}
	}
	{
		gchar** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			gchar* _tmp49_;
			gchar* a;
			_tmp49_ = g_strdup (a_collection[a_it]);
			a = _tmp49_;
			{
				gboolean _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gboolean _tmp53_;
				gboolean _tmp54_;
				_tmp50_ = gee_collection_contains (self->test_collection, a);
				g_assert (_tmp50_);
				_tmp51_ = gee_collection_get_size (self->test_collection);
				_tmp52_ = expected_size;
				expected_size = _tmp52_ - 1;
				g_assert (_tmp51_ == _tmp52_);
				_tmp53_ = gee_collection_remove (self->test_collection, a);
				g_assert (_tmp53_);
				_tmp54_ = gee_collection_contains (self->test_collection, a);
				g_assert (!_tmp54_);
				_g_free0 (a);
			}
		}
	}
	_tmp55_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp55_ == 0);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_clear (CollectionTests* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_ = NULL;
	gchar** to_add;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size;
	gint _tmp46_;
	gint _tmp47_;
	GeeIterator* _tmp48_ = NULL;
	GeeIterator* iter;
	gboolean _tmp49_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = g_strdup ("one");
	_tmp1_ = g_strdup ("two");
	_tmp2_ = g_strdup ("three");
	_tmp3_ = g_strdup ("four");
	_tmp4_ = g_strdup ("five");
	_tmp5_ = g_strdup ("six");
	_tmp6_ = g_strdup ("seven");
	_tmp7_ = g_strdup ("eight");
	_tmp8_ = g_strdup ("nine");
	_tmp9_ = g_strdup ("ten");
	_tmp10_ = g_strdup ("eleven");
	_tmp11_ = g_strdup ("twelve");
	_tmp12_ = g_strdup ("thirteen");
	_tmp13_ = g_strdup ("fourteen");
	_tmp14_ = g_strdup ("fifteen");
	_tmp15_ = g_strdup ("sixteen");
	_tmp16_ = g_strdup ("seventeen");
	_tmp17_ = g_strdup ("eighteen");
	_tmp18_ = g_strdup ("nineteen");
	_tmp19_ = g_strdup ("twenty");
	_tmp20_ = g_strdup ("twenty one");
	_tmp21_ = g_strdup ("twenty two");
	_tmp22_ = g_strdup ("twenty three");
	_tmp23_ = g_strdup ("twenty four");
	_tmp24_ = g_strdup ("twenty five");
	_tmp25_ = g_strdup ("twenty six");
	_tmp26_ = g_strdup ("twenty seven");
	_tmp27_ = g_strdup ("twenty eight");
	_tmp28_ = g_strdup ("twenty nine");
	_tmp29_ = g_strdup ("thirty");
	_tmp30_ = g_strdup ("thirty one");
	_tmp31_ = g_strdup ("thirty two");
	_tmp32_ = g_strdup ("thirty four");
	_tmp33_ = g_strdup ("thirty five");
	_tmp34_ = g_strdup ("thirty six");
	_tmp35_ = g_strdup ("thirty seven");
	_tmp36_ = g_strdup ("thirty eight");
	_tmp37_ = g_strdup ("thirty nine");
	_tmp38_ = g_strdup ("fourty");
	_tmp39_ = g_new0 (gchar*, 39 + 1);
	_tmp39_[0] = _tmp0_;
	_tmp39_[1] = _tmp1_;
	_tmp39_[2] = _tmp2_;
	_tmp39_[3] = _tmp3_;
	_tmp39_[4] = _tmp4_;
	_tmp39_[5] = _tmp5_;
	_tmp39_[6] = _tmp6_;
	_tmp39_[7] = _tmp7_;
	_tmp39_[8] = _tmp8_;
	_tmp39_[9] = _tmp9_;
	_tmp39_[10] = _tmp10_;
	_tmp39_[11] = _tmp11_;
	_tmp39_[12] = _tmp12_;
	_tmp39_[13] = _tmp13_;
	_tmp39_[14] = _tmp14_;
	_tmp39_[15] = _tmp15_;
	_tmp39_[16] = _tmp16_;
	_tmp39_[17] = _tmp17_;
	_tmp39_[18] = _tmp18_;
	_tmp39_[19] = _tmp19_;
	_tmp39_[20] = _tmp20_;
	_tmp39_[21] = _tmp21_;
	_tmp39_[22] = _tmp22_;
	_tmp39_[23] = _tmp23_;
	_tmp39_[24] = _tmp24_;
	_tmp39_[25] = _tmp25_;
	_tmp39_[26] = _tmp26_;
	_tmp39_[27] = _tmp27_;
	_tmp39_[28] = _tmp28_;
	_tmp39_[29] = _tmp29_;
	_tmp39_[30] = _tmp30_;
	_tmp39_[31] = _tmp31_;
	_tmp39_[32] = _tmp32_;
	_tmp39_[33] = _tmp33_;
	_tmp39_[34] = _tmp34_;
	_tmp39_[35] = _tmp35_;
	_tmp39_[36] = _tmp36_;
	_tmp39_[37] = _tmp37_;
	_tmp39_[38] = _tmp38_;
	to_add = _tmp39_;
	to_add_length1 = 39;
	_to_add_size_ = 39;
	expected_size = 0;
	{
		gchar** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			gchar* _tmp40_;
			gchar* a;
			_tmp40_ = g_strdup (a_collection[a_it]);
			a = _tmp40_;
			{
				gboolean _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gboolean _tmp44_;
				gboolean _tmp45_;
				_tmp41_ = gee_collection_contains (self->test_collection, a);
				g_assert (!_tmp41_);
				_tmp42_ = gee_collection_get_size (self->test_collection);
				_tmp43_ = expected_size;
				expected_size = _tmp43_ + 1;
				g_assert (_tmp42_ == _tmp43_);
				_tmp44_ = gee_collection_add (self->test_collection, a);
				g_assert (_tmp44_);
				_tmp45_ = gee_collection_contains (self->test_collection, a);
				g_assert (_tmp45_);
				_g_free0 (a);
			}
		}
	}
	_tmp46_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp46_ == to_add_length1);
	gee_collection_clear (self->test_collection);
	_tmp47_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp47_ == 0);
	_tmp48_ = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	iter = _tmp48_;
	g_assert (iter != NULL);
	_tmp49_ = gee_iterator_has_next (iter);
	g_assert (!_tmp49_);
	_g_object_unref0 (iter);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_add_all (CollectionTests* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* dummy;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gint _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gint _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gint _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp0_;
	_tmp1_ = gee_collection_add_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp1_);
	_tmp2_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp2_);
	_tmp3_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add (self->test_collection, "hello");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp5_);
	_tmp6_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp6_ == 1);
	_tmp7_ = gee_collection_contains (self->test_collection, "hello");
	g_assert (_tmp7_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp8_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp8_);
	_tmp9_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp9_);
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_add_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp12_ == 3);
	_tmp13_ = gee_collection_contains (self->test_collection, "hello1");
	g_assert (_tmp13_);
	_tmp14_ = gee_collection_contains (self->test_collection, "hello2");
	g_assert (_tmp14_);
	_tmp15_ = gee_collection_contains (self->test_collection, "hello3");
	g_assert (_tmp15_);
	_tmp16_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp16_ == 3);
	_tmp17_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp17_);
	_tmp18_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp18_);
	_tmp19_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp19_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp20_);
	_tmp21_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp21_);
	_tmp22_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp22_);
	_tmp23_ = gee_collection_add (self->test_collection, "hello");
	g_assert (_tmp23_);
	_tmp24_ = gee_collection_add_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp24_);
	_tmp25_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp25_ == 4);
	_tmp26_ = gee_collection_contains (self->test_collection, "hello");
	g_assert (_tmp26_);
	_tmp27_ = gee_collection_contains (self->test_collection, "hello1");
	g_assert (_tmp27_);
	_tmp28_ = gee_collection_contains (self->test_collection, "hello2");
	g_assert (_tmp28_);
	_tmp29_ = gee_collection_contains (self->test_collection, "hello3");
	g_assert (_tmp29_);
	_tmp30_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp30_ == 3);
	_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp31_);
	_tmp32_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp32_);
	_tmp33_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp33_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp34_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp34_);
	_tmp35_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp35_);
	_tmp36_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp36_);
	_tmp37_ = gee_collection_add (self->test_collection, "hello1");
	g_assert (_tmp37_);
	_tmp38_ = gee_collection_add_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp38_);
	_tmp39_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp39_ >= 3);
	_tmp40_ = gee_collection_contains (self->test_collection, "hello1");
	g_assert (_tmp40_);
	_tmp41_ = gee_collection_contains (self->test_collection, "hello2");
	g_assert (_tmp41_);
	_tmp42_ = gee_collection_contains (self->test_collection, "hello3");
	g_assert (_tmp42_);
	_tmp43_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp43_ == 3);
	_tmp44_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp44_);
	_tmp45_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp45_);
	_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp46_);
	_g_object_unref0 (dummy);
}


void collection_tests_test_contains_all (CollectionTests* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* dummy;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp0_;
	_tmp1_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp1_);
	_tmp2_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp2_);
	_tmp3_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp5_);
	_tmp6_ = gee_collection_add (self->test_collection, "hello4");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add (self->test_collection, "hello5");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp8_);
	_tmp9_ = gee_collection_add (self->test_collection, "hello1");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_add (self->test_collection, "hello2");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp11_);
	_tmp12_ = gee_collection_add (self->test_collection, "hello3");
	g_assert (_tmp12_);
	_tmp13_ = gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp13_);
	_tmp14_ = gee_abstract_collection_contains_all ((GeeAbstractCollection*) dummy, self->test_collection);
	g_assert (!_tmp14_);
	_g_object_unref0 (dummy);
}


void collection_tests_test_remove_all (CollectionTests* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* dummy;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp0_;
	_tmp1_ = gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp1_);
	_tmp2_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp2_);
	_tmp3_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	g_assert (_tmp3_);
	_tmp4_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp4_);
	_tmp5_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp5_);
	_tmp6_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp7_);
	_tmp8_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp8_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp9_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp9_);
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp10_);
	_tmp11_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_add (self->test_collection, "hello4");
	g_assert (_tmp12_);
	_tmp13_ = gee_collection_add (self->test_collection, "hello5");
	g_assert (_tmp13_);
	_tmp14_ = gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp14_);
	_tmp15_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp15_ == 2);
	_tmp16_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp16_ == 3);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp17_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp17_);
	_tmp18_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp18_);
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp19_);
	_tmp20_ = gee_collection_add (self->test_collection, "hello1");
	g_assert (_tmp20_);
	_tmp21_ = gee_collection_add (self->test_collection, "hello2");
	g_assert (_tmp21_);
	_tmp22_ = gee_collection_add (self->test_collection, "hello3");
	g_assert (_tmp22_);
	_tmp23_ = gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp23_);
	_tmp24_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp24_);
	_tmp25_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp25_ == 3);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_retain_all (CollectionTests* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* dummy;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	gint _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gint _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	gint _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	gint _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp0_;
	_tmp1_ = gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp1_);
	_tmp2_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp2_);
	_tmp3_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add (self->test_collection, "hello1");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add (self->test_collection, "hello2");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp7_);
	_tmp8_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	g_assert (_tmp8_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp9_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp9_);
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp10_);
	_tmp11_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp12_);
	_tmp13_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp13_);
	_tmp14_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp14_ == 3);
	_tmp15_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp15_);
	_tmp16_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp16_);
	_tmp17_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp17_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp18_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp18_);
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp19_);
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp20_);
	_tmp21_ = gee_collection_add (self->test_collection, "hello4");
	g_assert (_tmp21_);
	_tmp22_ = gee_collection_add (self->test_collection, "hello5");
	g_assert (_tmp22_);
	_tmp23_ = gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp23_);
	_tmp24_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp24_);
	_tmp25_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp25_ == 3);
	_tmp26_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp26_);
	_tmp27_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp27_);
	_tmp28_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp28_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp29_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp29_);
	_tmp30_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp30_);
	_tmp31_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp31_);
	_tmp32_ = gee_collection_add (self->test_collection, "hello1");
	g_assert (_tmp32_);
	_tmp33_ = gee_collection_add (self->test_collection, "hello2");
	g_assert (_tmp33_);
	_tmp34_ = gee_collection_add (self->test_collection, "hello3");
	g_assert (_tmp34_);
	_tmp35_ = gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (!_tmp35_);
	_tmp36_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp36_ == 3);
	_tmp37_ = gee_collection_contains (self->test_collection, "hello1");
	g_assert (_tmp37_);
	_tmp38_ = gee_collection_contains (self->test_collection, "hello2");
	g_assert (_tmp38_);
	_tmp39_ = gee_collection_contains (self->test_collection, "hello3");
	g_assert (_tmp39_);
	_tmp40_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp40_ == 3);
	_tmp41_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp41_);
	_tmp42_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp42_);
	_tmp43_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp43_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp44_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp44_);
	_tmp45_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp45_);
	_tmp46_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp46_);
	_tmp47_ = gee_collection_add (self->test_collection, "hello2");
	g_assert (_tmp47_);
	_tmp48_ = gee_collection_add (self->test_collection, "hello3");
	g_assert (_tmp48_);
	_tmp49_ = gee_collection_add (self->test_collection, "hello4");
	g_assert (_tmp49_);
	_tmp50_ = gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy);
	g_assert (_tmp50_);
	_tmp51_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp51_ == 2);
	_tmp52_ = gee_collection_contains (self->test_collection, "hello2");
	g_assert (_tmp52_);
	_tmp53_ = gee_collection_contains (self->test_collection, "hello3");
	g_assert (_tmp53_);
	_tmp54_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp54_ == 3);
	_tmp55_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp55_);
	_tmp56_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp56_);
	_tmp57_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp57_);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_to_array (CollectionTests* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gpointer* _tmp5_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gint index;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	_tmp0_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add (self->test_collection, "hello1");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add (self->test_collection, "hello2");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add (self->test_collection, "hello3");
	g_assert (_tmp3_);
	_tmp5_ = gee_collection_to_array (self->test_collection, &_tmp4_);
	array = (gchar**) _tmp5_;
	array_length1 = _tmp4_;
	_array_size_ = _tmp4_;
	index = 0;
	{
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _element_it;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) self->test_collection);
		_element_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			gchar* element;
			gint _tmp9_;
			_tmp7_ = gee_iterator_next (_element_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_element_it);
			element = (gchar*) _tmp8_;
			_tmp9_ = index;
			index = _tmp9_ + 1;
			g_assert (g_strcmp0 (element, array[_tmp9_]) == 0);
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_gobject_properties (CollectionTests* self) {
	GValue value = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GType _tmp3_;
	GType _tmp4_;
	GValue _tmp5_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	g_value_init (&_tmp0_, G_TYPE_GTYPE);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp2_;
	g_object_get_property ((GObject*) self->test_collection, "element-type", &value);
	_tmp3_ = g_value_get_gtype (&value);
	_tmp4_ = gee_iterable_get_element_type ((GeeIterable*) self->test_collection);
	g_assert (_tmp3_ == _tmp4_);
	g_value_unset (&value);
	g_value_init (&_tmp5_, G_TYPE_BOOLEAN);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp7_;
	g_object_get_property ((GObject*) self->test_collection, "is-empty", &value);
	_tmp8_ = g_value_get_boolean (&value);
	_tmp9_ = gee_collection_get_is_empty (self->test_collection);
	g_assert (_tmp8_ == _tmp9_);
	g_value_unset (&value);
	g_value_init (&_tmp10_, G_TYPE_INT);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp12_;
	g_object_get_property ((GObject*) self->test_collection, "size", &value);
	_tmp13_ = g_value_get_int (&value);
	_tmp14_ = gee_collection_get_size (self->test_collection);
	g_assert (_tmp13_ == _tmp14_);
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


static void collection_tests_class_init (CollectionTestsClass * klass) {
	collection_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = collection_tests_finalize;
}


static void collection_tests_instance_init (CollectionTests * self) {
}


static void collection_tests_finalize (GObject* obj) {
	CollectionTests * self;
	self = COLLECTION_TESTS (obj);
	_g_object_unref0 (self->test_collection);
	G_OBJECT_CLASS (collection_tests_parent_class)->finalize (obj);
}


GType collection_tests_get_type (void) {
	static volatile gsize collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CollectionTests), 0, (GInstanceInitFunc) collection_tests_instance_init, NULL };
		GType collection_tests_type_id;
		collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "CollectionTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&collection_tests_type_id__volatile, collection_tests_type_id);
	}
	return collection_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



