/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ParametersWidgetBase.h"

#ifndef _QTGTL_PARAMETERS_WIDGET_P_H_
#define _QTGTL_PARAMETERS_WIDGET_P_H_

#include <QMap>
#include <GTLCore/String.h>

class QGridLayout;

namespace GTLCore {
  class String;
  class Value;
  namespace Metadata {
    class ParameterEntry;
    class Group;
  }
}

namespace QtShiva {
  class Proxy;
  class ParametersWidgetBase::Parametrisation {
    friend class ParametersWidgetBase;
    public:
      virtual const GTLCore::Metadata::Group* parameters() const = 0;
      virtual const GTLCore::String& name() const = 0;
      virtual void setParameter( const GTLCore::String& _name, GTLCore::Value ) = 0;
    protected:
      ParametersWidgetBase::Private* p;
  };

  class ParametersWidgetBase::Private : public QObject {
      Q_OBJECT
    public:
      Private() : parametrisation(0), self(0), currentWidget(0) {}
      Parametrisation* parametrisation;
      QWidget* self;
      QWidget* currentWidget;
      QGridLayout* selfLayout;
      // Functions
      void regenerateWidget();
      QMap<GTLCore::String, Proxy*> proxies;
    private:
      void createParameterEntryWidget( QWidget* _parent, QGridLayout* _gridLayout, int _layoutIndex, const GTLCore::Metadata::ParameterEntry* _parameterEntry );
  };
}

#endif
