#!/bin/sh
# Run this to generate all the initial makefiles, etc.

if test "z$1" = "z--clean"; then
    echo "Cleaning"

    rm -Rf autom4te.cache
    rm -f missing install-sh mkinstalldirs libtool ltmain.sh
    exit 1;
fi

old_args=""
if test $# -eq 0 && test -f config.log; then
    old_args=`perl -e 'while(<>) { if( /\\s+\\$ .\\/configure/ ) { s/.*configure //; s/(["'"'"'])/\\\\$1/g; s/=(([^-"'"'"' ]|-[^- ])*)( |$)/="$1" /g; print $_; } }' config.log`
    echo "re-using arguments from last configure: $old_args";
fi

touch ChangeLog

if test "z$ACLOCAL_FLAGS" = "z" -a "z`uname -s`" = "zDarwin" ; then
    ACLOCAL_FLAGS="-I ./m4/mac"
fi
if test "z`uname -s`" != "zDarwin" ; then
    AUTOMAKE_EXTRA_FLAGS=--warnings=no-portability
fi
aclocal $ACLOCAL_FLAGS || exit 1;
automake --gnu --add-missing --copy $AUTOMAKE_EXTRA_FLAGS || exit 1;
# intltoolize --copy --force --automake
autoconf || exit 1;
if test "x$NOCONFIGURE" = "x"; then
    if test -n "$old_args" ; then
        eval `echo ./configure $old_args`
    else
        ./configure --enable-maintainer-mode "$@"
    fi
else
    echo "Skipping configure process."
fi

# prepare git hooks
if [ -d .git ] ; then
    for file in `cd git-hooks ; echo *`
    do
        hook=".git/hooks/$file"
        if [ ! -x "$hook" -a ! -L "$hook" ] ; then
            rm -f "$hook"
            ln -s "../../git-hooks/$file" "$hook"
        fi
    done
fi
