/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef FORMULA_OPCODE_HXX
#define FORMULA_OPCODE_HXX

#include "formula/compiler.hrc"                     // OpCodes
#include <tools/solar.h>

enum OpCodeEnum
{
    // Special commands
        ocPush              = SC_OPCODE_PUSH,
        ocCall              = SC_OPCODE_CALL,
        ocStop              = SC_OPCODE_STOP,
        ocExternal          = SC_OPCODE_EXTERNAL,
        ocName              = SC_OPCODE_NAME,
        ocExternalRef       = SC_OPCODE_EXTERNAL_REF,
    // Jump commands
        ocIf                = SC_OPCODE_IF,
        ocChose             = SC_OPCODE_CHOSE,
    // Parentheses and separators
        ocOpen              = SC_OPCODE_OPEN,
        ocClose             = SC_OPCODE_CLOSE,
        ocSep               = SC_OPCODE_SEP,
        ocArrayOpen         = SC_OPCODE_ARRAY_OPEN,
        ocArrayClose        = SC_OPCODE_ARRAY_CLOSE,
        ocArrayRowSep       = SC_OPCODE_ARRAY_ROW_SEP,
        ocArrayColSep       = SC_OPCODE_ARRAY_COL_SEP,
    // Special OpCodes
        ocMissing           = SC_OPCODE_MISSING,
        ocBad               = SC_OPCODE_BAD,
        ocStringXML         = SC_OPCODE_STRINGXML,
        ocSpaces            = SC_OPCODE_SPACES,
        ocMatRef            = SC_OPCODE_MAT_REF,
        ocSkip              = SC_OPCODE_SKIP,
    // Access commands
        ocDBArea            = SC_OPCODE_DB_AREA,
        ocMacro             = SC_OPCODE_MACRO,
        ocColRowName        = SC_OPCODE_COL_ROW_NAME,
        ocColRowNameAuto    = SC_OPCODE_COL_ROW_NAME_AUTO,
    // Percent operator _follows_ value
        ocPercentSign       = SC_OPCODE_PERCENT_SIGN,
    // Error constants
        ocErrNull           = SC_OPCODE_ERROR_NULL,
        ocErrDivZero        = SC_OPCODE_ERROR_DIVZERO,
        ocErrValue          = SC_OPCODE_ERROR_VALUE,
        ocErrRef            = SC_OPCODE_ERROR_REF,
        ocErrName           = SC_OPCODE_ERROR_NAME,
        ocErrNum            = SC_OPCODE_ERROR_NUM,
        ocErrNA             = SC_OPCODE_ERROR_NA,
    // Binary operators
        ocAdd               = SC_OPCODE_ADD,
        ocSub               = SC_OPCODE_SUB,
        ocMul               = SC_OPCODE_MUL,
        ocDiv               = SC_OPCODE_DIV,
        ocAmpersand         = SC_OPCODE_AMPERSAND,
        ocPow               = SC_OPCODE_POW,
        ocEqual             = SC_OPCODE_EQUAL,
        ocNotEqual          = SC_OPCODE_NOT_EQUAL,
        ocLess              = SC_OPCODE_LESS,
        ocGreater           = SC_OPCODE_GREATER,
        ocLessEqual         = SC_OPCODE_LESS_EQUAL,
        ocGreaterEqual      = SC_OPCODE_GREATER_EQUAL,
        ocAnd               = SC_OPCODE_AND,
        ocOr                = SC_OPCODE_OR,
        ocXor               = SC_OPCODE_XOR,
        ocIntersect         = SC_OPCODE_INTERSECT,
        ocUnion             = SC_OPCODE_UNION,
        ocRange             = SC_OPCODE_RANGE,
    // Unary operators
        ocNot               = SC_OPCODE_NOT,
        ocNeg               = SC_OPCODE_NEG,
        ocNegSub            = SC_OPCODE_NEG_SUB,
    // Functions with no parameters
        ocPi                = SC_OPCODE_PI,
        ocRandom            = SC_OPCODE_RANDOM,
        ocTrue              = SC_OPCODE_TRUE,
        ocFalse             = SC_OPCODE_FALSE,
        ocGetActDate        = SC_OPCODE_GET_ACT_DATE,
        ocGetActTime        = SC_OPCODE_GET_ACT_TIME,
        ocNotAvail          = SC_OPCODE_NO_VALUE,
        ocCurrent           = SC_OPCODE_CURRENT,
    // Functions with one parameter
        ocDeg               = SC_OPCODE_DEG,
        ocRad               = SC_OPCODE_RAD,
        ocSin               = SC_OPCODE_SIN,
        ocCos               = SC_OPCODE_COS,
        ocTan               = SC_OPCODE_TAN,
        ocCot               = SC_OPCODE_COT,
        ocArcSin            = SC_OPCODE_ARC_SIN,
        ocArcCos            = SC_OPCODE_ARC_COS,
        ocArcTan            = SC_OPCODE_ARC_TAN,
        ocArcCot            = SC_OPCODE_ARC_COT,
        ocSinHyp            = SC_OPCODE_SIN_HYP,
        ocCosHyp            = SC_OPCODE_COS_HYP,
        ocTanHyp            = SC_OPCODE_TAN_HYP,
        ocCotHyp            = SC_OPCODE_COT_HYP,
        ocArcSinHyp         = SC_OPCODE_ARC_SIN_HYP,
        ocArcCosHyp         = SC_OPCODE_ARC_COS_HYP,
        ocArcTanHyp         = SC_OPCODE_ARC_TAN_HYP,
        ocArcCotHyp         = SC_OPCODE_ARC_COT_HYP,
        ocCosecant          = SC_OPCODE_COSECANT,
        ocSecant            = SC_OPCODE_SECANT,
        ocCosecantHyp       = SC_OPCODE_COSECANT_HYP,
        ocSecantHyp         = SC_OPCODE_SECANT_HYP,
        ocExp               = SC_OPCODE_EXP,
        ocLn                = SC_OPCODE_LN,
        ocSqrt              = SC_OPCODE_SQRT,
        ocFact              = SC_OPCODE_FACT,
        ocGetYear           = SC_OPCODE_GET_YEAR,
        ocGetMonth          = SC_OPCODE_GET_MONTH,
        ocGetDay            = SC_OPCODE_GET_DAY,
        ocGetHour           = SC_OPCODE_GET_HOUR,
        ocGetMin            = SC_OPCODE_GET_MIN,
        ocGetSec            = SC_OPCODE_GET_SEC,
        ocPlusMinus         = SC_OPCODE_PLUS_MINUS,
        ocAbs               = SC_OPCODE_ABS,
        ocInt               = SC_OPCODE_INT,
        ocPhi               = SC_OPCODE_PHI,
        ocGauss             = SC_OPCODE_GAUSS,
        ocIsEmpty           = SC_OPCODE_IS_EMPTY,
        ocIsString          = SC_OPCODE_IS_STRING,
        ocIsNonString       = SC_OPCODE_IS_NON_STRING,
        ocIsLogical         = SC_OPCODE_IS_LOGICAL,
        ocType              = SC_OPCODE_TYPE,
        ocCell              = SC_OPCODE_CELL,
        ocIsRef             = SC_OPCODE_IS_REF,
        ocIsValue           = SC_OPCODE_IS_VALUE,
        ocIsFormula         = SC_OPCODE_IS_FORMULA,
        ocIsNA              = SC_OPCODE_IS_NV,
        ocIsErr             = SC_OPCODE_IS_ERR,
        ocIsError           = SC_OPCODE_IS_ERROR,
        ocIsEven            = SC_OPCODE_IS_EVEN,
        ocIsOdd             = SC_OPCODE_IS_ODD,
        ocN                 = SC_OPCODE_N,
    // String functions
        ocGetDateValue      = SC_OPCODE_GET_DATE_VALUE,
        ocGetTimeValue      = SC_OPCODE_GET_TIME_VALUE,
        ocCode              = SC_OPCODE_CODE,
        ocTrim              = SC_OPCODE_TRIM,
        ocUpper             = SC_OPCODE_UPPER,
        ocPropper           = SC_OPCODE_PROPPER,
        ocLower             = SC_OPCODE_LOWER,
        ocLen               = SC_OPCODE_LEN,
        ocT                 = SC_OPCODE_T,
        ocValue             = SC_OPCODE_VALUE,
        ocClean             = SC_OPCODE_CLEAN,
        ocChar              = SC_OPCODE_CHAR,
        ocLog10             = SC_OPCODE_LOG10,
        ocEven              = SC_OPCODE_EVEN,
        ocOdd               = SC_OPCODE_ODD,
        ocStdNormDist       = SC_OPCODE_STD_NORM_DIST,
        ocFisher            = SC_OPCODE_FISHER,
        ocFisherInv         = SC_OPCODE_FISHER_INV,
        ocSNormInv          = SC_OPCODE_S_NORM_INV,
        ocGammaLn           = SC_OPCODE_GAMMA_LN,
        ocGamma             = SC_OPCODE_GAMMA,
        ocErrorType         = SC_OPCODE_ERROR_TYPE,
        ocErrCell           = SC_OPCODE_ERR_CELL,
        ocFormula           = SC_OPCODE_FORMULA,
        ocArabic            = SC_OPCODE_ARABIC,
        ocInfo              = SC_OPCODE_INFO,
        ocBahtText          = SC_OPCODE_BAHTTEXT,
        ocJis               = SC_OPCODE_JIS,
        ocAsc               = SC_OPCODE_ASC,
        ocUnicode           = SC_OPCODE_UNICODE,
        ocUnichar           = SC_OPCODE_UNICHAR,
    // Functions with more than one parameters
        ocArcTan2           = SC_OPCODE_ARC_TAN_2,
        ocCeil              = SC_OPCODE_CEIL,
        ocFloor             = SC_OPCODE_FLOOR,
        ocRound             = SC_OPCODE_ROUND,
        ocRoundUp           = SC_OPCODE_ROUND_UP,
        ocRoundDown         = SC_OPCODE_ROUND_DOWN,
        ocTrunc             = SC_OPCODE_TRUNC,
        ocLog               = SC_OPCODE_LOG,
        ocPower             = SC_OPCODE_POWER,
        ocGCD               = SC_OPCODE_GGT,
        ocLCM               = SC_OPCODE_KGV,
        ocMod               = SC_OPCODE_MOD,
        ocSumProduct        = SC_OPCODE_SUM_PRODUCT,
        ocSumSQ             = SC_OPCODE_SUM_SQ,
        ocSumX2MY2          = SC_OPCODE_SUM_X2MY2,
        ocSumX2DY2          = SC_OPCODE_SUM_X2DY2,
        ocSumXMY2           = SC_OPCODE_SUM_XMY2,
        ocGetDate           = SC_OPCODE_GET_DATE,
        ocGetTime           = SC_OPCODE_GET_TIME,
        ocGetDiffDate       = SC_OPCODE_GET_DIFF_DATE,
        ocGetDiffDate360    = SC_OPCODE_GET_DIFF_DATE_360,
        ocGetDateDif        = SC_OPCODE_GET_DATEDIF,
        ocMin               = SC_OPCODE_MIN,
        ocMax               = SC_OPCODE_MAX,
        ocSum               = SC_OPCODE_SUM,
        ocProduct           = SC_OPCODE_PRODUCT,
        ocAverage           = SC_OPCODE_AVERAGE,
        ocCount             = SC_OPCODE_COUNT,
        ocCount2            = SC_OPCODE_COUNT_2,
        ocNPV               = SC_OPCODE_NBW,
        ocIRR               = SC_OPCODE_IKV,
        ocMIRR              = SC_OPCODE_MIRR,
        ocISPMT             = SC_OPCODE_ISPMT,
        ocVar               = SC_OPCODE_VAR,
        ocVarP              = SC_OPCODE_VAR_P,
        ocStDev             = SC_OPCODE_ST_DEV,
        ocStDevP            = SC_OPCODE_ST_DEV_P,
        ocB                 = SC_OPCODE_B,
        ocNormDist          = SC_OPCODE_NORM_DIST,
        ocExpDist           = SC_OPCODE_EXP_DIST,
        ocBinomDist         = SC_OPCODE_BINOM_DIST,
        ocPoissonDist       = SC_OPCODE_POISSON_DIST,
        ocKombin            = SC_OPCODE_KOMBIN,
        ocKombin2           = SC_OPCODE_KOMBIN_2,
        ocVariationen       = SC_OPCODE_VARIATIONEN,
        ocVariationen2      = SC_OPCODE_VARIATIONEN_2,
        ocBW                = SC_OPCODE_BW,
        ocDIA               = SC_OPCODE_DIA,
        ocGDA               = SC_OPCODE_GDA,
        ocGDA2              = SC_OPCODE_GDA_2,
        ocVBD               = SC_OPCODE_VBD,
        ocLaufz             = SC_OPCODE_LAUFZ,
        ocLIA               = SC_OPCODE_LIA,
        ocRMZ               = SC_OPCODE_RMZ,
        ocColumns           = SC_OPCODE_COLUMNS,
        ocRows              = SC_OPCODE_ROWS,
        ocColumn            = SC_OPCODE_COLUMN,
        ocRow               = SC_OPCODE_ROW,
        ocZGZ               = SC_OPCODE_ZGZ,
        ocZW                = SC_OPCODE_ZW,
        ocZZR               = SC_OPCODE_ZZR,
        ocZins              = SC_OPCODE_ZINS,
        ocZinsZ             = SC_OPCODE_ZINS_Z,
        ocKapz              = SC_OPCODE_KAPZ,
        ocKumZinsZ          = SC_OPCODE_KUM_ZINS_Z,
        ocKumKapZ           = SC_OPCODE_KUM_KAP_Z,
        ocEffektiv          = SC_OPCODE_EFFEKTIV,
        ocNominal           = SC_OPCODE_NOMINAL,
        ocSubTotal          = SC_OPCODE_SUB_TOTAL,
    // Database functions
        ocDBSum             = SC_OPCODE_DB_SUM,
        ocDBCount           = SC_OPCODE_DB_COUNT,
        ocDBCount2          = SC_OPCODE_DB_COUNT_2,
        ocDBAverage         = SC_OPCODE_DB_AVERAGE,
        ocDBGet             = SC_OPCODE_DB_GET,
        ocDBMax             = SC_OPCODE_DB_MAX,
        ocDBMin             = SC_OPCODE_DB_MIN,
        ocDBProduct         = SC_OPCODE_DB_PRODUCT,
        ocDBStdDev          = SC_OPCODE_DB_STD_DEV,
        ocDBStdDevP         = SC_OPCODE_DB_STD_DEV_P,
        ocDBVar             = SC_OPCODE_DB_VAR,
        ocDBVarP            = SC_OPCODE_DB_VAR_P,
    // Management functions
        ocIndirect          = SC_OPCODE_INDIRECT,
        ocIndirectXL        = SC_OPCODE_INDIRECT_XL,
        ocAddress           = SC_OPCODE_ADDRESS,
        ocAddressXL         = SC_OPCODE_ADDRESS_XL,
        ocMatch             = SC_OPCODE_MATCH,
        ocCountEmptyCells   = SC_OPCODE_COUNT_EMPTY_CELLS,
        ocCountIf           = SC_OPCODE_COUNT_IF,
        ocSumIf             = SC_OPCODE_SUM_IF,
        ocAverageIf         = SC_OPCODE_AVERAGE_IF,
        ocSumIfs            = SC_OPCODE_SUM_IFS,
        ocAverageIfs        = SC_OPCODE_AVERAGE_IFS,
        ocCountIfs          = SC_OPCODE_COUNT_IFS,
        ocLookup            = SC_OPCODE_LOOKUP,
        ocVLookup           = SC_OPCODE_V_LOOKUP,
        ocHLookup           = SC_OPCODE_H_LOOKUP,
        ocMultiArea         = SC_OPCODE_MULTI_AREA,
        ocOffset            = SC_OPCODE_OFFSET,
        ocIndex             = SC_OPCODE_INDEX,
        ocAreas             = SC_OPCODE_AREAS,
    // String functions
        ocCurrency          = SC_OPCODE_CURRENCY,
        ocReplace           = SC_OPCODE_REPLACE,
        ocFixed             = SC_OPCODE_FIXED,
        ocFind              = SC_OPCODE_FIND,
        ocExact             = SC_OPCODE_EXACT,
        ocLeft              = SC_OPCODE_LEFT,
        ocRight             = SC_OPCODE_RIGHT,
        ocSearch            = SC_OPCODE_SEARCH,
        ocMid               = SC_OPCODE_MID,
        ocText              = SC_OPCODE_TEXT,
        ocSubstitute        = SC_OPCODE_SUBSTITUTE,
        ocRept              = SC_OPCODE_REPT,
        ocConcat            = SC_OPCODE_CONCAT,
    // Matrix functions
        ocMatValue          = SC_OPCODE_MAT_VALUE,
        ocMatDet            = SC_OPCODE_MAT_DET,
        ocMatInv            = SC_OPCODE_MAT_INV,
        ocMatMult           = SC_OPCODE_MAT_MULT,
        ocMatTrans          = SC_OPCODE_MAT_TRANS,
        ocMatrixUnit        = SC_OPCODE_MATRIX_UNIT,
    // BackSolver
        ocBackSolver        = SC_OPCODE_BACK_SOLVER,
    // Statistical functions
        ocHypGeomDist       = SC_OPCODE_HYP_GEOM_DIST,
        ocLogNormDist       = SC_OPCODE_LOG_NORM_DIST,
        ocTDist             = SC_OPCODE_T_DIST,
        ocFDist             = SC_OPCODE_F_DIST,
        ocChiDist           = SC_OPCODE_CHI_DIST,
        ocChiSqDist         = SC_OPCODE_CHISQ_DIST,
        ocChiSqInv          = SC_OPCODE_CHISQ_INV,
        ocWeibull           = SC_OPCODE_WEIBULL,
        ocNegBinomVert      = SC_OPCODE_NEG_BINOM_VERT,
        ocKritBinom         = SC_OPCODE_KRIT_BINOM,
        ocKurt              = SC_OPCODE_KURT,
        ocHarMean           = SC_OPCODE_HAR_MEAN,
        ocGeoMean           = SC_OPCODE_GEO_MEAN,
        ocStandard          = SC_OPCODE_STANDARD,
        ocAveDev            = SC_OPCODE_AVE_DEV,
        ocSchiefe           = SC_OPCODE_SCHIEFE,
        ocDevSq             = SC_OPCODE_DEV_SQ,
        ocMedian            = SC_OPCODE_MEDIAN,
        ocModalValue        = SC_OPCODE_MODAL_VALUE,
        ocZTest             = SC_OPCODE_Z_TEST,
        ocTTest             = SC_OPCODE_T_TEST,
        ocRank              = SC_OPCODE_RANK,
        ocPercentile        = SC_OPCODE_PERCENTILE,
        ocPercentrank       = SC_OPCODE_PERCENT_RANK,
        ocLarge             = SC_OPCODE_LARGE,
        ocSmall             = SC_OPCODE_SMALL,
        ocFrequency         = SC_OPCODE_FREQUENCY,
        ocQuartile          = SC_OPCODE_QUARTILE,
        ocNormInv           = SC_OPCODE_NORM_INV,
        ocConfidence        = SC_OPCODE_CONFIDENCE,
        ocFTest             = SC_OPCODE_F_TEST,
        ocTrimMean          = SC_OPCODE_TRIM_MEAN,
        ocProb              = SC_OPCODE_PROB,
        ocCorrel            = SC_OPCODE_CORREL,
        ocCovar             = SC_OPCODE_COVAR,
        ocPearson           = SC_OPCODE_PEARSON,
        ocRSQ               = SC_OPCODE_RSQ,
        ocSTEYX             = SC_OPCODE_STEYX,
        ocSlope             = SC_OPCODE_SLOPE,
        ocIntercept         = SC_OPCODE_INTERCEPT,
        ocTrend             = SC_OPCODE_TREND,
        ocGrowth            = SC_OPCODE_GROWTH,
        ocRGP               = SC_OPCODE_RGP,
        ocRKP               = SC_OPCODE_RKP,
        ocForecast          = SC_OPCODE_FORECAST,
        ocChiInv            = SC_OPCODE_CHI_INV,
        ocGammaDist         = SC_OPCODE_GAMMA_DIST,
        ocGammaInv          = SC_OPCODE_GAMMA_INV,
        ocTInv              = SC_OPCODE_T_INV,
        ocFInv              = SC_OPCODE_F_INV,
        ocChiTest           = SC_OPCODE_CHI_TEST,
        ocLogInv            = SC_OPCODE_LOG_INV,
        ocTableOp           = SC_OPCODE_TABLE_OP,
        ocBetaDist          = SC_OPCODE_BETA_DIST,
        ocBetaInv           = SC_OPCODE_BETA_INV,
    // Bit functions
        ocBitAnd            = SC_OPCODE_BITAND,
        ocBitOr             = SC_OPCODE_BITOR,
        ocBitXor            = SC_OPCODE_BITXOR,
        ocBitRshift         = SC_OPCODE_BITRSHIFT,
        ocBitLshift         = SC_OPCODE_BITLSHIFT,
    // miscellaneous
        ocWeek              = SC_OPCODE_WEEK,
        ocGetDayOfWeek      = SC_OPCODE_GET_DAY_OF_WEEK,
        ocNoName            = SC_OPCODE_NO_NAME,
        ocStyle             = SC_OPCODE_STYLE,
        ocDde               = SC_OPCODE_DDE,
        ocBase              = SC_OPCODE_BASE,
        ocTable             = SC_OPCODE_TABLE,
        ocTables            = SC_OPCODE_TABLES,
        ocMinA              = SC_OPCODE_MIN_A,
        ocMaxA              = SC_OPCODE_MAX_A,
        ocAverageA          = SC_OPCODE_AVERAGE_A,
        ocStDevA            = SC_OPCODE_ST_DEV_A,
        ocStDevPA           = SC_OPCODE_ST_DEV_P_A,
        ocVarA              = SC_OPCODE_VAR_A,
        ocVarPA             = SC_OPCODE_VAR_P_A,
        ocEasterSunday      = SC_OPCODE_EASTERSUNDAY,
        ocDecimal           = SC_OPCODE_DECIMAL,
        ocConvert           = SC_OPCODE_CONVERT,
        ocRoman             = SC_OPCODE_ROMAN,
        ocHyperLink         = SC_OPCODE_HYPERLINK,
        ocGetPivotData      = SC_OPCODE_GET_PIVOT_DATA,
        ocEuroConvert       = SC_OPCODE_EUROCONVERT,
        ocNumberValue       = SC_OPCODE_NUMBERVALUE,
    // internal stuff
        ocInternalBegin     = SC_OPCODE_INTERNAL_BEGIN,
        ocTTT               = SC_OPCODE_TTT,
        ocInternalEnd       = SC_OPCODE_INTERNAL_END,
    // from here on ExtraData
        ocDataToken1        = SC_OPCODE_DATA_TOKEN_1,
    // no OpCode
        ocNone              = SC_OPCODE_NONE
};

#ifndef DBG_UTIL
// save memory since compilers tend to int an enum
typedef sal_uInt16 OpCode;
#else
// have enum names in debugger
typedef OpCodeEnum OpCode;
#endif

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
