/* unity-place-activation.c generated by valac 0.12.0, the Vala compiler
 * generated from unity-place-activation.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * We want the generatedd C API to be nice and not too Vala-ish. We must
 * anticipate that place daemons consuming libunity will be written in
 * both Vala and C.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define UNITY_TYPE_ACTIVATION (unity_activation_get_type ())
#define UNITY_ACTIVATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_ACTIVATION, UnityActivation))
#define UNITY_IS_ACTIVATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_ACTIVATION))
#define UNITY_ACTIVATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_ACTIVATION, UnityActivationIface))

typedef struct _UnityActivation UnityActivation;
typedef struct _UnityActivationIface UnityActivationIface;

#define UNITY_TYPE_ACTIVATION_PROXY (unity_activation_proxy_get_type ())
typedef GDBusProxy UnityActivationProxy;
typedef GDBusProxyClass UnityActivationProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_TYPE_ACTIVATION_STATUS (unity_activation_status_get_type ())

struct _UnityActivationIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityActivation* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32 (*activate_finish) (UnityActivation* self, GAsyncResult* _res_, GError** error);
};

typedef enum  {
	UNITY_ACTIVATION_STATUS_NOT_ACTIVATED,
	UNITY_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH,
	UNITY_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH
} UnityActivationStatus;



GType unity_activation_proxy_get_type (void) G_GNUC_CONST;
guint unity_activation_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_get_type (void) G_GNUC_CONST;
void unity_activation_activate (UnityActivation* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint32 unity_activation_activate_finish (UnityActivation* self, GAsyncResult* _res_, GError** error);
static void unity_activation_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void unity_activation_proxy_activate_async (UnityActivation* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static guint32 unity_activation_proxy_activate_finish (UnityActivation* self, GAsyncResult* _res_, GError** error);
static void unity_activation_proxy_unity_activation_interface_init (UnityActivationIface* iface);
static void _dbus_unity_activation_activate (UnityActivation* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_activation_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_activation_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_activation_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_activation_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _unity_activation_unregister_object (gpointer user_data);
GType unity_activation_status_get_type (void) G_GNUC_CONST;

static const GDBusArgInfo _unity_activation_dbus_arg_info_activate_uri = {-1, "uri", "s"};
static const GDBusArgInfo _unity_activation_dbus_arg_info_activate_result = {-1, "result", "u"};
static const GDBusArgInfo * const _unity_activation_dbus_arg_info_activate_in[] = {&_unity_activation_dbus_arg_info_activate_uri, NULL};
static const GDBusArgInfo * const _unity_activation_dbus_arg_info_activate_out[] = {&_unity_activation_dbus_arg_info_activate_result, NULL};
static const GDBusMethodInfo _unity_activation_dbus_method_info_activate = {-1, "Activate", (GDBusArgInfo **) (&_unity_activation_dbus_arg_info_activate_in), (GDBusArgInfo **) (&_unity_activation_dbus_arg_info_activate_out)};
static const GDBusMethodInfo * const _unity_activation_dbus_method_info[] = {&_unity_activation_dbus_method_info_activate, NULL};
static const GDBusSignalInfo * const _unity_activation_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _unity_activation_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_activation_dbus_interface_info = {-1, "com.canonical.Unity.Activation", (GDBusMethodInfo **) (&_unity_activation_dbus_method_info), (GDBusSignalInfo **) (&_unity_activation_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_activation_dbus_property_info)};
static const GDBusInterfaceVTable _unity_activation_dbus_interface_vtable = {unity_activation_dbus_interface_method_call, unity_activation_dbus_interface_get_property, unity_activation_dbus_interface_set_property};

void unity_activation_activate (UnityActivation* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_ACTIVATION_GET_INTERFACE (self)->activate (self, uri, _callback_, _user_data_);
}


guint32 unity_activation_activate_finish (UnityActivation* self, GAsyncResult* _res_, GError** error) {
	return UNITY_ACTIVATION_GET_INTERFACE (self)->activate_finish (self, _res_, error);
}


static void unity_activation_base_init (UnityActivationIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
   * UnityPlaceActivation:
   *
   * Interface for async launching of URIs. Instances implementing
   * this interface can be registered with a Unity.Place.Controller by
   * calling set_activation (activation) on the controller object.
   */
GType unity_activation_get_type (void) {
	static volatile gsize unity_activation_type_id__volatile = 0;
	if (g_once_init_enter (&unity_activation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityActivationIface), (GBaseInitFunc) unity_activation_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_activation_type_id;
		unity_activation_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityActivation", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_activation_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_activation_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_activation_proxy_get_type);
		g_type_set_qdata (unity_activation_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.Unity.Activation");
		g_type_set_qdata (unity_activation_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_activation_register_object);
		g_once_init_leave (&unity_activation_type_id__volatile, unity_activation_type_id);
	}
	return unity_activation_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityActivationProxy, unity_activation_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_ACTIVATION, unity_activation_proxy_unity_activation_interface_init) )
static void unity_activation_proxy_class_init (UnityActivationProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_activation_proxy_g_signal;
}


static void unity_activation_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void unity_activation_proxy_init (UnityActivationProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void unity_activation_proxy_activate_async (UnityActivation* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Activation", "Activate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static guint32 unity_activation_proxy_activate_finish (UnityActivation* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result;
	GVariant* _tmp222_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return 0U;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0U;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp222_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp222_);
	g_variant_unref (_tmp222_);
	g_object_unref (_reply_message);
	return _result;
}


static void unity_activation_proxy_unity_activation_interface_init (UnityActivationIface* iface) {
	iface->activate = unity_activation_proxy_activate_async;
	iface->activate_finish = unity_activation_proxy_activate_finish;
}


static void _dbus_unity_activation_activate (UnityActivation* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp223_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp223_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp223_, NULL);
	g_variant_unref (_tmp223_);
	unity_activation_activate (self, uri, (GAsyncReadyCallback) _dbus_unity_activation_activate_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_unity_activation_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	invocation = _user_data_;
	result = unity_activation_activate_finish ((UnityActivation*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_activation_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Activate") == 0) {
		_dbus_unity_activation_activate (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_activation_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_activation_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint unity_activation_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_activation_dbus_interface_info), &_unity_activation_dbus_interface_vtable, data, _unity_activation_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _unity_activation_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
   * Enumeration of return values for Activation.activate().
   */
GType unity_activation_status_get_type (void) {
	static volatile gsize unity_activation_status_type_id__volatile = 0;
	if (g_once_init_enter (&unity_activation_status_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_ACTIVATION_STATUS_NOT_ACTIVATED, "UNITY_ACTIVATION_STATUS_NOT_ACTIVATED", "not-activated"}, {UNITY_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH, "UNITY_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH", "activated-show-dash"}, {UNITY_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH, "UNITY_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH", "activated-hide-dash"}, {0, NULL, NULL}};
		GType unity_activation_status_type_id;
		unity_activation_status_type_id = g_enum_register_static ("UnityActivationStatus", values);
		g_once_init_leave (&unity_activation_status_type_id__volatile, unity_activation_status_type_id);
	}
	return unity_activation_status_type_id__volatile;
}



