/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "nl-sidebar.h"

#include <glib.h>
#include <glib/gi18n.h>
#include <clutter-gtk/clutter-gtk.h>

#include "nl-sidebar-item.h"

G_DEFINE_TYPE (NlSidebar, nl_sidebar, CTK_TYPE_BOX);

#define NL_SIDEBAR_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  NL_TYPE_SIDEBAR, \
  NlSidebarPrivate))

struct _NlSidebarPrivate
{
  GSList *special_items;
  GSList *menu_items;
};

/* Forwards */
static gint sort_child_list (NlSidebarItem *a, NlSidebarItem *b);

/* GObject stuff */
static void
nl_sidebar_finalize (GObject *object)
{
  NlSidebarPrivate *priv;

  priv = NL_SIDEBAR_GET_PRIVATE (object);

  G_OBJECT_CLASS (nl_sidebar_parent_class)->finalize (object);
}

static gboolean
nl_sidebar_key_press_event (ClutterActor    *actor,
                            ClutterKeyEvent *event)
{
  CtkFocusEventType type;
  CtkFocusDirection direction;

  direction = CTK_FOCUS_DIR_NONE;
  type = ctk_focusable_get_event_type (event, &direction);

  if (type == CTK_FOCUS_EVENT_DIRECTION)
    {
      if (direction == CTK_FOCUS_DIR_NEXT
          || direction == CTK_FOCUS_DIR_PREV)
        {
          ClutterActor *parent = clutter_actor_get_parent (actor);

          return clutter_actor_event (parent, (ClutterEvent *)event, FALSE);
        }
    }
  return CLUTTER_ACTOR_CLASS
         (nl_sidebar_parent_class)->key_press_event (actor,
             event);
}

static void
nl_sidebar_class_init (NlSidebarClass *klass)
{
  GObjectClass      *obj_class = G_OBJECT_CLASS (klass);
  ClutterActorClass *act_class = CLUTTER_ACTOR_CLASS (klass);

  obj_class->finalize = nl_sidebar_finalize;

  act_class->key_press_event = nl_sidebar_key_press_event;

  g_type_class_add_private (obj_class, sizeof (NlSidebarPrivate));
}

static void
on_actor_added (ClutterContainer *container, ClutterActor *actor)
{
  ctk_box_sort_children (CTK_BOX (container),
                         (GCompareFunc)sort_child_list);
}

static void
nl_sidebar_init (NlSidebar *sidebar)
{
  NlSidebarPrivate *priv;

  priv = sidebar->priv = NL_SIDEBAR_GET_PRIVATE (sidebar);

  g_signal_connect (sidebar, "actor-added",
                    G_CALLBACK (on_actor_added), NULL);
}

/*
 * Public methods
 */
ClutterActor *
nl_sidebar_new (void)

{
  ClutterActor *sidebar = NULL;

  sidebar = g_object_new (NL_TYPE_SIDEBAR,
                          "spacing", 0,
                          "homogeneous", FALSE,
                          "orientation", CTK_ORIENTATION_VERTICAL,
                          NULL);
  return sidebar;
}

/*
 * Private methods
 */

static gint
sort_child_list (NlSidebarItem *a, NlSidebarItem *b)
{
  if (G_UNLIKELY (a == b))
    return 0;
  if (!NL_IS_SIDEBAR_ITEM (a))
    return -1;
  if (!NL_IS_SIDEBAR_ITEM (b))
    return 1;

  return nl_sidebar_item_get_pos (a) - nl_sidebar_item_get_pos (b);
}

