/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_APP_H_
#define _NL_APP_H_

#include <glib.h>
#include <unique/unique.h>

#define NL_TYPE_APP (nl_app_get_type ())

#define NL_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_APP, NlApp))

#define NL_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_APP, NlAppClass))

#define NL_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_APP))

#define NL_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_APP))

#define NL_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_APP, NlAppClass))

typedef struct _NlApp        NlApp;
typedef struct _NlAppClass   NlAppClass;
typedef struct _NlAppPrivate NlAppPrivate;
 
struct _NlApp
{
  UniqueApp     parent;	

  NlAppPrivate *priv;
};

struct _NlAppClass
{
  UniqueAppClass   parent_class;
};

enum
{
  COMMAND_0,

  COMMAND_ADD_FAVORITE,
  
  COMMAND_SHOW_FAVORITES,
};

GType nl_app_get_type (void) G_GNUC_CONST;

NlApp * nl_app_get_default (void);

void    nl_app_init_real   (NlApp *app);

#endif /* _NL_APP_H_ */

