/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_SIDEBAR_SCROLLBUTTON_H_
#define _NL_SIDEBAR_SCROLLBUTTON_H_

#include <glib.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutk/clutk.h>

#define NL_TYPE_SIDEBAR_SCROLLBUTTON (nl_sidebar_scrollbutton_get_type ())

#define NL_SIDEBAR_SCROLLBUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_SIDEBAR_SCROLLBUTTON, NlSidebarScrollbutton))

#define NL_SIDEBAR_SCROLLBUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_SIDEBAR_SCROLLBUTTON, NlSidebarScrollbuttonClass))

#define NL_IS_SIDEBAR_SCROLLBUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_SIDEBAR_SCROLLBUTTON))

#define NL_IS_SIDEBAR_SCROLLBUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_SIDEBAR_SCROLLBUTTON))

#define NL_SIDEBAR_SCROLLBUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_SIDEBAR_SCROLLBUTTON, NlSidebarScrollbuttonClass))

typedef struct _NlSidebarScrollbutton        NlSidebarScrollbutton;
typedef struct _NlSidebarScrollbuttonClass   NlSidebarScrollbuttonClass;
typedef struct _NlSidebarScrollbuttonPrivate NlSidebarScrollbuttonPrivate;
 
struct _NlSidebarScrollbutton
{
  CtkButton        parent;	

  NlSidebarScrollbuttonPrivate *priv;
};

struct _NlSidebarScrollbuttonClass
{
  CtkButtonClass   parent_class;
};

typedef enum
{
  NL_ARROW_UP=0,
  NL_ARROW_DOWN
} NlArrowType;

GType          nl_sidebar_scrollbutton_get_type (void) G_GNUC_CONST;

ClutterActor * nl_sidebar_scrollbutton_new (NlArrowType    type,
                                            CtkScrollView *view);

G_END_DECLS

#endif /* _NL_SIDEBAR_SCROLLBUTTON_H_ */
