/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_URI_LOADER_H_
#define _NL_URI_LOADER_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <netbook-launcher/nl-shell.h>
#include <netbook-launcher/nl-favorites-loader.h>

#define NL_TYPE_URI_LOADER (nl_uri_loader_get_type ())

#define NL_URI_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_URI_LOADER, NlUriLoader))

#define NL_URI_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_URI_LOADER, NlUriLoaderClass))

#define NL_IS_URI_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_URI_LOADER))

#define NL_IS_URI_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_URI_LOADER))

#define NL_URI_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_URI_LOADER, NlUriLoaderClass))

typedef struct _NlUriLoader        NlUriLoader;
typedef struct _NlUriLoaderClass   NlUriLoaderClass;
typedef struct _NlUriLoaderPrivate NlUriLoaderPrivate;
 
struct _NlUriLoader
{
  NlFavoritesLoader parent;	

  NlUriLoaderPrivate *priv;
};

struct _NlUriLoaderClass
{
  NlFavoritesLoaderClass   parent_class;
};

GType     nl_uri_loader_get_type   (void) G_GNUC_CONST;

GObject * nl_uri_loader_new        (NlShell *s);

#endif /* _NL_URI_LOADER_H_ */

