#ifndef SCREEM_SITE_H
#define SCREEM_SITE_H

#include <glib.h>

#include <gtk/gtktreemodel.h>
#include <gtk/gtktreestore.h>
#include <gtk/gtktreeview.h>

#include "screem-page.h"

#define SCREEM_TYPE_SITE            (screem_site_get_type ())
#define SCREEM_SITE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_SITE, ScreemSite))
#define SCREEM_SITE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_SITE, ScreemSiteClass))
#define SCREEM_IS_SITE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_SITE))

typedef enum {
        PERMS_EXEC = 0,
        PERMS_IGNORE = 1,
        PERMS_ALL = 2
} ScreemSitePerms;

typedef enum  {
        SYM_FOLLOW = 0,
        SYM_IGNORE = 1,
        SYM_MAINTAIN =2
} ScreemSiteSymlinks;

typedef enum  {
        LOCAL = 0,
        FTP = 1,
	DAV = 2,
	SSH = 3,
	UPLOAD_OTHER = 5
} UploadMethods;

/* These are defined in screem-site.c */
extern const gchar *permission_strings[];
extern const gchar *symlink_strings[];
extern const gchar *upload_strings[];
extern const gchar *upload_schemes[];

typedef struct ScreemSitePrivate ScreemSitePrivate;


typedef struct {
        GObject parent;
     
	ScreemSitePrivate *priv;
} ScreemSite;

typedef struct {
        GObjectClass parent_class;

		void (*ctags_running)( ScreemSite *site );
} ScreemSiteClass;

GType       screem_site_get_type(void);
ScreemSite* screem_site_new( GObject *application );

void screem_site_set_name( ScreemSite *site, const gchar *name );
const gchar* screem_site_get_name( ScreemSite *site );

void screem_site_set_pathname( ScreemSite *site, const gchar *pathname );
const gchar* screem_site_get_pathname( ScreemSite *site );

void screem_site_set_preview_static( ScreemSite *site, gboolean flag );
gboolean screem_site_get_preview_static( ScreemSite *site );

void screem_site_set_preview_dynamic( ScreemSite *site, gboolean flag );
gboolean screem_site_get_preview_dynamic( ScreemSite *site );

void screem_site_set_remote_url( ScreemSite *site, const gchar *remote_url );
const gchar* screem_site_get_remote_url( ScreemSite *site );

void screem_site_set_remote_method( ScreemSite *site, UploadMethods method );
UploadMethods screem_site_get_remote_method( ScreemSite *site );

void screem_site_set_remote_path( ScreemSite *site, const gchar *remote_path );
const gchar* screem_site_get_remote_path( ScreemSite *site );

void screem_site_set_remote_user( ScreemSite *site, const gchar *remote_user );
const gchar* screem_site_get_remote_user( ScreemSite *site );

void screem_site_set_remote_pass( ScreemSite *site, const gchar *remote_pass );
const gchar* screem_site_get_remote_pass( ScreemSite *site );

void screem_site_set_cvs_root( ScreemSite *site, const gchar *cvs_root );
const gchar* screem_site_get_cvs_root( ScreemSite *site );
void screem_site_set_auto_update_ask( ScreemSite *site, gboolean value );
gboolean screem_site_get_auto_update_ask( ScreemSite *site );
void screem_site_set_auto_update( ScreemSite *site, gboolean value );
gboolean screem_site_get_auto_update( ScreemSite *site );

void screem_site_set_use_ctags( ScreemSite *site, gboolean flag );
gboolean screem_site_get_use_ctags( const ScreemSite *site );
void screem_site_update_ctags_file( ScreemSite *site );

void screem_site_set_site_template( ScreemSite *site,
				    const gchar *path );
const gchar *screem_site_get_site_template( ScreemSite *site );

void screem_site_set_template_path( ScreemSite *site, const gchar *template_path );
const gchar* screem_site_get_template_path( ScreemSite *site );

void screem_site_set_http_url( ScreemSite *site, const gchar *http_url );
const gchar* screem_site_get_http_url( ScreemSite *site );

gboolean screem_site_get_fake_flag( ScreemSite *site );

void screem_site_set_no_delete( ScreemSite *site, gboolean flag );
gboolean screem_site_get_no_delete( ScreemSite *site );

void screem_site_set_check_moved( ScreemSite *site, gboolean flag );
gboolean screem_site_get_check_moved( ScreemSite *site );

void screem_site_set_no_overwrite( ScreemSite *site, gboolean flag );
gboolean screem_site_get_no_overwrite( ScreemSite *site );

void screem_site_set_permissions( ScreemSite *site, ScreemSitePerms permissions );
ScreemSitePerms screem_site_get_permissions( ScreemSite *site );

void screem_site_set_symlinks( ScreemSite *site, ScreemSiteSymlinks symlinks );
ScreemSiteSymlinks screem_site_get_symlinks( ScreemSite *site );

void screem_site_set_is_import( ScreemSite *site, gboolean val );
gboolean screem_site_get_is_import( ScreemSite *site );

gboolean screem_site_is_excluded( ScreemSite *site, const gchar *path );
void screem_site_add_exclude( ScreemSite *site, const gchar *pattern );
void screem_site_remove_exclude( ScreemSite *site, const gchar *pattern );

gboolean screem_site_is_ignored( ScreemSite *site, const gchar *path );
void screem_site_add_ignore( ScreemSite *site, const gchar *patterm );
void screem_site_remove_ignore( ScreemSite *site, const gchar *pattern );

void screem_site_save( ScreemSite *site );
gboolean screem_site_create( ScreemSite *site );
gboolean screem_site_load( ScreemSite *site );
gboolean screem_site_write_project_file( ScreemSite *site );
gboolean screem_site_parse_project_file( ScreemSite *site, 
					 const gchar *filename );

ScreemPage* screem_site_locate_page( ScreemSite *site, const gchar *path );
gboolean screem_site_add_page( ScreemSite *site, ScreemPage *page );
void screem_site_remove_page_with_path( ScreemSite *site, const gchar *path );
void screem_site_remove_page( ScreemSite *site, ScreemPage *page );

/* use screem_site_foreach_page() in preference to
 * screem_site_get_pages() as the later builds a new list while
 * the foreach method just goes through each item in a hash table,
 * and takes notice of excludes / ignores if required*/

GList *screem_site_get_pages( ScreemSite *site, gboolean excludes,
		gboolean ignores );
void screem_site_foreach_page( ScreemSite *site,
		GFunc func, gboolean excludes, gboolean ignores,
		gpointer user_data );

GObject *screem_site_get_todo( ScreemSite *site );

void screem_site_file_change( ScreemSite *site, const gchar *src,
			      const gchar *dest );

/* not too happy on this one */
void screem_site_set_documents( ScreemSite *site, const gchar *name, GList *list );
GList* screem_site_get_documents( ScreemSite *site, const gchar *name );

GList* screem_site_get_excludes( ScreemSite *site );
GList* screem_site_get_ignores( ScreemSite *site );

/* function pointer type for getting the file upload status' from
   the upload wizard */
typedef gboolean(*SiteSyncState)( ScreemSite *site, GHashTable **table );

gchar *screem_get_local_site_path( ScreemSite *site );

#endif
