var targetGroup = -1;
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);

var addGroupBundle;

var backgroundImageStyle = '';
var advancedStyle = '';
var font = '';
var minimumWidth = 0;
var minimumHeight = 0;
var maximumWidth = 0;
var maximumHeight = 0;
var widthModifier = 0;
var heightModifier = 0;
var widthModifierType = 0;
var heightModifierType = 0;

function Startup() {
  // Set variables
  targetGroup = parseInt(window.arguments[0]);
  addGroupBundle = document.getElementById("bundle_editGroup");
  
  if (targetGroup < 0) {
    // Adding group, set correct title
    document.title = addGroupBundle.getString("addGroupTitle");
    document.getElementById("backgroundColor").color = "#CCCCCC";
    document.getElementById("textColor").color = "#000000";
    document.getElementById("useCustomColors").checked = false;
    document.getElementById("rows").value = gPref.getIntPref("extensions.speeddial.rows");
    document.getElementById("columns").value = gPref.getIntPref("extensions.speeddial.columns");
    document.getElementById("hideUnused").checked = false;
    minimumWidth = gPref.getIntPref("extensions.speeddial.minimumWidth");
    minimumHeight = gPref.getIntPref("extensions.speeddial.minimumHeight");
    maximumWidth = gPref.getIntPref("extensions.speeddial.maximumWidth");
    maximumHeight = gPref.getIntPref("extensions.speeddial.maximumHeight");
    widthModifier = gPref.getIntPref("extensions.speeddial.widthModifier");
    heightModifier = gPref.getIntPref("extensions.speeddial.heightModifier");
    widthModifierType = gPref.getIntPref("extensions.speeddial.widthModifierType");
    heightModifierType = gPref.getIntPref("extensions.speeddial.heightModifierType");
  } else {
    // Prefill values
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-title")) {
      document.getElementById("title").value = gPref.getComplexValue("extensions.speeddial.group-" + targetGroup + "-title", Components.interfaces.nsISupportsString).data;
    }
    var useCustomColors = false;
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-backgroundColor")) {
      useCustomColors = true;
      document.getElementById("backgroundColor").color = gPref.getCharPref("extensions.speeddial.group-" + targetGroup + "-backgroundColor");
    } else {
      document.getElementById("backgroundColor").color = "#CCCCCC";
    }
    document.getElementById("backgroundColorText").value = document.getElementById("backgroundColor").color;
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-textColor")) {
      useCustomColors = true;
      document.getElementById("textColor").color = gPref.getCharPref("extensions.speeddial.group-" + targetGroup + "-textColor");
    } else {
      document.getElementById("textColor").color = "#000000";
    }
    document.getElementById("textColorText").value = document.getElementById("textColor").color;
    
    document.getElementById("useCustomColors").checked = useCustomColors;
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-rows")) {
      document.getElementById("rows").value = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-rows");
    } else {
      document.getElementById("rows").value = gPref.getIntPref("extensions.speeddial.rows");
    }
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-columns")) {
      document.getElementById("columns").value = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-columns");
    } else {
      document.getElementById("columns").value = gPref.getIntPref("extensions.speeddial.columns");
    }
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-backImage")) {
      backgroundImageStyle = gPref.getCharPref("extensions.speeddial.group-" + targetGroup + "-backImage");
    }
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-style")) {
      advancedStyle = gPref.getCharPref("extensions.speeddial.group-" + targetGroup + "-style");
    }
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-font")) {
      font = gPref.getCharPref("extensions.speeddial.group-" + targetGroup + "-font");
    }
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-hideUnused")) {
      document.getElementById("hideUnused").checked = gPref.getBoolPref("extensions.speeddial.group-" + targetGroup + "-hideUnused");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-minimumWidth")) {
      document.getElementById("customSize").checked = true;
      minimumWidth = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-minimumWidth");
      minimumHeight = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-minimumHeight");
      maximumWidth = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-maximumWidth");
      maximumHeight = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-maximumHeight");
      widthModifier = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-widthModifier");
      heightModifier = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-heightModifier");
      widthModifierType = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-widthModifierType");
      heightModifierType = gPref.getIntPref("extensions.speeddial.group-" + targetGroup + "-heightModifierType");
    } else {
      minimumWidth = gPref.getIntPref("extensions.speeddial.minimumWidth");
      minimumHeight = gPref.getIntPref("extensions.speeddial.minimumHeight");
      maximumWidth = gPref.getIntPref("extensions.speeddial.maximumWidth");
      maximumHeight = gPref.getIntPref("extensions.speeddial.maximumHeight");
      widthModifier = gPref.getIntPref("extensions.speeddial.widthModifier");
      heightModifier = gPref.getIntPref("extensions.speeddial.heightModifier");
      widthModifierType = gPref.getIntPref("extensions.speeddial.widthModifierType");
      heightModifierType = gPref.getIntPref("extensions.speeddial.heightModifierType");
    }
  }

  useCustomColorsChanged();
  customSizeChanged();
  
  sizeToContent();
}

function onOK(event) {
  var addingGroup = false;
  
  if (targetGroup < 0) {
    addingGroup = true;
    targetGroup = gPref.getIntPref("extensions.speeddial.numGroups") + 1;
  }
  
  var title = document.getElementById("title").value;
  var useCustomColors = document.getElementById("useCustomColors").checked;
  var textColor = document.getElementById("textColor").color;
  var backgroundColor = document.getElementById("backgroundColor").color;
  var rows = parseInt(document.getElementById("rows").value);
  var columns = parseInt(document.getElementById("columns").value);
  var hideUnused = document.getElementById("hideUnused").checked;
  var customSizeDefine = document.getElementById("customSize").checked;
  
  if (!SpeedDialUtils.checkNewGroupSizeFits(targetGroup, rows, columns)) {
    // Ask!!
    // TODO: fix this in Fennec
    if (!SpeedDialUtils.isFennec() && !confirm(addGroupBundle.getString("confirmShrinkGroup"))) {
      return false;
    }
  }
  
  if (title != "") {
    var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    str.data = title;
    gPref.setComplexValue("extensions.speeddial.group-" + targetGroup + "-title", Components.interfaces.nsISupportsString, str);
  } else if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-title")) {
    gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-title");
  }
  
  if (useCustomColors) {
    gPref.setCharPref("extensions.speeddial.group-" + targetGroup + "-textColor", textColor);
    gPref.setCharPref("extensions.speeddial.group-" + targetGroup + "-backgroundColor", backgroundColor);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-textColor")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-textColor");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-backgroundColor")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-backgroundColor");
    }
  }
  
  if (backgroundImageStyle != '') {
    gPref.setCharPref("extensions.speeddial.group-" + targetGroup + "-backImage", backgroundImageStyle);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-backImage")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-backImage");
    }
  }
  
  if (advancedStyle != '') {
    gPref.setCharPref("extensions.speeddial.group-" + targetGroup + "-style", advancedStyle);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-style")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-style");
    }
  }
  
  if (font != '') {
    gPref.setCharPref("extensions.speeddial.group-" + targetGroup + "-font", font);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-font")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-font");
    }
  }
  
  if (hideUnused) {
    gPref.setBoolPref("extensions.speeddial.group-" + targetGroup + "-hideUnused", true);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-hideUnused")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-hideUnused");
    }
  }
  
  if (customSizeDefine) {
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-minimumWidth", minimumWidth);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-minimumHeight", minimumHeight);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-maximumWidth", maximumWidth);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-maximumHeight", maximumHeight);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-widthModifier", widthModifier);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-heightModifier", heightModifier);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-widthModifierType", widthModifierType);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-heightModifierType", heightModifierType);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-minimumWidth")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-minimumWidth");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-minimumHeight")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-minimumHeight");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-maximumWidth")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-maximumWidth");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-maximumHeight")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-maximumHeight");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-widthModifier")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-widthModifier");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-heightModifier")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-heightModifier");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-widthModifierType")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-widthModifierType");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-heightModifierType")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-heightModifierType");
    }
  }
  
  if (addingGroup) {
    // Increase number of groups preference
    gPref.setIntPref("extensions.speeddial.numGroups", targetGroup);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-rows", rows);
    gPref.setIntPref("extensions.speeddial.group-" + targetGroup + "-columns", columns);
  } else {
    SpeedDialUtils.setNewGroupSize(targetGroup, rows, columns);
  }
  SpeedDialUtils.automaticBackup();
  return true;
}

function onCancel(event) {
  // Do nothing
  
  return true;
}

function useCustomColorsChanged() {
  if (document.getElementById("useCustomColors").checked) {
    document.getElementById("textColorLabel").disabled = false;
    document.getElementById("textColor").disabled = false;
    document.getElementById("textColorText").disabled = false;
    document.getElementById("backgroundColorLabel").disabled = false;
    document.getElementById("backgroundColor").disabled = false;
    document.getElementById("backgroundColorText").disabled = false;
  } else {
    document.getElementById("textColorLabel").disabled = true;
    document.getElementById("textColor").disabled = true;
    document.getElementById("textColorText").disabled = true;
    document.getElementById("backgroundColorLabel").disabled = true;
    document.getElementById("backgroundColor").disabled = true;
    document.getElementById("backgroundColorText").disabled = true;
  }
}

function textColorChanged() {
  var textColorText = document.getElementById("textColorText");
  var textColor = document.getElementById("textColor");
  
  if (textColorText.value != textColor.color) {
    textColorText.value = textColor.color;
  }
}

function textColorTextChanged() {
  var textColorText = document.getElementById("textColorText");
  var textColor = document.getElementById("textColor");
  
  if (textColorText.value != textColor.color) {
    textColor.color = textColorText.value;
  }
}

function backgroundColorChanged() {
  var backgroundColorText = document.getElementById("backgroundColorText");
  var backgroundColor = document.getElementById("backgroundColor");
  
  if (backgroundColorText.value != backgroundColor.color) {
    backgroundColorText.value = backgroundColor.color;
  }
}

function backgroundColorTextChanged() {
  var backgroundColorText = document.getElementById("backgroundColorText");
  var backgroundColor = document.getElementById("backgroundColor");
  
  if (backgroundColorText.value != backgroundColor.color) {
    backgroundColor.color = backgroundColorText.value;
  }
}

function showAdditionalStyle() {
  openDialog("chrome://speeddial/content/additionalStyle.xul", "",
             "centerscreen,chrome,dialog,resizable,modal", backgroundImageStyle, advancedStyle, font);
}

function processAdditionalStyleOutput(newBackgroundImageStyle, newAdvancedStyle, newFont) {
  backgroundImageStyle = newBackgroundImageStyle;
  advancedStyle = newAdvancedStyle;
  font = newFont;
}

function processCustomSizeOutput(
  newMinimumWidth,
  newMinimumHeight,
  newMaximumWidth,
  newMaximumHeight,
  newWidthModifier,
  newHeightModifier,
  newWidthModifierType,
  newHeightModifierType) {
    minimumWidth = newMinimumWidth;
    minimumHeight = newMinimumHeight;
    maximumWidth = newMaximumWidth;
    maximumHeight = newMaximumHeight;
    widthModifier = newWidthModifier;
    heightModifier = newHeightModifier;
    widthModifierType = newWidthModifierType;
    heightModifierType = newHeightModifierType;
}

function customSizeDefine() {
  openDialog("chrome://speeddial/content/customSizeDefine.xul", "",
             "centerscreen,chrome,dialog,resizable,modal",
             minimumWidth,
             minimumHeight,
             maximumWidth,
             maximumHeight,
             widthModifier,
             heightModifier,
             widthModifierType,
             heightModifierType);
}

function customSizeChanged() {
  if (document.getElementById("customSize").checked) {
    document.getElementById("customSizeButton").disabled = false;
  } else {
    document.getElementById("customSizeButton").disabled = true;
  }
}

