/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "ESourceProvider" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/libebook-ctypes.jsm");
Cu.import("resource://edsintegration/LibGLib.jsm");
Cu.import("resource://edsintegration/nsAbEDSCommon.jsm");
Cu.import("resource://edsintegration/LibEBookClient.jsm");
Cu.import("resource://edsintegration/LibESourceList.jsm");
Cu.import("resource://edsintegration/LibESourceGroup.jsm");
Cu.import("resource://edsintegration/LibESource.jsm");

var ESourceProvider = {

  _sourceListPtr: null,
  _ESourceUids: null,

  get ESourceUids() {
    if (!this._ESourceUids)
      this._loadDefaultUids();
    return this._ESourceUids;
  },

  set ESourceUids(aESourceArray) {
    this._ESourceUids = aESourceArray;
    this._loadSourceListPtr();
  },

  get sourceListPtr() {
    if (!this._sourceListPtr)
      this._loadSourceListPtr();

    return this._sourceListPtr;
  },

  _loadDefaultUids: function ESP__loadDefaultUids() {
    this._ESourceUids = [];

    this._loadSourceListPtr();

    let gslist = LibESourceList.peekGroups(this._sourceListPtr);
    for (let g = gslist; !g.isNull(); g = g.contents.next) {
      // Cast the data contents to an ESourceGroup
      let eSourceGroup = ctypes.cast(g.contents.data, LibESourceGroup.ESourceGroup.ptr);
      let sourcesList = LibESourceGroup.peekSources(eSourceGroup);
      for (let s = sourcesList; !s.isNull(); s = s.contents.next) {
        let eSource = ctypes.cast(s.contents.data, LibESource.ESource.ptr);
        let uid = LibESource.peekUid(eSource);
        this._ESourceUids.push(uid.readString());
      }
    }
  },

  _loadSourceListPtr: function ESP__loadDefaultUidPtr() {
    if (this._sourceListPtr)
      return;

    let listPtr = new LibESourceList.ESourceList.ptr();
    let errorPtr = new LibGLib.GError.ptr();
    if(!LibEBookClient.getSources(listPtr.address(), errorPtr.address())) {
      ERROR("Could not get default address books.  Error message was: "
            + errorPtr.contents.message.readString());
      LibGLib.g_error_free(errorPtr);
      errorPtr = null;
      return;
    }

    this._sourceListPtr = listPtr;
  }
}
